package com.artfess.manage.safty.model;

import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.manage.base.ManageBaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDate;

/**
 * cmgt_safty_plan_task
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-03
 */
@Data
@ApiModel(value="CmgtSaftyPlanTask对象", description="安全计划任务")
//@FieldRepeat(fields = {"code","name"},message = "名称不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
public class CmgtSaftyPlanTask extends ManageBaseModel<CmgtSaftyPlanTask> {


    /** 主键_ID */
    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    /** 所属计划 */
    @ApiModelProperty(value = "所属计划")
    @TableField("plan_id_")
    private String planId;

    /** 任务名称 */
    @ApiModelProperty(value = "任务名称")
    @TableField("name_")
    @NotBlank(message = "任务名称",groups = {AddGroup.class,UpdateGroup.class})
    private String name;

    /** 任务日期 */
    @ApiModelProperty(value = "任务日期")
    @TableField("task_date_")
    private LocalDate taskDate;

    /** 工作描述 */
    @ApiModelProperty(value = "工作描述")
    @TableField("description_")
    private String description;

    /** 依据 */
    @ApiModelProperty(value = "依据")
    @TableField("according_")
    private String according;

    /** 责任人 */
    @ApiModelProperty(value = "责任人")
    @TableField("task_user_")
    private String taskUser;

    /** 排序 */
    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

    /** 备注 */
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

}
