package com.artfess.manage.safty.manager.impl;


import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.base.ManageCommonService;
import com.artfess.manage.safty.dao.CmgtSaftyTrainingRecordDetailDao;
import com.artfess.manage.safty.manager.CmgtSaftyTrainingRecordDetailManager;
import com.artfess.manage.safty.manager.dto.CmgtSaftyTrainingRecordDetailDto;
import com.artfess.manage.safty.manager.mapper.CmgtSaftyTrainingRecordDetailDtoMapper;
import com.artfess.manage.safty.model.CmgtSaftyTrainingRecordDetail;
import com.artfess.uc.dao.UserDao;
import com.artfess.uc.model.User;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;



/**
 * 安全培训记录人员明细 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-03
 */
@Service
public class CmgtSaftyTrainingRecordDetailManagerImpl extends BaseManagerImpl<CmgtSaftyTrainingRecordDetailDao, CmgtSaftyTrainingRecordDetail> implements CmgtSaftyTrainingRecordDetailManager {

    @Resource
    private UserDao userDao;

    @Resource
    private CmgtSaftyTrainingRecordDetailDao cmgtSaftyTrainingRecordDetailDao;

    @Resource
    private CmgtSaftyTrainingRecordDetailDtoMapper cmgtSaftyTrainingRecordDetailDtoMapper ;

    @Resource
    private ManageCommonService manageCommonService;


    @Override
    public PageList<CmgtSaftyTrainingRecordDetailDto> pageQuery(QueryFilter<CmgtSaftyTrainingRecordDetail> queryFilter) {
        PageList<CmgtSaftyTrainingRecordDetail> result = query(queryFilter);
        PageList<CmgtSaftyTrainingRecordDetailDto> r = new PageList<CmgtSaftyTrainingRecordDetailDto>(
                result.getRows().stream().map(e -> {
                            CmgtSaftyTrainingRecordDetailDto t = cmgtSaftyTrainingRecordDetailDtoMapper.toDto(e);
                                    t.setTrainingIdName(manageCommonService.getfindSelectOptionsLabel("cmgtSaftySelectOptions.getCmgtSaftyTrainingRecords","value","label",t.getTrainingId()));


                            if(e.getCreateBy()!=null){
                               User user = userDao.selectById(e.getCreateBy());
                               if(user!=null){
                                   t.setCreateByName(user.getFullname());
                               }
                            }

                            return t;
                        }
                ).collect(Collectors.toList())
        );
        r.setTotal(result.getTotal());
        r.setPage(result.getPage());
        r.setPageSize(result.getPageSize());
        return r;
    }

    @Override
    public String createInfo(CmgtSaftyTrainingRecordDetail t) {
        int i = this.baseMapper.insert(t);
        if(i>0){
            return t.getId();
        }
        return null;
    }

    @Override
    public String updateInfo(CmgtSaftyTrainingRecordDetail t) {
        this.baseMapper.updateById(t);
        return t.getId();
    }

    @Override
    public void deleteInfo(CmgtSaftyTrainingRecordDetail t) {
        this.baseMapper.deleteById(t.getId());
    }


    public String create(CmgtSaftyTrainingRecordDetailDto dto) {
        CmgtSaftyTrainingRecordDetail t = cmgtSaftyTrainingRecordDetailDtoMapper.toEntity(dto);
        int i = this.baseMapper.insert(t);
        if (i > 0) {
            return t.getId();
        }
        return null;
    }


    public String update(CmgtSaftyTrainingRecordDetailDto dto) {
        CmgtSaftyTrainingRecordDetail t = cmgtSaftyTrainingRecordDetailDtoMapper.toEntity(dto);
        this.baseMapper.updateById(t);


        return t.getId();
    }

    public boolean delete(List<String> ids) {
        for (String id : ids) {

            int count = this.baseMapper.deleteById(id);
            if (count == 0) {
                return false;
            }
        }
        return true;
    }



    /**
     *
     * @param trainingId
     * @return
     */
    public List<CmgtSaftyTrainingRecordDetail> selectListByTrainingId(String trainingId) {
        QueryWrapper<CmgtSaftyTrainingRecordDetail> queryWrapper = new QueryWrapper();
        queryWrapper.eq("training_id_", trainingId);
        return cmgtSaftyTrainingRecordDetailDao.selectList(queryWrapper);
    }

}
