package com.artfess.manage.safty.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.manage.safty.dao.CmgtSaftyCheckDao;
import com.artfess.manage.safty.manager.CmgtSaftyCheckItemManager;
import com.artfess.manage.safty.manager.CmgtSaftyCheckManager;
import com.artfess.manage.safty.manager.CmgtSaftyTargetManager;
import com.artfess.manage.safty.model.CmgtSaftyCheck;
import com.artfess.manage.safty.model.CmgtSaftyCheckItem;
import com.artfess.manage.safty.model.CmgtSaftyTarget;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 安全目标考核评分(CmgtSaftyCheck)表服务实现类
 *
 * @author 黎沐华
 * @since 2023-05-05 09:23:15
 */
@Service("cmgtSaftyCheckService")
public class CmgtSaftyCheckManagerImpl extends BaseManagerImpl<CmgtSaftyCheckDao, CmgtSaftyCheck> implements CmgtSaftyCheckManager {

    @Resource
    private CmgtSaftyCheckItemManager itemManager;
    @Resource
    private CmgtSaftyTargetManager targetManager;

    @Override
    public PageList<CmgtSaftyCheck> query(QueryFilter<CmgtSaftyCheck> queryFilter) {
        List<CmgtSaftyCheckItem> details = itemManager.list();
        PageList<CmgtSaftyCheck> result = super.query(queryFilter);
        result.getRows().forEach(r ->
                r.getDetail().addAll(details.stream()
                        .filter(d -> r.getId().equals(d.getInfoId()))
                        .collect(Collectors.toList())));
        return result;
    }

    @Override
    public boolean save(CmgtSaftyCheck entity) {
        calScore(entity);
        boolean result = super.save(entity);
        if (BeanUtils.isNotEmpty(entity.getDetail())) {
            entity.getDetail().forEach(d -> d.setInfoId(entity.getId()));
            itemManager.saveBatch(entity.getDetail());
        }
        return result;
    }

    @Override
    public boolean updateById(CmgtSaftyCheck entity) {
        calScore(entity);
        return super.updateById(entity);
    }

    private void calScore(CmgtSaftyCheck entity) {
        CmgtSaftyTarget target = targetManager.getById(entity.getTargetId());
        BigDecimal checkScore = new BigDecimal(0);
        if (BeanUtils.isNotEmpty(entity.getDetail()) && BeanUtils.isNotEmpty(target.getDetail())) {
            entity.getDetail().forEach(ed -> {
                target.getDetail().forEach(td -> {
                    if (ed.getItemId().equals(td.getId())) {
                        BigDecimal itemResult = new BigDecimal(null == ed.getItemScore() ? 0 : ed.getItemScore()).multiply(new BigDecimal(null == td.getCheckWeight() ? 0 : td.getCheckWeight()));
                        ed.setItemResult(itemResult);
                        checkScore.add(itemResult);
                    }
                });
            });
        }
        entity.setCheckScore(checkScore);
    }

    @Override
    public void removeByIds(String... ids) {
        List<String> detailIds = itemManager
                .list(new QueryWrapper<CmgtSaftyCheckItem>().in("target_year_", ids))
                .stream()
                .map(CmgtSaftyCheckItem::getId)
                .collect(Collectors.toList());
        itemManager.removeByIds(detailIds);
        super.removeByIds(ids);
    }

}

