package com.artfess.manage.material.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 采购订单关联表-需求申请
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-04-24
 */
@Data
@ApiModel(value="CmgtMaterialPurchasingOrder对象", description="采购订单关联表-需求申请")
public class CmgtMaterialPurchasingOrder extends BaseModel<CmgtMaterialPurchasingOrder> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "采购订单_ID")
    @TableField("plan_id_")
    private String planId;

    @ApiModelProperty(value = "采购需求申请单_ID")
    @TableField("purchasing_id_")
    private String purchasingId;

}
