package com.artfess.manage.dwd.manager.impl;


import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.base.ManageCommonService;
import com.artfess.manage.dwd.dao.DwdSjWeatherForcastMiDao;
import com.artfess.manage.dwd.manager.DwdSjWeatherForcastMiManager;
import com.artfess.manage.dwd.manager.dto.DwdSjWeatherForcastMiDto;
import com.artfess.manage.dwd.manager.mapper.DwdSjWeatherForcastMiDtoMapper;
import com.artfess.manage.dwd.model.DwdSjWeatherForcastMi;
import com.artfess.uc.dao.UserDao;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;



/**
 * 来自互联网心知天气的天气预报 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-21
 */
@Service
public class DwdSjWeatherForcastMiManagerImpl extends BaseManagerImpl<DwdSjWeatherForcastMiDao, DwdSjWeatherForcastMi> implements DwdSjWeatherForcastMiManager {

    @Resource
    private UserDao userDao;

    @Resource
    private DwdSjWeatherForcastMiDao dwdSjWeatherForcastMiDao;

    @Resource
    private DwdSjWeatherForcastMiDtoMapper dwdSjWeatherForcastMiDtoMapper ;

    @Resource
    private ManageCommonService manageCommonService;


    @Override
    public PageList<DwdSjWeatherForcastMiDto> pageQuery(QueryFilter<DwdSjWeatherForcastMi> queryFilter) {
        PageList<DwdSjWeatherForcastMi> result = query(queryFilter);
        PageList<DwdSjWeatherForcastMiDto> r = new PageList<DwdSjWeatherForcastMiDto>(
                result.getRows().stream().map(e -> {
                            DwdSjWeatherForcastMiDto t = dwdSjWeatherForcastMiDtoMapper.toDto(e);




                            return t;
                        }
                ).collect(Collectors.toList())
        );
        r.setTotal(result.getTotal());
        r.setPage(result.getPage());
        r.setPageSize(result.getPageSize());
        return r;
    }

    @Override
    public String createInfo(DwdSjWeatherForcastMi t) {
        int i = this.baseMapper.insert(t);
        if(i>0){
            return t.getId();
        }
        return null;
    }

    @Override
    public String updateInfo(DwdSjWeatherForcastMi t) {
        this.baseMapper.updateById(t);
        return t.getId();
    }

    @Override
    public void deleteInfo(DwdSjWeatherForcastMi t) {
        this.baseMapper.deleteById(t.getId());
    }


    public String create(DwdSjWeatherForcastMiDto dto) {
        DwdSjWeatherForcastMi t = dwdSjWeatherForcastMiDtoMapper.toEntity(dto);
        int i = this.baseMapper.insert(t);
        if (i > 0) {
            return t.getId();
        }
        return null;
    }


    public String update(DwdSjWeatherForcastMiDto dto) {
        DwdSjWeatherForcastMi t = dwdSjWeatherForcastMiDtoMapper.toEntity(dto);
        this.baseMapper.updateById(t);


        return t.getId();
    }

    public boolean delete(List<String> ids) {
        for (String id : ids) {

            int count = this.baseMapper.deleteById(id);
            if (count == 0) {
                return false;
            }
        }
        return true;
    }




}
