package com.artfess.manage.dwd.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.manage.dwd.manager.DwdSjManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * 来自互联网心知天气的天气预报 前端控制器
 *
 * @author yuanhc
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-09-21
 */
@Slf4j
@Api(tags = "数据中台应用")
@RestController
@RequestMapping("/manager/dwdSj")
@ApiGroup(group = {ApiGroupConsts.MANAGER_BIZ})
public class DwdSController {

    @Autowired
    private DwdSjManager dwdSjManager;

    @PostMapping(value = "/query/findWeatherForcastMi", produces = {"application/json; charset=utf-8"})
    @ApiOperation("按时间段查询天气预报")
    public CommonResult<String> findTeamMemberArrangeing(@ApiParam(name = "model", value = "查询条件") @RequestBody Map<String, Object> params) {
        return CommonResult.success(
                dwdSjManager.findWeatherForcastMi(params.get("startDate").toString(), params.get("endDate").toString())
                , null
        );
    }

}
