package com.artfess.base.conf;

import io.netty.channel.Channel;
import io.netty.channel.ChannelId;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.concurrent.GlobalEventExecutor;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author 陈实
 * @Package com.artfess.base.conf
 * @date 2021/9/16 9:52
 * @Description:
 */
public class NettyConfig {
    /**
     * 定义一个channel组，管理所有的channel
     * GlobalEventExecutor.INSTANCE 是全局的事件执行器，是一个单例
     */
    private static ChannelGroup channelGroup = new DefaultChannelGroup(GlobalEventExecutor.INSTANCE);

    /**
     * 存放用户与ChanelID的对应关系，用于给指定用户发送消息
     */
    private static ConcurrentHashMap<String, Set<ChannelId>> userChanIdMap = new ConcurrentHashMap<>();
    /**
     * 存放子程序与ChanelID的对应关系
     */
    private static ConcurrentHashMap<String, String> subroutineChanIdMap = new ConcurrentHashMap<>();

    private NettyConfig() {}

    /**
     * 获取channel组
     * @return
     */
    public static ChannelGroup getChannelGroup() {
        return channelGroup;
    }

    public static ConcurrentHashMap<String, Set<ChannelId>> getUserChanIdMap() {
        return userChanIdMap;
    }

    public static ConcurrentHashMap<String, String> getSubroutineChanIdMap() {
        return subroutineChanIdMap;
    }
}
