/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.table.operator.impl.mysql;

import com.artfess.base.util.StringUtil;
import com.artfess.table.model.Index;
import com.artfess.table.model.impl.DefaultIndex;
import com.artfess.table.operator.impl.BaseIndexOperator;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowMapper;

public class MySQLIndexOperator
extends BaseIndexOperator {
    protected int BATCH_SIZE = 100;

    @Override
    public void createIndex(Index index) throws SQLException {
        String sql = this.genIndexDDL(index);
        this.jdbcTemplate.execute(sql);
        index.setIndexDdl(sql);
    }

    private String genIndexDDL(Index index) {
        StringBuffer ddl = new StringBuffer();
        ddl.append("CREATE");
        if (StringUtil.isNotEmpty((String)index.getIndexType())) {
            ddl.append(" " + index.getIndexType() + " ");
        }
        ddl.append(" INDEX");
        ddl.append(" " + index.getIndexName());
        ddl.append(" ON " + index.getTableName());
        ddl.append("(");
        for (String column : index.getColumnList()) {
            ddl.append(column + ",");
        }
        if (!StringUtils.isEmpty((String)index.getIndexComment())) {
            ddl.append("COMMENT '" + index.getIndexComment() + "'");
        }
        ddl.replace(ddl.length() - 1, ddl.length(), ")");
        return ddl.toString();
    }

    @Override
    public void dropIndex(String tableName, String indexName) {
        String sql = "drop index " + indexName + " on " + tableName;
        this.jdbcTemplate.execute(sql);
    }

    @Override
    public void rebuildIndex(String tableName, String indexName) {
        String sql = "SHOW CREATE TABLE " + tableName;
        List ddls = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString("Create Table");
            }
        });
        String ddl = (String)ddls.get(0);
        Pattern pattern = Pattern.compile("ENGINE\\s*=\\s*\\S+", 2);
        Matcher matcher = pattern.matcher(ddl);
        if (matcher.find()) {
            String str = matcher.group();
            String sql_ = "ALTER TABLE " + tableName + " " + str;
            this.jdbcTemplate.execute(sql_);
        }
    }

    @Override
    public List<Index> getIndexByName(String indexName) throws SQLException {
        List<String> allTableNames = this.getAllTableNames();
        ArrayList<Index> allIndexs = new ArrayList<Index>();
        for (String tableName : allTableNames) {
            allIndexs.addAll(this.getIndexsByTable(tableName));
        }
        ArrayList<Index> indexs = new ArrayList<Index>();
        for (Index index : allIndexs) {
            if (!index.getIndexName().contains(indexName)) continue;
            indexs.add(index);
        }
        return indexs;
    }

    @Override
    public List<Index> getIndexsByTable(String tableName) throws SQLException {
        String sql = new String("show index from ?tableName;");
        sql = sql.replace("?tableName", tableName);
        List rows = this.jdbcTemplate.queryForList(sql);
        ArrayList<String> indexNames = new ArrayList<String>();
        ArrayList<Index> indexs = new ArrayList<Index>();
        for (Map row : rows) {
            String indexName = row.get("Key_name") + "";
            if (indexNames.contains(indexName)) continue;
            indexNames.add(indexName);
            indexs.add(this.getIndex(tableName, indexName));
        }
        return indexs;
    }

    @Override
    public Index getIndex(String tableName, String indexName) throws SQLException {
        String sql = new String("show index from ?tableName where key_name='?indexName';");
        sql = sql.replace("?tableName", tableName);
        sql = sql.replace("?indexName", indexName);
        List rows = this.jdbcTemplate.queryForList(sql);
        Index index = null;
        ArrayList<String> columnList = new ArrayList<String>();
        for (Map row : rows) {
            if (index == null) {
                index = new DefaultIndex();
                index.setPkIndex(indexName.equals("PRIMARY"));
                index.setIndexComment(row.get("Comment") + "");
                index.setIndexName(row.get("Key_name") + "");
                index.setIndexType(row.get("Index_type") + "");
                index.setTableName(tableName);
                index.setUnique((row.get("Non_unique") + "").equals("0"));
            }
            columnList.add(row.get("Column_name") + "");
        }
        if (index != null) {
            index.setColumnList(columnList);
        }
        return index;
    }

    private List<String> getAllTableNames() {
        ArrayList<String> tableNames = new ArrayList<String>();
        String sql = "show tables;";
        List rows = this.jdbcTemplate.queryForList(sql);
        for (Map row : rows) {
            for (Object object : row.values()) {
                tableNames.add(object + "");
            }
        }
        return tableNames;
    }
}

