/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.specialproject.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.file.util.MinioUtil;
import com.artfess.yhxt.specialproject.dao.BizProjectBiddingDao;
import com.artfess.yhxt.specialproject.manager.BizEngineeringAccessoriesManager;
import com.artfess.yhxt.specialproject.manager.BizProjectBiddingManager;
import com.artfess.yhxt.specialproject.model.BizEngineeringAccessories;
import com.artfess.yhxt.specialproject.model.BizProjectBidding;
import com.artfess.yhxt.specialproject.vo.BizProjectBiddingVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BizProjectBiddingManagerImpl
extends BaseManagerImpl<BizProjectBiddingDao, BizProjectBidding>
implements BizProjectBiddingManager {
    @Resource
    private BizEngineeringAccessoriesManager bizEngineeringAccessoriesManager;

    @Override
    public PageList<BizProjectBidding> queryBizProjectBidding(QueryFilter<BizProjectBidding> queryFilter) {
        IPage<BizProjectBidding> result = ((BizProjectBiddingDao)this.baseMapper).queryBizProjectBidding((IPage<BizProjectBidding>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizProjectBidding>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public BizProjectBidding getBizProjectBiddingById(String id) {
        BizProjectBidding bizProjectBidding = (BizProjectBidding)((Object)((BizProjectBiddingDao)this.baseMapper).selectById((Serializable)((Object)id)));
        return bizProjectBidding;
    }

    @Override
    public String minioUpload(MultipartFile file) {
        String miniourl = MinioUtil.getMinioUrl();
        if (file.isEmpty() || file.getSize() == 0L) {
            throw new RuntimeException("\u6587\u4ef6\u4e3a\u7a7a");
        }
        String fileName = file.getOriginalFilename();
        String name = DigestUtils.md5Hex((String)UUID.randomUUID().toString()) + fileName.substring(fileName.lastIndexOf("."));
        String url = null;
        try {
            url = MinioUtil.uploadRelative((MultipartFile)file, (String)"/engineering", (String)name, (String)"yhxt");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return miniourl + url;
    }

    @Override
    public void saveVo(BizProjectBiddingVo bizProjectBiddingVo) {
        BizProjectBidding bizProjectBidding = bizProjectBiddingVo.getBizProjectBidding();
        this.create((Model)bizProjectBidding);
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = bizProjectBiddingVo.getBizEngineeringAccessoriesList();
        String sourceId = bizProjectBidding.getId();
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.bizEngineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);
    }

    @Override
    public void updateVo(BizProjectBiddingVo bizProjectBiddingVo) {
        BizProjectBidding bizProjectBidding = bizProjectBiddingVo.getBizProjectBidding();
        this.update((Model)bizProjectBidding);
        String sourceId = bizProjectBidding.getId();
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = bizProjectBiddingVo.getBizEngineeringAccessoriesList();
        this.bizEngineeringAccessoriesManager.removeEngineeringAccessories(sourceId);
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.bizEngineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);
    }

    @Override
    public BizProjectBiddingVo getVo(String id) {
        BizProjectBiddingVo bizProjectBiddingVo = new BizProjectBiddingVo();
        BizProjectBidding bizProjectBidding = (BizProjectBidding)((Object)this.getById((Serializable)((Object)id)));
        List<BizEngineeringAccessories> engineeringAccessories = this.bizEngineeringAccessoriesManager.getEngineeringAccessoriesBySourceId(id);
        bizProjectBiddingVo.setBizProjectBidding(bizProjectBidding);
        bizProjectBiddingVo.setBizEngineeringAccessoriesList(engineeringAccessories);
        return bizProjectBiddingVo;
    }
}

