/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.specialproject.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.specialproject.manager.ProjectContractPaymentManager;
import com.artfess.yhxt.specialproject.model.ProjectContractPayment;
import com.artfess.yhxt.specialproject.vo.ProjectContractPaymentVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/projectContractPayment/v1/"})
@Api(tags={"\u9879\u76ee\u5408\u540c\u652f\u4ed8\u660e\u7ec6\u63a5\u53e3"})
@ApiGroup(group={"group_biz"})
public class ProjectContractPaymentController
extends BaseController<ProjectContractPaymentManager, ProjectContractPayment> {
    @Resource
    private BaseContext baseContext;

    @RequestMapping(value={"getJson"}, method={RequestMethod.POST}, produces={"application/json;charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u9879\u76ee\u5408\u540c\u652f\u4ed8\u4fe1\u606f", httpMethod="POST")
    public PageList<ProjectContractPayment> getJson(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ProjectContractPayment> queryFilter) {
        queryFilter.addFilter("is_dele_", (Object)"0", QueryOP.EQUAL);
        if (StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId())) {
            // empty if block
        }
        PageList<ProjectContractPayment> pageList = ((ProjectContractPaymentManager)this.baseService).queryProjectContractPayment(queryFilter);
        return pageList;
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58,\u4fee\u6539\u9879\u76ee\u9879\u76ee\u5408\u540c\u652f\u4ed8", httpMethod="POST")
    public CommonResult<String> save(@ApiParam(name="projectContractPayment", value="\u9879\u76ee\u5408\u540c\u652f\u4ed8\u660e\u7ec6\u5bf9\u8c61") @RequestBody List<ProjectContractPayment> paymentList, @ApiParam(name="contractId", value="\u5408\u540cID", required=true) @RequestParam(value="contractId", required=true) String contractId) throws Exception {
        String msg = "\u6dfb\u52a0\u6210\u529f";
        if (paymentList.size() > 0) {
            ((ProjectContractPaymentManager)this.baseService).createProjectContractPayment(paymentList, contractId);
        }
        return new CommonResult(msg);
    }

    @RequestMapping(value={"/deleteProjectContractPayment"}, method={RequestMethod.DELETE}, produces={"application/json;charset=utf-8"})
    @ApiOperation(value="\u903b\u8f91\u5220\u9664\u9879\u76ee\u5408\u540c\u652f\u4ed8\u660e\u7ec6", httpMethod="DELETE", notes="\u903b\u8f91\u5220\u9664\u9879\u76ee\u5408\u540c\u652f\u4ed8\u660e\u7ec6")
    public CommonResult<String> deleteProjectContractPayment(@ApiParam(name="ids", value="ID\u96c6\u5408\u4ee5\uff0c\u9694\u5f00", required=true) @RequestParam(value="ids", required=true) String ids) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.in((Object)"ID_", idsList);
            updateWrapper.set((Object)"is_dele_", (Object)"1");
            ((ProjectContractPaymentManager)this.baseService).update(null, (Wrapper)updateWrapper);
        }
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/importDatePay"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165\u9879\u76ee\u5408\u540c\u652f\u4ed8\u660e\u7ec6", httpMethod="POST", notes="\u6279\u91cf\u5bfc\u5165\u9879\u76ee\u5408\u540c\u652f\u4ed8\u660e\u7ec6")
    public CommonResult<String> importDatePay(@ApiParam(name="file", value="\u9879\u76ee\u4ea4\u5de5\u652f\u4ed8\u660e\u7ec6\u6587\u4ef6") @RequestBody MultipartFile file, @ApiParam(name="contractId", value="\u9879\u76eeID") String contractId) throws Exception {
        ((ProjectContractPaymentManager)this.baseService).importDatePay(file, contractId);
        return new CommonResult("\u5bfc\u5165\u6210\u529f");
    }

    @GetMapping(value={"get/{contractId}"})
    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u9879\u76ee\u5408\u540c\u652f\u4ed8\u660e\u7ec6", httpMethod="GET", notes="\u6839\u636eID\u67e5\u8be2\u9879\u76ee\u5408\u540c\u652f\u4ed8\u660e\u7ec6")
    public ProjectContractPaymentVo get(@ApiParam(name="contractId", value="\u9879\u76ee\u5408\u540c\u4e3b\u952eid", required=true) @PathVariable String contractId) throws Exception {
        return ((ProjectContractPaymentManager)this.baseService).getVo(contractId);
    }

    @RequestMapping(value={"/downTemplate"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165\u9879\u76ee\u5408\u540c\u652f\u4ed8\u660e\u7ec6\u6a21\u677f\u4e0b\u8f7d", httpMethod="POST", notes="\u6279\u91cf\u5bfc\u5165\u9879\u76ee\u5408\u540c\u652f\u4ed8\u660e\u7ec6\u6a21\u677f\u4e0b\u8f7d")
    public void downTemplate(HttpServletResponse response) throws Exception {
        ((ProjectContractPaymentManager)this.baseService).downTemplate(response);
    }

    @RequestMapping(value={"/exportDatePay"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u9879\u76ee\u5408\u540c\u652f\u4ed8\u660e\u7ec6", httpMethod="POST", notes="\u5bfc\u51fa\u9879\u76ee\u5408\u540c\u652f\u4ed8\u660e\u7ec6")
    public void exportDatePay(@ApiParam(name="ids", value="ID\u96c6\u5408\u4ee5\uff0c\u9694\u5f00") @RequestParam(value="ids", required=true) String ids, HttpServletResponse response) throws Exception {
        ((ProjectContractPaymentManager)this.baseService).exportDatePay(ids, response);
    }
}

