import req from '@/request.js'
import utils from '@/utils.js'
// import sat from '@/api/satisfaction/satisfaction'
// import pilot from '@/api/pilotprojects'
const portal = window.context.portal
export const TableMixin = {
    data() {
        return {
            tableMaxHeight: 600,
            showMore: false,
            header: {
                Authorization: `Bearer ${this.$store.state.login.currentUser.token}`
            },
            deleteIds: '',
            tableData: [],
            loading: false,
            searchPanel: 0,
        }
    },
    mounted() {
        this.calcTableHeight()
        this.$root.$on('resize', () => {
            this.calcTableHeight(500)
        })
    },
    created() {

    },
    methods: {
        //添加
        handleAdd() {
            this.$refs.form.open()
        },
        handleEdit(row) {
            // this.$refs.form.open(row, 'edit')
        },
        handleDetail(row) {
            // this.$refs.form.open(row, 'detail')
        },
        //获取删除数据id集合
        handleSelectionChange(val) {
            if (!val.length) {
                this.deleteIds = ''
                return
            }
            let arr = val.map((item) => item.id)
            this.deleteIds = arr.join(',')
        },
        // 获取字典值翻译
        getDictName(code, value) {
            return utils.getDictName(code, value)
        },
        calcTableHeight(delay) {
            // 动态计算表格的高度，自适应当前容器
            setTimeout(() => {
                if (!this.$refs.contentPanel) {
                    return
                }
                // 容器高度 - 内边距
                let contentPanel = 0
                const contentPanelHeight =
                    this.$refs.contentPanel.clientHeight ||
                    this.$refs.contentPanel.$el.clientHeight
                contentPanel = contentPanelHeight
                this.searchPanel = contentPanel
            }, delay || 0)
        },
        commonPageClick() {
            if (this.showMore) {
                this.showMore = false
            }
        },
        // 展开高级搜索
        advanced() {
            this.isAdvanced = !this.isAdvanced
            this.$nextTick(() => {
                this.calcTableHeight(500)
            })
        },
        clearSearchForm() {
            this.advanced()
            this.isAdvanced = false
            this.searchForm = {}
            if (this.slefClearMethods) {
                this.slefClearMethods()
            }
            this.handleSearch()
        },
        // 分页
        handleCurrentChange(page) {
            this.params.pageBean.page = page
            this.loadData()
        },
        handleSizeChange(pageSize) {
            this.params.pageBean.pageSize = pageSize
            this.loadData(1)
        },


    }
}
