import req from "@/request.js";
const portal = window.context.portal;
export default {
    // 获取排班信息
    queryWorkUser(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/bizRankUser/v1/query`, data).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 获取某月的排班信息
    queryMonthWorkUser(queryDate,tollStationId,rankGroupId) {
        return new Promise((resolve, reject) => {
            if(rankGroupId){
                req.get(portal + `/bizRankUser/v1/findMonthArrangeInfo?queryDate=`+queryDate+'&tollStationId='+tollStationId+'&rankGroupId='+rankGroupId).then(
                    res => {
                        resolve(res)
                    },
                    error => {
                        reject(error)
                    }
                )
            }else{
                 req.get(portal + `/bizRankUser/v1/findMonthArrangeInfo?queryDate=`+queryDate+'&tollStationId='+tollStationId).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                }
            ) 
            }
          
        })
    },
    //提交
    batchSubmit(dialogForm, cb) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/bizRankUser/v1/save` ,dialogForm).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
     //批量添加
        batchAdd(dialogForm, cb) {
            return new Promise((resolve, reject) => {
                req.post(portal + `/bizRankUser/v1/saveList` ,dialogForm).then(
                    res => {
                        resolve(res)
                    },
                    error => {
                        reject(error)
                    });
            })
        },
    // 批量删除
    batchDelete(deleteIds, cb) {
        return new Promise((resolve, reject) => {
            req.remove(portal +'/bizRankUser/v1/?ids=' + deleteIds).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
    // 根据id删除
    deleteOne(deleteId, cb) {
        return new Promise((resolve, reject) => {
            req.remove(portal +'/bizRankUser/v1/' + deleteId).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
}