import Vue from 'vue'
import Router from 'vue-router'
import store from '@/store'
import NotFound from '@/views/NotFound.vue'
import Login from '@/views/Login.vue'
import NoAuth from '@/views/NoAuth.vue'
import req from '@/request.js'
import qs from 'qs'
import uc from '@/api/uc.js'
import portal from '@/api/portal.js'
import { Message } from 'element-ui'
import { Loading } from 'element-ui'

//路由
import mainRouter from '@/module_router.js'
import Layout from '@/components/layout/Layout.vue'
// import { component } from 'vue/types/umd'

Vue.use(Router)

var router = new Router({
    mode: 'history',
    base: process.env.BASE_URL,
    routes: [
        {
            path: '/',
            redirect: {
                name: 'login'
            }
        },
        {
            path: '/login',
            name: 'login',
            component: Login,
            meta: {
                single: true,
                anonymous: true
            }
        },
        {
            path: '/auth',
            name: 'auth',
            component: () => import('@/views/Auth.vue'),
            meta: {
                single: true,
                anonymous: true
            }
        },
        {
            path: '/testPlayer',
            name: 'testPlayer',
            component: () => import('@/views/testPlayer.vue'),
            meta: {
                single: true,
                anonymous: true
            }
        },
        {
            path: '/NoAuth',
            name: 'NoAuth',
            component: NoAuth,
            meta: {
                single: true,
                anonymous: true
            }
        },
        {
            path: '/resetPwdView',
            name: 'resetPwdView',
            props: true,
            component: () => import('@/views/ResetPwdView.vue'),
            meta: {
                single: true,
                anonymous: true
            }
        },
        {
            path: '*',
            component: NotFound,
            meta: {
                single: true
            }
        },
        {
            path: '/platLayout',
            name: 'platLayout',
            component: Layout,
            meta: {
                single: true,
                anonymous: true
            },
            children: [
                {
                    path: 'PersonalInfo',
                    name: 'PersonalInfoInner',
                    props: true,
                    component: () => import('@/views/PersonalInfo.vue')
                },
                {
                    path: 'resetPwdView',
                    name: 'resetPwdViewInner',
                    props: true,
                    component: () => import('@/views/ResetPwdView.vue')
                },
                ...mainRouter
            ]
        },
        {
            path: '/balanceOverview',
            name: 'balanceOverview',
            component: () => import('@/views/BigScreen/balanceOverview.vue'),
            meta: {
                keepAlive: true
            }
        },
        {
            path: '/operationFees',
            name: 'operationFees',
            component: () => import('@/views/BigScreen/operationFees.vue'),
            meta: {
                keepAlive: true
            }
        },
        {
            path: '/deviceMonitor',
            name: 'deviceMonitor',
            component: () => import('@/views/BigScreen/deviceMonitor.vue'),
            meta: {
                keepAlive: true
            }
        },
        {
            path: '/itResources',
            name: 'itResources',
            component: () => import('@/views/BigScreen/itResources.vue'),
            meta: {
                keepAlive: true
            }
        },
        {
            path: '/homePage',
            name: 'homePage',
            component: () => import('@/views/BigScreen/homePage.vue'),
            meta: {
                keepAlive: true,
                // iframe: false  // iframe页面缓存使用true
            }
        },
        {
            path: '/trafficReportAI',
            name: 'trafficReportAI',
            component: () => import('@/views/BigScreen/trafficReportAI.vue'),
            meta: {
                keepAlive: true
            }
        },
        {
            path: '/vehicleReportAI',
            name: 'vehicleReportAI',
            component: () => import('@/views/BigScreen/vehicleReportAI.vue'),
            meta: {
                keepAlive: true
            }
        },
        {
            path: '/chargeDataReportAI',
            name: 'chargeDataReportAI',
            component: () => import('@/views/BigScreen/chargeDataReportAI.vue'),
            meta: {
                keepAlive: true
            }
        },
    ]
})

const createRouter = () =>
    new Router({
        mode: 'history',
        routes: []
    })

//重写动态添加路由方法
router.$addRoutes = params => {
    const newRouter = createRouter()
    router.matcher = newRouter.matcher //重置路由规则
    router.addRoutes(params) // 添加路由
}

//动态新增二级路由
router.addList = (path, list) => {
    let isAddPath = false
    let isChildren = false

    return isChildren
}

let registerRouteFresh = true

const ssoRedirect = () => {
    if (window.ssoConfig.mode == 'cas') {
        let service = window.location.href
        localStorage.setItem('service', service)
        window.location.href = window.ssoConfig.url + '?service=' + service
    } else if (window.ssoConfig.mode == 'oauth') {
        if (!window.ssoConfig.clientId) {
            throw 'oauth模式下必须提供clientId'
        }
        const service = window.location.href
        localStorage.setItem('service', service)
        window.location.href = `${window.ssoConfig.url}?response_type=code&client_id=${window.ssoConfig.clientId}&redirect_uri=${service}`
    }
}

const handelShortUrl = (to, from, next) => {
    req
        .get(
            '${portal}/portal/shorturlManage/v1/getLongUrlByShortUrl?shortUrl=' +
            to.fullPath.substr(1),
            '',
            false
        )
        .then(resp => {
            if (resp && resp.data && resp.data.state) {
                store
                    .dispatch(
                        'login/validAndCompletedCurrent',
                        resp.data.value.guestToken
                    )
                    .then(() => {
                        next({
                            path: resp.data.value.url
                        })
                    })
                    .catch(() => {
                        logoutAndCleanUp(to, from, next)
                    })
            } else {
                next({
                    path: '/messageFillPage/' + resp.data.message
                })
            }
        })
        .catch(() => {
            logoutAndCleanUp(to, from, next)
        })
}

const logoutAndCleanUp = (to, from, next) => {
    store.dispatch('login/logoutAndCleanUp').then(() => {
        if (window.ssoConfig.mode && window.ssoConfig.mode != 'jwt' && !ticket) {
            ssoRedirect()
        } else if (!window.ssoConfig.mode || window.ssoConfig.mode == 'jwt') {

            next({
                path: '/login'
                // query: {
                //     redirect: to.fullPath
                // }
            })
        } else {
            throw '登录失败'
        }
    })
}

// 移除url后面的指定参数
const removeUrlParams = param => {
    const query = window.location.search.substring(1)
    if (!query) {
        return
    }
    const vars = query.split('&')
    const newVars = []
    for (var i = 0; i < vars.length; i++) {
        var pair = vars[i].split('=')
        if (pair[0] != param) {
            newVars.push(vars[i])
        }
    }
    console.log(newVars)
    setTimeout(() => {
        const path = `${window.location.pathname}${newVars.length > 0 ? '?' : ''
            }${newVars.join('&')}`
        window.history.replaceState(null, null, path)
    }, 1000)
}


const tokenLoginBigScreen = (userInfo, next) => {
    store.dispatch('login/loginByPrincipal', userInfo).then((loginStatus) => {
        if (loginStatus && loginStatus == true) {
            portal.getSysDict().then((data) => {
                if (data) {
                    sessionStorage.setItem('dict_data', JSON.stringify(data))
                }
            })
            store.dispatch(
                'menu/getCurrentUserMethodAuth'
            )
            store
                .dispatch('menu/actionFrontMenus')
                .then((res) => {
                    if (!res || !res.length) {
                        this.$message.warning(
                            '抱歉！您尚无可访问页面，请联系管理员添加！'
                        )
                        next({
                            path: `/login`
                        })
                    }
                    let bigScreen =
                        res &&
                        res.filter(
                            (item) =>
                                item.alias === 'bigScreen'
                        )
                    // 如果用户有大屏菜单进去大屏页面
                    if (
                        bigScreen &&
                        bigScreen.length !== 0
                    ) {
                        next({
                            path: `/${bigScreen[0].children[0].alias}`
                        })
                    }
                    let dataMenus =
                        res &&
                        res.filter(
                            (item) =>
                                item.alias === 'normal'
                        )
                    if (
                        dataMenus &&
                        dataMenus.length !== 0
                    ) {
                        if (
                            dataMenus[0].children.length !==
                            0 &&
                            dataMenus[0].children[0]
                                .children.length
                        ) {
                            next({
                                path: `/platLayout/${dataMenus[0].children[0].children[0].alias}`,
                            })
                        } else {
                            next({
                                path: `/platLayout/${dataMenus[0].children[0].alias}`,
                            })
                        }
                    }
                })
        }
    })
}


router.beforeEach(async (to, from, next) => {
    if (to.name == 'login' && to.query.tokenKey) {
        let data = {
            key: to.query.tokenKey,
        }

        uc.authFormUserTokenKey(data).then((res) => {
            console.log(res)
            if (res.success) {
                tokenLoginBigScreen(
                    {
                        account: "tjadmin",
                        password: 'Bb123456789,.',
                    },
                    next,
                )
            } else {
                Message.error(res.msg)
                next({
                    path: '/login'
                })
            }

        })
            .catch(err => {

                next({
                    path: '/login'
                })




            })
    }


    if (to.fullPath.startsWith('/surl/')) {
        handelShortUrl(to, from, next)
        return
    }

    // 1.当前为单点登录模式，且要路由到login页面，则做单点登录重定向；
    if (
        to.name == 'login' &&
        window.ssoConfig.mode &&
        window.ssoConfig.mode != 'jwt'
    ) {
        // 单点登录时如果已经携带了code或者ticket时，如果是/login路径需要跳转到默认页面（解决反复跳转的问题）
        if (
            (window.ssoConfig.mode == 'cas' || window.ssoConfig.mode == 'oauth') &&
            (to.query.code || to.query.ticket)
        ) {
            window.location.href = window.location.href.replace('/login', '')
            return
        } else {
            ssoRedirect()
        }
    }

    if (from.name != 'defStart' || to.name != 'instStart') {
        sessionStorage.removeItem('formImportTempRefId')
        sessionStorage.removeItem('formImportTempJson')
    }

    if (
        sessionStorage.menu_alias &&
        to.fullPath &&
        to.fullPath.split('/')[1] == 'home'
    ) {
        sessionStorage.menu_alias = ''
    }
    if (to.matched.some(record => !record.meta.anonymous)) {
        let ticket = to.query.token
        // 2.当前已经从单点页面重定向回来了，且在url地址中携带了ticket或code；
        if (window.ssoConfig.mode == 'cas') {
            ticket = to.query.ticket
        } else if (window.ssoConfig.mode == 'oauth') {
            ticket = to.query.code
        }

        store
            // 3.携带ticket做用户鉴权；
            .dispatch('login/validAndCompletedCurrent', ticket)
            .then(() => {
                portal.getSysDict().then((data) => {
                    if (data) {
                        sessionStorage.setItem('dict_data', JSON.stringify(data))
                    }
                })
                store.dispatch(
                    'menu/getCurrentUserMethodAuth'
                )
                store._vm.$root.$emit('login-completed')
                if (registerRouteFresh) {
                    if (sessionStorage.menu_alias) {
                        let path = '/' + sessionStorage.menu_alias
                        let isChildren = router.addList(path, router.options.routes) //动态新增二级路由

                        router.replace({
                            path: to.path,
                            query: to.query
                        })
                    }
                    registerRouteFresh = false
                }
                next()
                // url地址带token的方式认证成功后删除url中的token
                removeUrlParams('tokenKey')
            })
            .catch(() => {
                // 4.鉴权失败时根据当前模式重定向到对应页面。
                logoutAndCleanUp(to, from, next)
            })
    } else {
        next()
    }
})

export default router
