package com.artfess.base.feign.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 对象功能:消息模版 entity对象
 * @author zhaoxy
 * @company 阿特菲斯信息技术有限公司
 * @email zhxy@jee-soft.cn
 * @date 2018-06-06 14:20
 */
@Data
@ApiModel(description="消息模板")
public class MsgTemplateDto {

	@ApiModelProperty(name="id", notes="主键")
	protected String  id;

	@ApiModelProperty(name="name", notes="模版名称")
	protected String  name;

	@ApiModelProperty(name="key", notes="模版业务键")
	protected String  key;

	@ApiModelProperty(name="typeKey", notes="模板分类（可以按任务操作类型分类，也可以按其它方式分类）")
	protected String  typeKey;

	@ApiModelProperty(name="isDefault", notes="是否默认模板（对于同一组（模板分类+接收者类型）下的多个模板其中默认的一个）")
	protected Integer  isDefault;

	@ApiModelProperty(name="subject", notes="标题")
	protected String  subject;

	@ApiModelProperty(name="plain", notes="纯文本")
	protected String  plain;

	@ApiModelProperty(name="html", notes="模版体HTML")
	protected String  html;

	@ApiModelProperty(name="smsTemplateNo", notes="短信模板")
	protected String smsTemplateNo;

	@ApiModelProperty(name="voiceTemplateNo", notes="语音模板")
	protected String voiceTemplateNo;

	@ApiModelProperty(name="categoryName", notes="分类名")
	protected String categoryName;


}
