package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 班次
 */
@Getter
public enum WorkclassEnum {
    ONE("1", "白班"),

    TWO("2", "夜班"),


    ;

    WorkclassEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        WorkclassEnum[] values = values();
        for (WorkclassEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }

    public static String getDesc(String type){
        if(StringUtils.isEmpty(type)){
            return null;
        }
        WorkclassEnum[] values = values();
        for (WorkclassEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }
}
