/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.table.colmap;

import com.artfess.table.model.Column;
import com.artfess.table.model.impl.DefaultColumn;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowMapper;

public class H2ColumnMap
implements RowMapper<Column> {
    public Column mapRow(ResultSet rs, int row) throws SQLException {
        int iLength;
        DefaultColumn column = new DefaultColumn();
        String name = rs.getString("COLUMN_NAME");
        String is_nullable = rs.getString("IS_NULLABLE");
        String data_type = rs.getString("TYPE_NAME");
        String length = rs.getString("LENGTH");
        String precisions = rs.getString("PRECISIONS");
        String scale = rs.getString("SCALE");
        String column_list = rs.getString("COLUMN_LIST");
        String column_comment = rs.getString("REMARKS");
        String table_name = rs.getString("TABLE_NAME");
        try {
            iLength = StringUtils.isEmpty((String)length) ? 0 : Integer.parseInt(length);
        }
        catch (NumberFormatException e) {
            iLength = 0;
        }
        int iPrecisions = StringUtils.isEmpty((String)precisions) ? 0 : Integer.parseInt(precisions);
        int iScale = StringUtils.isEmpty((String)scale) ? 0 : Integer.parseInt(scale);
        column.setFieldName(name);
        column.setTableName(table_name);
        column.setComment(column_comment);
        boolean isPkColumn = false;
        if (StringUtils.isNotEmpty((String)column_list)) {
            String[] pkColumns;
            for (String pkColumn : pkColumns = column_list.split(",")) {
                if (!name.trim().equalsIgnoreCase(pkColumn.trim())) continue;
                isPkColumn = true;
                break;
            }
        }
        column.setIsPk(isPkColumn);
        boolean isNull = is_nullable.equals("YES");
        column.setIsNull(isNull);
        this.setType(data_type, iLength, iPrecisions, iScale, column);
        return column;
    }

    private void setType(String dbtype, int length, int precision, int scale, Column columnModel) {
        if ((dbtype = dbtype.toUpperCase()).equals("BIGINT")) {
            columnModel.setColumnType("int");
            columnModel.setIntLen(19);
            columnModel.setDecimalLen(0);
            return;
        }
        if (dbtype.equals("INT8")) {
            columnModel.setColumnType("int");
            columnModel.setIntLen(19);
            columnModel.setDecimalLen(0);
            return;
        }
        if (dbtype.equals("INT")) {
            columnModel.setColumnType("int");
            columnModel.setIntLen(10);
            columnModel.setDecimalLen(0);
            return;
        }
        if (dbtype.equals("INTEGER")) {
            columnModel.setColumnType("int");
            columnModel.setIntLen(10);
            columnModel.setDecimalLen(0);
            return;
        }
        if (dbtype.equals("MEDIUMINT")) {
            columnModel.setColumnType("int");
            columnModel.setIntLen(7);
            columnModel.setDecimalLen(0);
            return;
        }
        if (dbtype.equals("INT4")) {
            columnModel.setColumnType("int");
            columnModel.setIntLen(5);
            columnModel.setDecimalLen(0);
            return;
        }
        if (dbtype.equals("SIGNED")) {
            columnModel.setColumnType("int");
            columnModel.setIntLen(3);
            columnModel.setDecimalLen(0);
            return;
        }
        if (dbtype.equals("TINYINT")) {
            columnModel.setColumnType("int");
            columnModel.setIntLen(2);
            columnModel.setDecimalLen(0);
            return;
        }
        if (dbtype.equals("SMALLINT")) {
            columnModel.setColumnType("int");
            columnModel.setIntLen(5);
            columnModel.setDecimalLen(0);
            return;
        }
        if (dbtype.equals("INT2")) {
            columnModel.setColumnType("int");
            columnModel.setIntLen(5);
            columnModel.setDecimalLen(0);
            return;
        }
        if (dbtype.equals("YEAR")) {
            columnModel.setColumnType("int");
            columnModel.setIntLen(5);
            columnModel.setDecimalLen(0);
            return;
        }
        if (dbtype.equals("IDENTITY")) {
            columnModel.setColumnType("int");
            columnModel.setIntLen(5);
            columnModel.setDecimalLen(0);
            return;
        }
        if (dbtype.equals("DECIMAL")) {
            columnModel.setColumnType("number");
            columnModel.setIntLen(precision - scale);
            columnModel.setDecimalLen(scale);
            return;
        }
        if (dbtype.equals("DOUBLE")) {
            columnModel.setColumnType("number");
            return;
        }
        if (dbtype.equals("FLOAT")) {
            columnModel.setColumnType("number");
            return;
        }
        if (dbtype.equals("FLOAT4")) {
            columnModel.setColumnType("number");
            return;
        }
        if (dbtype.equals("FLOAT8")) {
            columnModel.setColumnType("number");
            return;
        }
        if (dbtype.equals("REAL")) {
            columnModel.setColumnType("number");
            return;
        }
        if (dbtype.equals("TIME")) {
            columnModel.setColumnType("date");
            return;
        }
        if (dbtype.equals("DATE")) {
            columnModel.setColumnType("date");
            return;
        }
        if (dbtype.equals("DATETIME")) {
            columnModel.setColumnType("date");
            return;
        }
        if (dbtype.equals("SMALLDATETIME")) {
            columnModel.setColumnType("date");
            return;
        }
        if (dbtype.equals("TIMESTAMP")) {
            columnModel.setColumnType("date");
            return;
        }
        if (dbtype.equals("BINARY")) {
            columnModel.setColumnType("clob");
            return;
        }
        if (dbtype.equals("VARBINARY")) {
            columnModel.setColumnType("clob");
            return;
        }
        if (dbtype.equals("LONGVARBINARY")) {
            columnModel.setColumnType("clob");
            return;
        }
        if (dbtype.equals("RAW")) {
            columnModel.setColumnType("clob");
            return;
        }
        if (dbtype.equals("BYTEA")) {
            columnModel.setColumnType("clob");
            return;
        }
        if (dbtype.equals("TINYBLOB")) {
            columnModel.setColumnType("clob");
            return;
        }
        if (dbtype.equals("MEDIUMBLOB")) {
            columnModel.setColumnType("clob");
            return;
        }
        if (dbtype.equals("LONGBLOB")) {
            columnModel.setColumnType("clob");
            return;
        }
        if (dbtype.equals("IMAGE")) {
            columnModel.setColumnType("clob");
            return;
        }
        if (dbtype.equals("OID")) {
            columnModel.setColumnType("clob");
            return;
        }
        if (dbtype.equals("CLOB")) {
            columnModel.setColumnType("clob");
            return;
        }
        if (dbtype.equals("TINYTEXT")) {
            columnModel.setColumnType("clob");
            return;
        }
        if (dbtype.equals("TEXT")) {
            columnModel.setColumnType("clob");
            return;
        }
        if (dbtype.equals("MEDIUMTEXT")) {
            columnModel.setColumnType("clob");
            return;
        }
        if (dbtype.equals("LONGTEXT")) {
            columnModel.setColumnType("clob");
            return;
        }
        if (dbtype.equals("NTEXT")) {
            columnModel.setColumnType("clob");
            return;
        }
        if (dbtype.equals("NCLOB")) {
            columnModel.setColumnType("clob");
            return;
        }
        columnModel.setColumnType("varchar");
        columnModel.setCharLen(length);
    }
}

