/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.interceptor;

import com.artfess.base.interceptor.MapIntercept;
import com.artfess.base.interceptor.ResultSetFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.SQLUtil;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.apache.ibatis.executor.resultset.DefaultResultSetHandler;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.springframework.util.Assert;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class ResultSetInterceptor
implements Interceptor {
    private static CCJSqlParserManager sqlParserManager = new CCJSqlParserManager();
    private static TablesNamesFinder tablesNamesFinder = new TablesNamesFinder();
    private List<ResultSetFilter> filters = new ArrayList<ResultSetFilter>();

    public Object intercept(Invocation invocation) throws Throwable {
        try {
            Object target = invocation.getTarget();
            MappedStatement ms = (MappedStatement)this.getByPropertyName(target, "mappedStatement");
            BoundSql boundSql = (BoundSql)this.getByPropertyName(target, "boundSql");
            DefaultResultSetHandler defaultResultSetHandler = (DefaultResultSetHandler)invocation.getTarget();
            MetaObject metaStatementHandler = SystemMetaObject.forObject((Object)defaultResultSetHandler);
            MappedStatement mappedStatement = (MappedStatement)metaStatementHandler.getValue("mappedStatement");
            List resultMaps = mappedStatement.getResultMaps();
            Class resultType = ((ResultMap)resultMaps.get(0)).getType();
            String id = ms.getId();
            String sql = boundSql.getSql();
            List<String> tableNames = this.getTableNames(sql);
            String dbType = SQLUtil.getDbType();
            if ("dm".equals(dbType) && Map.class.isAssignableFrom(resultType)) {
                return MapIntercept.interceptMap(invocation);
            }
            Object result = invocation.proceed();
            this.filters.forEach(f -> {
                if (f.support(id, sql, tableNames)) {
                    f.handle(result);
                }
            });
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return invocation.proceed();
        }
    }

    public Object plugin(Object target) {
        if (target instanceof ResultSetHandler) {
            if (BeanUtils.isEmpty(this.filters)) {
                return target;
            }
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public <C> C getByPropertyName(Object obj, String name) throws Exception {
        Class<?> c = obj.getClass();
        Field f = c.getDeclaredField(name);
        f.setAccessible(true);
        return (C)f.get(obj);
    }

    public List<String> getTableNames(String sql) throws Exception {
        net.sf.jsqlparser.statement.Statement statement = sqlParserManager.parse((Reader)new StringReader(sql));
        return tablesNamesFinder.getTableList(statement);
    }

    public void setFilters(List<ResultSetFilter> filters) {
        Assert.notNull(filters, (String)"filters can not be empty.");
        this.filters = filters;
    }

    public void addFilters(ResultSetFilter filter) {
        Assert.notNull((Object)filter, (String)"filters can not be empty.");
        this.filters.add(filter);
    }
}

