/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.workflow.runtime.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.time.TimeUtil;
import com.artfess.bpm.persistence.manager.BpmDefUserManager;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.model.DefaultBpmDefinition;
import com.artfess.workflow.runtime.dao.MeetingRoomAppointmentDao;
import com.artfess.workflow.runtime.manager.MeetingRoomAppointmentManager;
import com.artfess.workflow.runtime.manager.MeetingRoomManager;
import com.artfess.workflow.runtime.model.MeetingRoom;
import com.artfess.workflow.runtime.model.MeetingRoomAppointment;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="meetingRoomAppointmentManager")
public class MeetingRoomAppointmentManagerImpl
extends BaseManagerImpl<MeetingRoomAppointmentDao, MeetingRoomAppointment>
implements MeetingRoomAppointmentManager {
    @Resource
    BpmDefUserManager bpmDefUserManager;
    @Resource
    MeetingRoomManager meetingRoomManager;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;

    @Override
    public PageList<ObjectNode> getAppointList(QueryFilter queryFilter) throws IOException {
        List defs = this.bpmDefinitionManager.queryByDefKey("hylc");
        String defId = "";
        if (defs.size() > 0 && BeanUtils.isNotEmpty(defs.get(defs.size() - 1))) {
            defId = ((DefaultBpmDefinition)defs.get(defs.size() - 1)).getDefId();
        }
        List querys = queryFilter.getQuerys();
        String weekStr = "";
        ArrayList<QueryField> newQuerys = new ArrayList<QueryField>();
        for (QueryField queryField : querys) {
            if ("weekStr".equals(queryField.getProperty())) {
                weekStr = queryField.getValue().toString();
                continue;
            }
            newQuerys.add(queryField);
        }
        queryFilter.setQuerys(newQuerys);
        QueryFilter qfForMeetingAppoint = QueryFilter.build();
        PageList meetingroomList = this.meetingRoomManager.query(queryFilter);
        String[] arr = weekStr.split(",");
        LocalDateTime begTime = TimeUtil.convertString((String)(arr[0].split("\\|")[0] + " 00:00:00"));
        LocalDateTime endTime = TimeUtil.convertString((String)(arr[6].split("\\|")[0] + " 00:00:00"));
        qfForMeetingAppoint.addFilter("APPOINTMENT_BEG_TIME_", (Object)begTime, QueryOP.GREAT_EQUAL);
        qfForMeetingAppoint.addFilter("APPOINTMENT_END_TIME_", (Object)endTime, QueryOP.LESS_EQUAL);
        qfForMeetingAppoint.addFilter("APPOINTMENT_STATUS_", (Object)"1", QueryOP.EQUAL);
        PageList meetingAppointList = this.query(qfForMeetingAppoint);
        PageList resultList = new PageList();
        ArrayList<ObjectNode> objList = new ArrayList<ObjectNode>();
        for (int i = 0; i < meetingroomList.getRows().size(); ++i) {
            ObjectNode data = JsonUtil.getMapper().createObjectNode();
            MeetingRoom meetingroom = (MeetingRoom)((Object)meetingroomList.getRows().get(i));
            data.put("mtRoomId", meetingroom.getId());
            data.put("defId", defId);
            data.put("mtName", meetingroom.getName());
            for (int z = 0; z < arr.length; ++z) {
                int curDate = Integer.valueOf(arr[z].split("\\|")[0].replace("-", ""));
                String elNmae = arr[z].split("\\|")[1];
                ArrayList<ObjectNode> appList = new ArrayList<ObjectNode>();
                for (int j = 0; j < meetingAppointList.getRows().size(); ++j) {
                    MeetingRoomAppointment meetingAppoint = (MeetingRoomAppointment)((Object)meetingAppointList.getRows().get(j));
                    int endDate = Integer.valueOf(TimeUtil.getDateString((LocalDateTime)meetingAppoint.getAppointmentEndTime(), (String)"yyyyMMdd"));
                    int begDate = Integer.valueOf(TimeUtil.getDateString((LocalDateTime)meetingAppoint.getAppointmentBegTime(), (String)"yyyyMMdd"));
                    if (!meetingAppoint.getMeetingroomId().equals(meetingroom.getId()) || curDate > endDate || curDate < begDate) continue;
                    ObjectNode obj = JsonUtil.getMapper().createObjectNode();
                    obj.put("meetingId", meetingAppoint.getMeetingId());
                    obj.put("meetingName", meetingAppoint.getMeetingName());
                    obj.put("hostName", meetingAppoint.getHostessName());
                    obj.put("dateStr", TimeUtil.getDateString((LocalDateTime)meetingAppoint.getAppointmentBegTime(), (String)"HH:mm:ss") + "-" + TimeUtil.getDateString((LocalDateTime)meetingAppoint.getAppointmentEndTime(), (String)"HH:mm:ss"));
                    appList.add(obj);
                }
                if (appList.size() > 0) {
                    data.put(elNmae, JsonUtil.toJson(appList));
                    continue;
                }
                data.put(elNmae, "");
            }
            objList.add(data);
        }
        resultList.setRows(objList);
        resultList.setPage(meetingroomList.getPage());
        resultList.setTotal(meetingroomList.getTotal());
        resultList.setPageSize(meetingroomList.getPageSize());
        return resultList;
    }
}

