/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.engine.def.impl.handler;

import com.artfess.base.util.Dom4jUtil;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.PrivilegeItem;
import com.artfess.bpm.engine.def.AbstractBpmDefXmlHandler;
import com.artfess.bpm.engine.def.DefXmlHandlerUtil;
import com.artfess.bpm.persistence.model.DefaultBpmDefinition;
import com.artfess.bpm.plugin.core.util.UserAssignRuleParser;
import com.jamesmurty.utils.XMLBuilder;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.stereotype.Service;

@Service
public class PrivilegeBpmDefXmlHandler
extends AbstractBpmDefXmlHandler<List<PrivilegeItem>> {
    @Override
    protected String getXml(String defId, String nodeId, List<PrivilegeItem> privilegeList) {
        String xml = this.getXml(privilegeList);
        DefaultBpmDefinition def = this.bpmDefinitionManager.getById(defId);
        String defXml = def.getBpmnXml();
        Document doc = Dom4jUtil.loadXml((String)defXml);
        Element root = doc.getRootElement();
        String xPath = "//ext:*[@bpmnElement='" + nodeId + "']/ext:signSetting/ext:privilege";
        String xParentPath = "//ext:*[@bpmnElement='" + nodeId + "']/ext:signSetting";
        String rtnXml = DefXmlHandlerUtil.getXml(root, xml, xParentPath, xPath);
        return rtnXml;
    }

    private String getXml(List<PrivilegeItem> privilegeList) {
        try {
            XMLBuilder xmlBuilder = XMLBuilder.create((String)"ext:privilege").a("xmlns:ext", "http://www.jee-soft.cn/bpm");
            for (PrivilegeItem item : privilegeList) {
                xmlBuilder = xmlBuilder.e("ext:item").a("mode", item.getPrivilegeMode().getKey()).e("ext:members");
                UserAssignRuleParser.handXmlBulider(xmlBuilder, item.getUserRuleList());
                xmlBuilder = xmlBuilder.up().up();
            }
            String xml = xmlBuilder.asString();
            return xml;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

