# pretty [![NPM version](https://img.shields.io/npm/v/pretty.svg?style=flat)](https://www.npmjs.com/package/pretty) [![NPM monthly downloads](https://img.shields.io/npm/dm/pretty.svg?style=flat)](https://npmjs.org/package/pretty) [![Linux Build Status](https://img.shields.io/travis/jonschlinkert/pretty.svg?style=flat&label=Travis)](https://travis-ci.org/jonschlinkert/pretty)

> Some tweaks for beautifying HTML with js-beautify according to my preferences.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save pretty
```

Install with [yarn](https://yarnpkg.com):

```sh
$ yarn add pretty
```

## Usage

```js
var pretty = require('pretty');

pretty(STRING_OF_HTML);
```

Before

```html
<!DOCTYPE html> <html lang="en"> <head> 
<meta charset="UTF-8"> <title>Home</title> 
</head> <body> This is content. </body> </html>
```

After

```html
<!DOCTYPE html>
  <html lang="en">
  <head>
    <meta charset="UTF-8">
    <title>Home</title>
  </head>
  <body>
    This is content.
  </body>
</html>
```

## Options

### ocd

```js
pretty(STRING_OF_HTML, {ocd: true});
```

**Type**: `Boolean`

**Default**: `undefined`

* condenses multiple newlines to a single newline
* trims leading and trailing whitespace
* ensures that a trailing newline is inserted
* normalizes whitespace before code comments

## About

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Building docs

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

### Running tests

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2017, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.5.0, on April 13, 2017._