// 图标数据
//路段
const option = {
  title: {
    text: '路段',
    style: {
      fill: '#fff'
    }
  },
  legend: {
    data: [],
    textStyle: {
      fontFamily: 'Arial',
      fontSize: 13,
      fill: '#fff'
    }
  },
  xAxis: {
    name: '公司',
    nameTextStyle: {
      fill: '#fff',
      fontSize: 14
    },
    data: [
      '建新公司',
      '双合公司',
      '遂渝公司',
      'xx公司1',
      'xx公司2',
      'xx公司3',
      'xx公司4'
    ],
    axisLabel: {
      style: {
        fill: '#fff',
        fontSize: 14,
        rotate: 0
      }
    },
    axisLine: {
      style: {
        stroke: '#fff',
        lineWidth: 1
      }
    }
  },
  yAxis: {
    name: '数量',
    min: 0,
    max: '5%',
    nameTextStyle: {
      fill: '#fff',
      fontSize: 14
    },
    data: 'value',
    axisLabel: {
      style: {
        fill: '#fff',
        fontSize: 14,
        rotate: 0
      }
    },
    axisLine: {
      style: {
        stroke: '#fff',
        lineWidth: 1
      }
    }
  },
  series: [
    {
      name: '路段',
      data: [1200, 2230, 1900, 2100, 3500, 4200, 3985],
      type: 'bar',
      stack: 'a',
      label: {
        show: true,
        position: 'top',
        offset: [0, 0],
        style: {
          fill: '#fff'
        }
      }
    }
  ]
}
//路段
const option_1 = {
  title: {
    text: '路段',
    style: {
      fill: '#fff'
    }
  },
  legend: {
    data: [],
    textStyle: {
      fontFamily: 'Arial',
      fontSize: 13,
      fill: '#fff'
    }
  },
  xAxis: {
    name: '公司',
    nameTextStyle: {
      fill: '#fff',
      fontSize: 14
    },
    data: [
      '建新公司',
      '双合公司',
      '遂渝公司',
      'xx公司1',
      'xx公司2',
      'xx公司3',
      'xx公司4'
    ],
    axisLabel: {
      style: {
        fill: '#fff',
        fontSize: 14,
        rotate: 0
      }
    },
    axisLine: {
      style: {
        stroke: '#fff',
        lineWidth: 1
      }
    }
  },
  yAxis: {
    name: '数量',
    min: 0,
    max: '5%',
    nameTextStyle: {
      fill: '#fff',
      fontSize: 14
    },
    data: 'value',
    axisLabel: {
      style: {
        fill: '#fff',
        fontSize: 14,
        rotate: 0
      }
    },
    axisLine: {
      style: {
        stroke: '#fff',
        lineWidth: 1
      }
    }
  },
  series: [
    {
      name: '路段',
      data: [1200, 2230, 1900, 2100, 3500, 4200, 3985],
      type: 'bar',
      label: {
        show: true,
        position: 'top',
        offset: [0, 0],
        style: {
          fill: '#fff'
        }
      }
    }
  ]
}
//沿线设施
const option_2 = {
  title: {
    text: '沿线设施',
    style: {
      fill: '#fff'
    }
  },
  legend: {
    data: [],
    textStyle: {
      fontFamily: 'Arial',
      fontSize: 13,
      fill: '#fff'
    }
  },
  xAxis: {
    name: '公司',
    nameTextStyle: {
      fill: '#fff',
      fontSize: 10
    },
    data: [
      '建新公司',
      '双合公司',
      '遂渝公司',
      'xx公司1',
      'xx公司2',
      'xx公司3',
      'xx公司4'
    ],
    axisLabel: {
      style: {
        rotate: 20,
        textAlign: 'left',
        textBaseline: 'top',
        fill: '#fff',
        fontSize: 10
      }
    },
    axisLine: {
      style: {
        stroke: '#fff',
        lineWidth: 1
      }
    }
  },
  yAxis: {
    name: '数量',
    min: 0,
    max: '5%',
    nameTextStyle: {
      fill: '#fff',
      fontSize: 14
    },
    data: 'value',
    axisLabel: {
      style: {
        fill: '#fff',
        fontSize: 14,
        rotate: 0
      }
    },
    axisLine: {
      style: {
        stroke: '#fff',
        lineWidth: 1
      }
    }
  },
  series: [
    {
      name: '沿线设施',
      data: [1200, 2230, 1900, 2100, 3500, 4200, 3985],
      type: 'bar',
      label: {
        show: true,
        position: 'top',
        offset: [0, 0],
        style: {
          fill: '#fff'
        }
      }
    }
  ]
}
//边坡
const option_3 = {
  title: {
    text: '边坡',
    style: {
      fill: '#fff'
    }
  },
  legend: {
    data: ['高危', '不高危'],
    textStyle: {
      fontFamily: 'Arial',
      fontSize: 13,
      fill: '#fff'
    }
  },
  xAxis: {
    name: '公司',
    nameTextStyle: {
      fill: '#fff',
      fontSize: 10
    },
    data: [
      '建新公司',
      '双合公司',
      '遂渝公司',
      'xx公司1',
      'xx公司2',
      'xx公司3',
      'xx公司4'
    ],
    axisLabel: {
      style: {
        rotate: 0,
        textAlign: 'left',
        textBaseline: 'top',
        fill: '#fff',
        fontSize: 10
      }
    },
    axisLine: {
      style: {
        stroke: '#fff',
        lineWidth: 1
      }
    }
  },
  yAxis: {
    name: '数量',
    min: 0,
    max: '5%',
    nameTextStyle: {
      fill: '#fff',
      fontSize: 14
    },
    data: 'value',
    axisLabel: {
      style: {
        fill: '#fff',
        fontSize: 14,
        rotate: 0
      }
    },
    axisLine: {
      style: {
        stroke: '#fff',
        lineWidth: 1
      }
    }
  },
  series: [
    {
      name: '高危',
      data: [1200, 2230, 1900, 2100, 3500, 4200, 3985],
      type: 'bar',
      stack: 'a',
      label: {
        show: true,
        position: 'top',
        offset: [0, 0],
        style: {
          fill: '#fff'
        }
      }
    },
    {
      name: '不高危',
      data: [1200, 2230, 1900, 2100, 3500, 4200, 3985],
      type: 'bar',
      stack: 'a',
      label: {
        show: true,
        position: 'center',
        offset: [0, 0],
        style: {
          fill: '#fff'
        }
      }
    }
  ]
}
//桥梁
const option_4 = {
  title: {
    text: '桥梁',
    style: {
      fill: '#fff'
    }
  },
  legend: {
    data: ['特大桥', '大桥', '中桥', '小桥'],
    textStyle: {
      fontFamily: 'Arial',
      fontSize: 13,
      fill: '#fff'
    }
  },
  xAxis: {
    name: '公司',
    nameTextStyle: {
      fill: '#fff',
      fontSize: 10
    },
    data: [
      '建新公司',
      '双合公司',
      '遂渝公司',
      'xx公司1',
      'xx公司2',
      'xx公司3',
      'xx公司4'
    ],
    axisLabel: {
      style: {
        rotate: 0,
        textAlign: 'left',
        textBaseline: 'top',
        fill: '#fff',
        fontSize: 10
      }
    },
    axisLine: {
      style: {
        stroke: '#fff',
        lineWidth: 1
      }
    }
  },
  yAxis: {
    name: '数量',
    min: 0,
    max: '5%',
    nameTextStyle: {
      fill: '#fff',
      fontSize: 14
    },
    data: 'value',
    axisLabel: {
      style: {
        fill: '#fff',
        fontSize: 14,
        rotate: 0
      }
    },
    axisLine: {
      style: {
        stroke: '#fff',
        lineWidth: 1
      }
    }
  },
  series: [
    {
      name: '特大桥',
      data: [1200, 2230, 1900, 2100, 3500, 4200, 3985],
      type: 'bar',
      stack: 'a',
      label: {
        show: true,
        position: 'top',
        offset: [0, 0],
        style: {
          fill: '#fff'
        }
      }
    },
    {
      name: '大桥',
      data: [1200, 2230, 1900, 2100, 3500, 4200, 3985],
      type: 'bar',
      stack: 'a',
      label: {
        show: true,
        position: 'top',
        offset: [0, 0],
        style: {
          fill: '#fff'
        }
      }
    },
    {
      name: '中桥',
      data: [1200, 2230, 1900, 2100, 3500, 4200, 3985],
      type: 'bar',
      stack: 'a',
      label: {
        show: true,
        position: 'top',
        offset: [0, 0],
        style: {
          fill: '#fff'
        }
      }
    },
    {
      name: '小桥',
      data: [1200, 2230, 1900, 2100, 3500, 4200, 3985],
      type: 'bar',
      stack: 'a',
      label: {
        show: true,
        position: 'top',
        offset: [0, 0],
        style: {
          fill: '#fff'
        }
      }
    }
  ]
}
//隧道
const option_5 = {
  title: {
    text: '隧道',
    style: {
      fill: '#fff'
    }
  },
  legend: {
    data: ['特长隧道', '长隧道', '中隧道', '短隧道'],
    textStyle: {
      fontFamily: 'Arial',
      fontSize: 13,
      fill: '#fff'
    }
  },
  xAxis: {
    name: '公司',
    nameTextStyle: {
      fill: '#fff',
      fontSize: 10
    },
    data: [
      '建新公司',
      '双合公司',
      '遂渝公司',
      'xx公司1',
      'xx公司2',
      'xx公司3',
      'xx公司4'
    ],
    axisLabel: {
      style: {
        rotate: 0,
        textAlign: 'left',
        textBaseline: 'top',
        fill: '#fff',
        fontSize: 10
      }
    },
    axisLine: {
      style: {
        stroke: '#fff',
        lineWidth: 1
      }
    }
  },
  yAxis: {
    name: '数量',
    min: 0,
    max: '5%',
    nameTextStyle: {
      fill: '#fff',
      fontSize: 14
    },
    data: 'value',
    axisLabel: {
      style: {
        fill: '#fff',
        fontSize: 14,
        rotate: 0
      }
    },
    axisLine: {
      style: {
        stroke: '#fff',
        lineWidth: 1
      }
    }
  },
  series: [
    {
      name: '特长隧道',
      data: [1200, 2230, 1900, 2100, 3500, 4200, 3985],
      type: 'bar',
      stack: 'a',
      label: {
        show: true,
        position: 'top',
        offset: [0, 0],
        style: {
          fill: '#fff'
        }
      }
    },
    {
      name: '长隧道',
      data: [1200, 2230, 1900, 2100, 3500, 4200, 3985],
      type: 'bar',
      stack: 'a',
      label: {
        show: true,
        position: 'top',
        offset: [0, 0],
        style: {
          fill: '#fff'
        }
      }
    },
    {
      name: '中隧道',
      data: [1200, 2230, 1900, 2100, 3500, 4200, 3985],
      type: 'bar',
      stack: 'a',
      label: {
        show: true,
        position: 'top',
        offset: [0, 0],
        style: {
          fill: '#fff'
        }
      }
    },
    {
      name: '短隧道',
      data: [1200, 2230, 1900, 2100, 3500, 4200, 3985],
      type: 'bar',
      stack: 'a',
      label: {
        show: true,
        position: 'top',
        offset: [0, 0],
        style: {
          fill: '#fff'
        }
      }
    }
  ]
}
//涵洞
const option_6 = {
  title: {
    text: '涵洞',
    style: {
      fill: '#fff'
    }
  },
  legend: {
    data: ['盖板涵', '管涵', '箱涵', '拱涵', '倒虹吸'],
    textStyle: {
      fontFamily: 'Arial',
      fontSize: 13,
      fill: '#fff'
    }
  },
  xAxis: {
    name: '公司',
    nameTextStyle: {
      fill: '#fff',
      fontSize: 10
    },
    data: [
      '建新公司',
      '双合公司',
      '遂渝公司',
      'xx公司1',
      'xx公司2',
      'xx公司3',
      'xx公司4'
    ],
    axisLabel: {
      style: {
        rotate: 0,
        textAlign: 'left',
        textBaseline: 'top',
        fill: '#fff',
        fontSize: 10
      }
    },
    axisLine: {
      style: {
        stroke: '#fff',
        lineWidth: 1
      }
    }
  },
  yAxis: {
    name: '数量',
    min: 0,
    max: '5%',
    nameTextStyle: {
      fill: '#fff',
      fontSize: 14
    },
    data: 'value',
    axisLabel: {
      style: {
        fill: '#fff',
        fontSize: 14,
        rotate: 0
      }
    },
    axisLine: {
      style: {
        stroke: '#fff',
        lineWidth: 1
      }
    }
  },
  series: [
    {
      name: '盖板涵',
      data: [1200, 2230, 1900, 2100, 3500, 4200, 3985],
      type: 'bar',
      stack: 'a',
      label: {
        show: true,
        position: 'top',
        offset: [0, 0],
        style: {
          fill: '#fff'
        }
      }
    },
    {
      name: '管涵',
      data: [1200, 2230, 1900, 2100, 3500, 4200, 3985],
      type: 'bar',
      stack: 'a',
      label: {
        show: true,
        position: 'top',
        offset: [0, 0],
        style: {
          fill: '#fff'
        }
      }
    },
    {
      name: '箱涵',
      data: [1200, 2230, 1900, 2100, 3500, 4200, 3985],
      type: 'bar',
      stack: 'a',
      label: {
        show: true,
        position: 'top',
        offset: [0, 0],
        style: {
          fill: '#fff'
        }
      }
    },
    {
      name: '拱涵',
      data: [1200, 2230, 1900, 2100, 3500, 4200, 3985],
      type: 'bar',
      stack: 'a',
      label: {
        show: true,
        position: 'top',
        offset: [0, 0],
        style: {
          fill: '#fff'
        }
      }
    },
    {
      name: '倒虹吸',
      data: [1200, 2230, 1900, 2100, 3500, 4200, 3985],
      type: 'bar',
      stack: 'a',
      label: {
        show: true,
        position: 'top',
        offset: [0, 0],
        style: {
          fill: '#fff'
        }
      }
    }
  ]
}
//桥梁类别统计
const option_7 = {
  title: {
    text: '桥梁类别统计',
    style: {
      fill: '#fff'
    }
  },
  series: [
    {
      type: 'pie',
      data: [
        {name: '遂渝分公司', value: 93},
        {name: '建新分公司', value: 32},
        {name: '秀松分公司', value: 65},
        {name: '双合分公司', value: 44},
        {name: '永泸分公司', value: 52}
      ],
      insideLabel: {
        show: true
      },
      roseType: true,
      label: {
        formatter: '{value}万元'
      }
    }
  ]
}
//隧道等级统计
const option_8 = {
  title: {
    text: '隧道等级统计',
    style: {
      fill: '#fff'
    }
  },
  series: [
    {
      type: 'pie',
      data: [
        {name: '遂渝分公司', value: 93},
        {name: '建新分公司', value: 32},
        {name: '秀松分公司', value: 65},
        {name: '双合分公司', value: 44},
        {name: '永泸分公司', value: 52}
      ],
      insideLabel: {
        show: true
      },
      roseType: true,
      label: {
        formatter: '{value}万元'
      }
    }
  ]
}
//巡检填报
const option_9 = {
  title: {
    text: '巡检填报统计',
    style: {
      fill: '#fff'
    }
  },
  xAxis: {
    data: [
      '永泸高速',
      '成渝环线遂渝段',
      '石墨高速',
      '秀松高速',
      '潼荣高速',
      '合安高速',
      '合璧津高速'
    ],
    axisLabel: {
      style: {
        rotate: 20,
        textAlign: 'left',
        textBaseline: 'top',
        fill: '#fff',
        fontSize: 14
        // rotate: 0
      },
      formatter: dataItem => dataItem.value
    },
    nameTextStyle: {
      fill: '#fff',
      fontSize: 10
    },
    axisLine: {
      style: {
        stroke: '#fff',
        lineWidth: 1
      }
    },
    axisTick: {
      style: {
        stroke: '#fff',
        lineWidth: 1
      }
    }
  },
  yAxis: {
    data: 'value',
    axisLabel: {
      style: {
        fill: '#fff',
        fontSize: 14,
        rotate: 0
      },
      formatter: dataItem => dataItem.value
    },
    nameTextStyle: {
      fill: '#fff',
      fontSize: 10
    },
    axisLine: {
      style: {
        stroke: '#fff',
        lineWidth: 1
      }
    },
    axisTick: {
      style: {
        stroke: '#fff',
        lineWidth: 1
      }
    }
  },
  series: [
    {
      data: [9, 8, 7, 6, 5, 3, 4],
      type: 'line',
      label: {
        show: true,
        formatter: '{value}',
        style: {
          fill: '#fff'
        }
      },
      lineArea: {
        show: true,
        gradient: ['rgba(55, 162, 218, 0.6)', 'rgba(55, 162, 218, 0)']
      }
    }
  ]
}
//巡检任务完成统计
const option_10 = {
  title: {
    text: '日常巡检',
    style: {
      fill: '#fff'
    }
  },
  legend: {
    data: [
      {name: '日巡检', color: '#3861fb'},
      {name: '夜巡检', color: '#d53f48'}
    ],
    bottom: 16,
    textStyle: {
      fontFamily: 'Arial',
      fontSize: 13,
      fill: '#fff'
    }
  },
  xAxis: {
    data: ['遂渝公司', '建新公司', '永泸公司', '秀松公司', '双合公司'],
    axisLabel: {
      style: {
        fill: '#fff',
        fontSize: 14,
        rotate: 0
        // textAlign: 'left',
        // textBaseline: 'top'
      }
    },
    axisLine: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    },
    axisTick: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    }
  },
  yAxis: [
    {
      data: 'value',
      min: 0,
      max: '10%',
      interval: 5,
      splitLine: {
        style: {
          stroke: '#01a3ff',
          lineWidth: 1
        }
      },
      axisLabel: {
        style: {
          fill: '#fff',
          fontSize: 18,
          rotate: 0
        },
        formatter: dataItem => dataItem.value
      },
      axisTick: {
        style: {
          stroke: '#01a3ff',
          lineWidth: 1
        }
      },
      axisLine: {
        style: {
          stroke: '#01a3ff',
          lineWidth: 1
        }
      }
    }
  ],
  series: [
    {
      name: '日巡检',
      data: [9, 7, 4, 5, 6],
      type: 'bar',
      stack: 'a',
      label: {
        show: true,
        position: 'top',
        offset: [-10, -10],
        style: {
          fill: '#fff',
          fontSize: 18
        }
      },
      gradient: {
        color: ['#2fc1d2', '#348ee7', '#3861fb']
      }
    },
    {
      name: '夜巡检',
      data: [9, 6, 7, 4, 2],
      type: 'bar',
      stack: 'a',
      label: {
        show: true,
        position: 'top',
        offset: [10, -10],
        style: {
          fill: '#fff',
          fontSize: 18
        }
      },
      gradient: {
        color: ['#f07d68', '#e5645b', '#d53f48']
      }
    }
  ]
}
//巡检填报统计
const option_11 = {
  title: {
    text: '巡检填报统计',
    style: {
      fill: '#fff'
    }
  },
  xAxis: {
    data: ['遂渝公司', '建新公司', '永泸公司', '秀松公司', '双合公司'],
    axisLabel: {
      style: {
        rotate: 0,
        // textAlign: 'left',
        // textBaseline: 'top',
        fill: '#fff',
        fontSize: 14
      },
      formatter: dataItem => dataItem.value
    },
    nameTextStyle: {
      fill: '#fff',
      fontSize: 10
    },
    axisLine: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    },
    axisTick: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    },
    splitLine: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    }
  },
  yAxis: {
    data: 'value',
    axisLabel: {
      style: {
        fill: '#fff',
        fontSize: 18,
        rotate: 0
      },
      formatter: dataItem => dataItem.value
    },
    nameTextStyle: {
      fill: '#fff',
      fontSize: 18
    },
    axisLine: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    },
    axisTick: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    },
    splitLine: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    }
  },
  series: [
    {
      data: [4, 3, 1, 2, 3],
      type: 'line',
      smooth: true,
      label: {
        show: true,
        style: {
          fill: '#fff',
          fontSize: 18,
          fontWight: 500
        }
      },
      lineStyle: {
        fill: '#52c1ee',
        lineWidth: 2
      },
      lineArea: {
        show: true,
        gradient: ['rgba(55, 162, 218, 0.6)', 'rgba(55, 162, 218, 0)']
      },
      linePoint: {
        style: {
          fill: '#01a3ff',
          lineWidth: 1
        }
      }
    }
  ]
}
//养护车辆统计
const option_12 = {
  title: {
    text: '养护车辆统计',
    style: {
      fill: '#fff'
      // fontSize: 12
    }
  },
  xAxis: {
    data: [
      '皮卡',
      '轻卡',
      '清扫车',
      '清洗车',
      '洒水车',
      '巡查车',
      '高架车',
      '拖车'
    ],
    axisLabel: {
      style: {
        rotate: 0,
        // textAlign: 'left',
        // textBaseline: 'top',
        fill: '#fff'
        // fontSize: 14
      }
      //formatter: dataItem => dataItem.value
    },
    axisLine: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    },
    axisTick: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    }
  },
  yAxis: {
    data: 'value',
    axisLabel: {
      style: {
        fill: '#fff',
        // fontSize: 14,
        rotate: 0
      }
      //formatter: dataItem => dataItem.value
    },
    splitLine: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    },
    axisLine: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    },
    axisTick: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    }
  },
  grid: {
    top: '30%',
    bottom: '15%'
  },
  series: [
    {
      data: [16, 21, 3, 4, 1,1,1,1],
      type: 'line',
      smooth: true,
      label: {
        show: true,
        style: {
          fill: '#fff',
          fontSize: 18
        }
      },
      lineStyle: {
        fill: '#52c1ee',
        lineWidth: 2
      },
      lineArea: {
        show: true,
        gradient: ['rgba(55, 162, 218, 0.6)', 'rgba(55, 162, 218, 0)']
      },
      linePoint: {
        style: {
          fill: '#01a3ff',
          lineWidth: 1
        }
      }
    }
  ]
}
//公司人员统计
const option_13 = {
  title: {
    text: '公司人员统计',
    style: {
      fill: '#fff'
      // fontSize: 12
    }
  },
  legend: {
    data: [
      {name: '管理人员', color: '#3861fb'},
      {name: '巡查人员', color: '#d53f48'},
      {name: '养护人员', color: '#f8b909'}
      // {name: '施工人员', color: '#2ea577'}
    ],
    bottom: '5%',
    textStyle: {
      fontFamily: 'Arial',
      // fontSize: 14,
      fill: '#fff'
    }
  },
  xAxis: {
    data: ['遂渝公司', '建新公司', '永泸公司', '双合公司', '秀松公司'],
    axisLabel: {
      style: {
        fill: '#fff',
        rotate: 0
        // textAlign: 'left',
        // textBaseline: 'top'
      }
    },
    axisTick: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    },
    axisLine: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    }
  },
  yAxis: [
    {
      name: '数量',
      data: 'value',
      min: 0,
      max: '10%',
      interval: 5,
      splitLine: {
        style: {
          stroke: '#01a3ff',
          lineWidth: 1
        }
      },
      nameTextStyle: {
        fill: '#fff'
        // fontSize: 14
      },
      axisTick: {
        style: {
          stroke: '#01a3ff',
          lineWidth: 1
        }
      },
      axisLine: {
        style: {
          stroke: '#01a3ff',
          lineWidth: 1
        }
      },
      axisLabel: {
        style: {
          fill: '#fff',
          // fontSize: 18,
          rotate: 0
        }
      }
    }
  ],
  grid: {
    top: '28%',
    bottom: '25%'
  },
  series: [
    {
      name: '管理人员',
      data: [0, 0, 0, 0, 0],
      type: 'bar',
      // gradient: {
      //   color: ['#37a2da', '#67e0e3']
      // },
      // animationCurve: 'easeOutBounce',
      stack: 'a',
      label: {
        show: true,
        position: 'top',
        offset: [-14, -10],
        formatter: dataItem => (dataItem.value == 0 ? '' : dataItem.value),
        style: {
          fill: '#fff'
          // fontSize: 18
        }
      },
      gradient: {
        color: ['#2fc1d2', '#348ee7', '#3861fb']
      }
    },
    {
      name: '巡查人员',
      data: [0, 0, 0, 0, 0],
      type: 'bar',
      // yAxisIndex: 1,
      // animationCurve: 'easeOutBounce',
      stack: 'a',
      label: {
        show: true,
        position: 'top',
        offset: [-6, -10],
        formatter: dataItem => (dataItem.value == 0 ? '' : dataItem.value),
        style: {
          fill: '#fff'
          // fontSize: 18
        }
      },
      gradient: {
        color: ['#f07d68', '#e5645b', '#d53f48']
      }
    },
    {
      name: '养护人员',
      data: [0, 0, 0, 0, 0],
      type: 'bar',
      // yAxisIndex: 1,
      // animationCurve: 'easeOutBounce',
      stack: 'a',
      label: {
        show: true,
        position: 'top',
        offset: [6, -10],
        formatter: dataItem => (dataItem.value == 0 ? '' : dataItem.value),
        style: {
          fill: '#fff'
          // fontSize: 18
        }
      },
      gradient: {
        color: ['#eee26c', '#f3cf3d', '#f8b909']
      }
    },
    {
      name: '施工人员',
      data: [0, 0, 0, 0, 0],
      type: 'bar',
      // yAxisIndex: 1,
      // animationCurve: 'easeOutBounce',
      stack: 'a',
      label: {
        show: true,
        position: 'top',
        offset: [14, -10],
        formatter: dataItem => (dataItem.value == 0 ? '' : dataItem.value),
        style: {
          fill: '#fff'
          // fontSize: 18
        }
      },
      gradient: {
        color: ['#81eaad', '#5ac994', '#2ea577']
      }
    }
  ]
}
//各路段养护费用统计
const option_14 = {
  title: {
    text: '各路段养护费用统计',
    style: {
      fill: '#fff'
    }
  },
  xAxis: {
    data: [
      '永泸高速',
      '成渝环线遂渝段',
      '石黔高速',
      '秀松高速',
      '潼荣高速',
      '合安高速'
    ],
    axisLabel: {
      style: {
        fill: '#fff',
        rotate: 20,
        textAlign: 'left',
        textBaseline: 'top'
      }
    },
    axisTick: {
      show: false
    },
    axisLine: {
      style: {
        stroke: '#fff',
        lineWidth: 1
      }
    }
  },
  yAxis: [
    {
      data: 'value',
      min: 0,
      max: '10%',
      interval: 5,
      splitLine: {
        style: {
          lineDash: [3, 3]
        }
      },
      axisLabel: {
        formatter: '{value}'
      },
      axisTick: {
        show: false
      },
      axisLine: {
        style: {
          stroke: '#fff',
          lineWidth: 1
        }
      },
      axisLabel: {
        style: {
          fill: '#fff',
          fontSize: 10,
          rotate: 0
        }
      }
    }
  ],
  series: [
    {
      data: [9, 7, 4, 5, 6, 7],
      type: 'bar',
      // gradient: {
      //   color: ['#37a2da', '#67e0e3']
      // },
      // animationCurve: 'easeOutBounce',
      stack: 'a',
      label: {
        show: true,
        position: 'top',
        offset: [0, 0],
        style: {
          fill: '#fff'
        }
      }
    }
  ]
}
//巡检类统计
const option_15 = {
  title: {
    text: '定期/经常检查',
    style: {
      fill: '#fff'
    }
  },
  xAxis: {
    data: [
      '桥梁经常检查',
      '隧道经常检查',
      '涵洞经常检查',
      '边坡经常检查',
      '桥梁定期检查',
      '隧道定期检查',
      '涵洞定期检查',
      '边坡定期检查'
    ],
    axisLabel: {
      style: {
        fill: '#fff',
        fontSize: 14,
        rotate: 20,
        textAlign: 'left',
        textBaseline: 'top'
      }
    },
    axisLine: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    },
    axisTick: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    }
  },
  yAxis: [
    {
      data: 'value',
      min: 0,
      max: '10%',
      interval: 5,
      splitLine: {
        style: {
          stroke: '#01a3ff',
          lineWidth: 1
        }
      },
      axisLabel: {
        style: {
          fill: '#fff',
          fontSize: 18,
          rotate: 0
        },
        formatter: dataItem => dataItem.value
      },
      axisTick: {
        style: {
          stroke: '#01a3ff',
          lineWidth: 1
        }
      },
      axisLine: {
        style: {
          stroke: '#01a3ff',
          lineWidth: 1
        }
      }
    }
  ],
  series: [
    {
      data: [4, 5, 6, 1, 3, 4, 6, 4],
      type: 'bar',
      stack: 'a',
      label: {
        show: true,
        position: 'top',
        offset: [0, -10],
        style: {
          fill: '#fff',
          fontSize: 18
        }
      },
      gradient: {
        color: ['#2fc1d2', '#348ee7', '#3861fb']
      }
    }
  ]
}
//病害类型统计
const option_16 = {
  title: {
    text: '病害类型统计',
    style: {
      fill: '#fff'
    }
  },
  grid: {
    top: '20%',
    bottom: 0,
    left: '5%'
  },
  // legend: {
  //   data: [
  //     {
  //       name: '同比'
  //     },
  //     {
  //       name: '环比'
  //     }
  //   ],
  //   orient: 'horizontal',
  //   bottom: 30,
  //   textStyle: {
  //     fontFamily: 'Arial',
  //     fontSize: 16,
  //     fill: '#fff'
  //   }
  // },
  series: [
    {
      name: '同比',
      type: 'pie',
      data: [
        {name: '总则', value: 93},
        {name: '保洁', value: 32},
        {name: '路基', value: 65},
        {name: '路面', value: 44},
        {name: '隧道', value: 52},
        {name: '桥梁，涵洞', value: 52},
        {name: '交通安全设施及沿线设施', value: 52},
        {name: '绿化', value: 52},
        {name: '站房', value: 52},
        {name: '计日工', value: 52}
      ],
      radius: '30%',
      outsideLabel: {
        show: false
      },
      insideLabel: {
        show: true
      }
    },
    {
      name: '环比',
      type: 'pie',
      data: [
        {name: '总则', value: 93},
        {name: '保洁', value: 32},
        {name: '路基', value: 65},
        {name: '路面', value: 44},
        {name: '隧道', value: 52},
        {name: '桥梁，涵洞', value: 52},
        {name: '交通安全设施及沿线设施', value: 52},
        {name: '绿化', value: 52},
        {name: '站房', value: 52},
        {name: '计日工', value: 52}
      ],
      radius: ['40%', '50%'],
      outsideLabel: {
        show: true,
        formatter: '{name}个数:{value}',
        labelLineEndLength: 30,
        style: {
          fill: '#fff'
          // fontSize: 14
        }
      },
      insideLabel: {
        show: false
      }
    }
  ]
}
//养护工单统计
const option_17 = {
  title: {
    text: '养护工单统计',
    style: {
      fill: '#fff'
    }
  },
  xAxis: {
    data: ['遂渝公司', '建新公司', '永泸公司', '秀松公司', '双合公司'],
    axisLabel: {
      style: {
        rotate: 0,
        // textAlign: 'left',
        // textBaseline: 'top',
        fill: '#fff',
        fontSize: 14
      },
      formatter: dataItem => dataItem.value
    },
    nameTextStyle: {
      fill: '#fff',
      fontSize: 10
    },
    axisLine: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    },
    axisTick: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    },
    splitLine: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    }
  },
  yAxis: {
    data: 'value',
    axisLabel: {
      style: {
        fill: '#fff',
        fontSize: 18,
        rotate: 0
      },
      formatter: dataItem => dataItem.value
    },
    nameTextStyle: {
      fill: '#fff',
      fontSize: 18
    },
    axisLine: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    },
    axisTick: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    },
    splitLine: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    }
  },
  series: [
    {
      data: [4, 3, 1, 2, 3],
      type: 'line',
      smooth: true,
      label: {
        show: true,
        style: {
          fill: '#fff',
          fontSize: 18,
          fontWight: 500
        }
      },
      lineStyle: {
        fill: '#52c1ee',
        lineWidth: 2
      },
      lineArea: {
        show: true,
        gradient: ['rgba(55, 162, 218, 0.6)', 'rgba(55, 162, 218, 0)']
      },
      linePoint: {
        style: {
          fill: '#01a3ff',
          lineWidth: 1
        }
      }
    }
  ]
}
//养护任务完成统计
const option_18 = {
  title: {
    text: '养护工单(个)',
    style: {
      fill: '#fff'
    }
  },
  legend: {
    data: [
      {name: '完成', color: '#3861fb'},
      {name: '未完成', color: '#d53f48'}
    ],
    bottom: 16,
    textStyle: {
      fontFamily: 'Arial',
      fontSize: 13,
      fill: '#fff'
    }
  },
  xAxis: {
    data: ['遂渝公司', '建新公司', '永泸公司', '秀松公司', '双合公司'],
    axisLabel: {
      style: {
        fill: '#fff',
        fontSize: 14,
        rotate: 0
        // textAlign: 'left',
        // textBaseline: 'top'
      }
    },
    axisLine: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    },
    axisTick: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    }
  },
  yAxis: [
    {
      data: 'value',
      min: 0,
      max: '10%',
      interval: 5,
      splitLine: {
        style: {
          stroke: '#01a3ff',
          lineWidth: 1
        }
      },
      axisLabel: {
        style: {
          fill: '#fff',
          fontSize: 18,
          rotate: 0
        },
        formatter: dataItem => dataItem.value
      },
      axisTick: {
        style: {
          stroke: '#01a3ff',
          lineWidth: 1
        }
      },
      axisLine: {
        style: {
          stroke: '#01a3ff',
          lineWidth: 1
        }
      }
    }
  ],
  series: [
    {
      name: '完成',
      data: [9, 7, 4, 5, 6],
      type: 'bar',
      stack: 'a',
      label: {
        show: true,
        position: 'top',
        offset: [-10, -10],
        style: {
          fill: '#fff',
          fontSize: 18
        }
      },
      gradient: {
        color: ['#2fc1d2', '#348ee7', '#3861fb']
      }
    },
    {
      name: '未完成',
      data: [9, 6, 7, 4, 2],
      type: 'bar',
      stack: 'a',
      label: {
        show: true,
        position: 'top',
        offset: [10, -10],
        style: {
          fill: '#fff',
          fontSize: 18
        }
      },
      gradient: {
        color: ['#f07d68', '#e5645b', '#d53f48']
      }
    }
  ]
}
//病害数量统计
const option_19 = {
  title: {
    text: '病害数量',
    style: {
      fill: '#fff'
    }
  },
  legend: {
    data: [
      {name: '完成', color: '#3861fb'},
      {name: '未完成', color: '#d53f48'}
    ],
    bottom: '1%',
    textStyle: {
      fontFamily: 'Arial',
      // fontSize: 13,
      fill: '#fff'
    }
  },
  xAxis: {
    data: ['遂渝公司', '建新公司', '永泸公司', '秀松公司', '双合公司'],
    axisLabel: {
      style: {
        fill: '#fff',
        // fontSize: 14,
        rotate: 0
        // textAlign: 'left',
        // textBaseline: 'top'
      }
    },
    axisLine: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    },
    axisTick: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    }
  },
  yAxis: [
    {
      data: 'value',
      min: 0,
      max: '20%',
      // splitNumber: 20,
      // minInterval: 50,
      // interval: 200,
      // interval: 5,
      splitLine: {
        style: {
          stroke: '#01a3ff',
          lineWidth: 1
        }
      },
      axisLabel: {
        style: {
          fill: '#fff',
          // fontSize: 18,
          rotate: 0
        },
        formatter: dataItem => dataItem.value
      },
      axisTick: {
        style: {
          stroke: '#01a3ff',
          lineWidth: 1
        }
      },
      axisLine: {
        style: {
          stroke: '#01a3ff',
          lineWidth: 1
        }
      }
    }
  ],
  // grid: {
  //   top: '40%',
  //   bottom: '30%'
  // },
  series: [
    {
      name: '完成',
      data: [0, 0, 0, 0, 0],
      type: 'bar',
      stack: 'a',
      label: {
        show: true,
        position: 'top',
        offset: [-10, -10],
        style: {
          fill: '#fff'
          // fontSize: 18
        }
      },
      gradient: {
        color: ['#2fc1d2', '#348ee7', '#3861fb']
      }
    },
    {
      name: '未完成',
      data: [0, 0, 0, 0, 0],
      type: 'bar',
      stack: 'a',
      label: {
        show: true,
        position: 'top',
        offset: [10, -10],
        style: {
          fill: '#fff'
          // fontSize: 18
        }
      },
      gradient: {
        color: ['#f07d68', '#e5645b', '#d53f48']
      }
    }
  ]
}
//任务执行情况
const option_20 = {
  title: {
    text: '任务执行情况(个)',
    style: {
      fill: '#fff'
    }
  },
  xAxis: {
    data: ['待接工单', '施工中', '收方中', '审核中', '已完成', '已逾期'],
    axisLabel: {
      style: {
        fill: '#fff',
        // fontSize: 14,
        rotate: 0
        // textAlign: 'left',
        // textBaseline: 'top'
      }
    },
    axisLine: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    },
    axisTick: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    }
  },
  yAxis: {
    data: 'value',
    min: 0,
    axisLabel: {
      style: {
        fill: '#fff',
        // fontSize: 18,
        rotate: 0
      },
      formatter: dataItem => dataItem.value
    },
    splitLine: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    },
    axisTick: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    },
    axisLine: {
      style: {
        stroke: '#01a3ff',
        lineWidth: 1
      }
    }
  },
  grid: {
    top: '40%',
    bottom: '20%'
  },
  series: [
    {
      data: [0, 0, 0, 0, 0, 0],
      type: 'bar',
      label: {
        show: true,
        position: 'top',
        offset: [-10, -10],
        style: {
          fill: '#fff'
          // fontSize: 18
        }
      },
      gradient: {
        color: ['#2fc1d2', '#348ee7', '#3861fb']
      }
    }
  ]
}
export default [
  option,
  option_1,
  option_2,
  option_3,
  option_4,
  option_5,
  option_6,
  option_7,
  option_8,
  option_9,
  option_10,
  option_11,
  option_12,
  option_13,
  option_14,
  option_15,
  option_16,
  option_17,
  option_18,
  option_19,
  option_20
]
