export default function MapLoader() {
    return new Promise((resolve, reject) => {
      if (window.AMap) {
        resolve(window.AMap);
      } else {
        var script = document.createElement("script");
        script.type = "text/javascript";
        script.async = true;
        script.src =
          "//webapi.amap.com/ui/1.1/main.js?v=1.1.1";
        script.onerror = reject;
        document.head.appendChild(script);
      }
      window.initAMap = () => {
        resolve(window.AMap);
      };
    });
  }