"use strict";function _interopDefault(e){return e&&"object"==typeof e&&"default"in e?e.default:e}var constants=require('./constants'),utils=require('./utils'),utilsLite=require("utils-lite");require("echarts/lib/chart/bar");var Core=_interopDefault(require('./core'));require("echarts/lib/chart/line"),require("echarts/lib/chart/pie"),require("echarts/lib/chart/funnel"),require("echarts/lib/chart/radar");var echarts=_interopDefault(require("echarts/lib/echarts"));require("echarts/lib/chart/map"),require("echarts/extension/bmap/bmap"),require("echarts-amap"),require("echarts/lib/chart/sankey"),require("echarts/lib/chart/heatmap"),require("echarts/lib/component/visualMap"),require("echarts/lib/chart/scatter"),require("echarts/lib/chart/candlestick"),require("echarts/lib/component/dataZoom"),require("echarts/lib/chart/gauge"),require("echarts/lib/chart/tree"),require("echarts-liquidfill"),require("echarts-wordcloud");var _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},defineProperty=function(e,t,i){return t in e?Object.defineProperty(e,t,{value:i,enumerable:!0,configurable:!0,writable:!0}):e[t]=i,e},_extends=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var i=arguments[t];for(var a in i)Object.prototype.hasOwnProperty.call(i,a)&&(e[a]=i[a])}return e},toArray=function(e){return Array.isArray(e)?e:Array.from(e)},VALUE_AXIS_OPACITY=.5;function getBarDimAxis(e){var t=e.innerRows,i=e.dimAxisName,a=e.dimension,n=e.axisVisible,r=e.dimAxisType,o=e.dims;return a.map(function(e){return{type:"category",name:i,nameLocation:"middle",nameGap:22,data:"value"===r?getValueAxisData(o):t.map(function(t){return t[e]}),axisLabel:{formatter:function(e){return String(e)}},show:n}})}function getValueAxisData(e){for(var t=Math.max.apply(null,e),i=[],a=Math.min.apply(null,e);a<=t;a++)i.push(a);return i}function getBarMeaAxis(e){for(var t=e.meaAxisName,i=e.meaAxisType,a=e.axisVisible,n=e.digit,r=e.scale,o=e.min,s=e.max,l={type:"value",axisTick:{show:!1},show:a},u=[],d=function(e){i[e]?u[e]=_extends({},l,{axisLabel:{formatter:function(t){return utils.getFormated(t,i[e],n)}}}):u[e]=_extends({},l),u[e].name=t[e]||"",u[e].scale=r[e]||!1,u[e].min=o[e]||null,u[e].max=s[e]||null},m=0;m<2;m++)d(m);return u}function getBarTooltip(e){var t=e.axisSite,i=e.isHistogram,a=e.meaAxisType,n=e.digit,r=e.labelMap,o=i?t.right||[]:t.top||[];return r&&(o=o.map(function(e){return void 0===r[e]?e:r[e]})),{trigger:"axis",formatter:function(e){var t=[];return t.push(e[0].name+"<br>"),e.forEach(function(e){var i=e.seriesName,r=~o.indexOf(i)?a[1]:a[0];t.push(constants.itemPoint(e.color)),t.push(i+": "),t.push(utils.getFormated(e.value,r,n)),t.push("<br>")}),t.join("")}}}function getValueData(e,t){for(var i=Math.max.apply(null,t),a=[],n=Math.min.apply(null,t);n<=i;n++){var r=t.indexOf(n);~r?a.push(e[r]):a.push(null)}return a}function getBarSeries(e){var t,i=e.innerRows,a=e.metrics,n=e.stack,r=e.axisSite,o=e.isHistogram,s=e.labelMap,l=e.itemStyle,u=e.label,d=e.showLine,m=void 0===d?[]:d,c=e.dimAxisType,p=e.barGap,f=e.opacity,g=e.dims,v={},h=o?r.right||[]:r.top||[],x=o?"yAxisIndex":"xAxisIndex",y=n&&utils.getStackMap(n);return a.forEach(function(e){v[e]=[]}),i.forEach(function(e){a.forEach(function(t){v[t].push(e[t])})}),!!(t=Object.keys(v).map(function(e,t){var i="value"===c?getValueData(v[e],g):v[e],a=defineProperty({name:null!=s[e]?s[e]:e,type:~m.indexOf(e)?"line":"bar",data:i},x,~h.indexOf(e)?"1":"0");n&&y[e]&&(a.stack=y[e]),u&&(a.label=u),l&&(a.itemStyle=l);var r=f||utilsLite.get(a,"itemStyle.normal.opacity");return"value"===c&&(a.barGap=p,a.barCategoryGap="1%",null==r&&(r=VALUE_AXIS_OPACITY)),null!=r&&utilsLite.set(a,"itemStyle.normal.opacity",r),a})).length&&t}function getLegend(e){var t=e.metrics,i=e.labelMap,a=e.legendName;return a||i?{data:i?t.map(function(e){return null==i[e]?e:i[e]}):t,formatter:function(e){return null!=a[e]?a[e]:e}}:{data:t}}function getDims(e,t){return e.map(function(e){return e[t[0]]})}var bar$1=function(e,t,i,a){var n=utilsLite.cloneDeep(t),r=i.axisSite,o=void 0===r?{}:r,s=i.dimension,l=void 0===s?[e[0]]:s,u=i.stack,d=void 0===u?{}:u,m=i.axisVisible,c=void 0===m||m,p=i.digit,f=void 0===p?2:p,g=i.dataOrder,v=void 0!==g&&g,h=i.scale,x=void 0===h?[!1,!1]:h,y=i.min,b=void 0===y?[null,null]:y,A=i.max,S=void 0===A?[null,null]:A,V=i.legendName,M=void 0===V?{}:V,L=i.labelMap,T=void 0===L?{}:L,w=i.label,_=i.itemStyle,N=i.showLine,E=i.barGap,O=void 0===E?"-100%":E,F=i.opacity,C=a.tooltipVisible,R=a.legendVisible,D=e.slice();o.top&&o.bottom?D=o.top.concat(o.bottom):o.bottom&&!o.right?D=o.bottom:i.metrics?D=i.metrics:D.splice(e.indexOf(l[0]),1);var k=i.xAxisType||["normal","normal"],$=i.yAxisType||"category",H=i.xAxisName||[],P=i.yAxisName||"";if(v){var q=v.label,j=v.order;q&&j?n.sort(function(e,t){return"desc"===j?e[q]-t[q]:t[q]-e[q]}):console.warn("Need to provide name and order parameters")}var W=getDims(n,l),z=R&&getLegend({metrics:D,labelMap:T,legendName:M}),G=getBarDimAxis({innerRows:n,dimAxisName:P,dimension:l,axisVisible:c,dimAxisType:$,dims:W}),B=getBarMeaAxis({meaAxisName:H,meaAxisType:k,axisVisible:c,digit:f,scale:x,min:b,max:S});return{legend:z,yAxis:G,series:getBarSeries({innerRows:n,metrics:D,stack:d,axisSite:o,isHistogram:!1,labelMap:T,itemStyle:_,label:w,showLine:N,dimAxisType:$,dimension:l,barGap:O,opacity:F,dims:W}),xAxis:B,tooltip:C&&getBarTooltip({axisSite:o,isHistogram:!1,meaAxisType:k,digit:f,labelMap:T})}},histogram=function(e,t,i,a){var n=utilsLite.cloneDeep(t),r=i.axisSite,o=void 0===r?{}:r,s=i.dimension,l=void 0===s?[e[0]]:s,u=i.stack,d=void 0===u?{}:u,m=i.axisVisible,c=void 0===m||m,p=i.digit,f=void 0===p?2:p,g=i.dataOrder,v=void 0!==g&&g,h=i.scale,x=void 0===h?[!1,!1]:h,y=i.min,b=void 0===y?[null,null]:y,A=i.max,S=void 0===A?[null,null]:A,V=i.labelMap,M=void 0===V?{}:V,L=i.legendName,T=void 0===L?{}:L,w=i.label,_=i.itemStyle,N=i.showLine,E=i.barGap,O=void 0===E?"-100%":E,F=i.opacity;if(v){var C=v.label,R=v.order;C&&R?n.sort(function(e,t){return"desc"===R?e[C]-t[C]:t[C]-e[C]}):console.warn("Need to provide name and order parameters")}var D=a.tooltipVisible,k=a.legendVisible,$=e.slice();o.left&&o.right?$=o.left.concat(o.right):o.left&&!o.right?$=o.left:i.metrics?$=i.metrics:$.splice(e.indexOf(l[0]),1);var H=i.yAxisType||["normal","normal"],P=i.xAxisType||"category",q=i.yAxisName||[],j=i.xAxisName||"",W=getDims(n,l),z=k&&getLegend({metrics:$,labelMap:M,legendName:T}),G=getBarDimAxis({innerRows:n,dimAxisName:j,dimension:l,axisVisible:c,dimAxisType:P,dims:W});return{legend:z,yAxis:getBarMeaAxis({meaAxisName:q,meaAxisType:H,axisVisible:c,digit:f,scale:x,min:b,max:S}),series:getBarSeries({innerRows:n,metrics:$,stack:d,axisSite:o,isHistogram:!0,labelMap:M,itemStyle:_,label:w,showLine:N,dimAxisType:P,dimension:l,barGap:O,opacity:F,dims:W}),xAxis:G,tooltip:D&&getBarTooltip({axisSite:o,isHistogram:!0,meaAxisType:H,digit:f,labelMap:M})}},VeBar=_extends({},Core,{name:"VeBar",data:function(){return this.chartHandler=bar$1,{}}}),VeHistogram=_extends({},Core,{name:"VeHistogram",data:function(){return this.chartHandler=histogram,{}}});function getLineXAxis(e){var t=e.dimension,i=e.rows,a=e.xAxisName,n=e.axisVisible,r=e.xAxisType;return t.map(function(e,t){return{type:r,nameLocation:"middle",nameGap:22,name:a[t]||"",axisTick:{show:!0,lineStyle:{color:"#eee"}},data:i.map(function(t){return t[e]}),show:n}})}function getLineSeries(e){var t=e.rows,i=e.axisSite,a=e.metrics,n=e.area,r=e.stack,o=e.nullAddZero,s=e.labelMap,l=e.label,u=e.itemStyle,d=e.lineStyle,m=e.areaStyle,c=e.dimension,p=[],f={},g=r&&utils.getStackMap(r);return a.forEach(function(e){f[e]=[]}),t.forEach(function(e){a.forEach(function(t){var i=null;null!=e[t]?i=e[t]:o&&(i=0),f[t].push([e[c[0]],i])})}),a.forEach(function(e){var t={name:null!=s[e]?s[e]:e,type:"line",data:f[e]};n&&(t.areaStyle={normal:{}}),i.right&&(t.yAxisIndex=~i.right.indexOf(e)?1:0),r&&g[e]&&(t.stack=g[e]),l&&(t.label=l),u&&(t.itemStyle=u),d&&(t.lineStyle=d),m&&(t.areaStyle=m),p.push(t)}),p}function getLineYAxis(e){for(var t=e.yAxisName,i=e.yAxisType,a=e.axisVisible,n=e.scale,r=e.min,o=e.max,s=e.digit,l={type:"value",axisTick:{show:!1},show:a},u=[],d=function(e){i[e]?u[e]=_extends({},l,{axisLabel:{formatter:function(t){return utils.getFormated(t,i[e],s)}}}):u[e]=_extends({},l),u[e].name=t[e]||"",u[e].scale=n[e]||!1,u[e].min=r[e]||null,u[e].max=o[e]||null},m=0;m<2;m++)d(m);return u}function getLineTooltip(e){var t=e.axisSite,i=e.yAxisType,a=e.digit,n=e.labelMap,r=e.tooltipFormatter,o=t.right||[],s=n?o.map(function(e){return void 0===n[e]?e:n[e]}):o;return{trigger:"axis",formatter:function(e){if(r)return r.apply(null,arguments);var t=[],n=e[0],o=n.name,l=n.axisValueLabel,u=o||l;return t.push(u+"<br>"),e.forEach(function(e){var n,r=e.seriesName,o=e.data,l=e.marker,u=~s.indexOf(r)?i[1]:i[0],d=utilsLite.isArray(o)?o[1]:o;n=utils.getFormated(d,u,a),t.push(l),t.push(r+": "+n),t.push("<br>")}),t.join("")}}}function getLegend$1(e){var t=e.metrics,i=e.legendName,a=e.labelMap;return i||a?{data:a?t.map(function(e){return null==a[e]?e:a[e]}):t,formatter:function(e){return null!=i[e]?i[e]:e}}:{data:t}}var line$1=function(e,t,i,a){t=utilsLite.isArray(t)?t:[],e=utilsLite.isArray(e)?e:[];var n=i.axisSite,r=void 0===n?{}:n,o=i.yAxisType,s=void 0===o?["normal","normal"]:o,l=i.xAxisType,u=void 0===l?"category":l,d=i.yAxisName,m=void 0===d?[]:d,c=i.dimension,p=void 0===c?[e[0]]:c,f=i.xAxisName,g=void 0===f?[]:f,v=i.axisVisible,h=void 0===v||v,x=i.area,y=i.stack,b=i.scale,A=void 0===b?[!1,!1]:b,S=i.min,V=void 0===S?[null,null]:S,M=i.max,L=void 0===M?[null,null]:M,T=i.nullAddZero,w=void 0!==T&&T,_=i.digit,N=void 0===_?2:_,E=i.legendName,O=void 0===E?{}:E,F=i.labelMap,C=void 0===F?{}:F,R=i.label,D=i.itemStyle,k=i.lineStyle,$=i.areaStyle,H=a.tooltipVisible,P=a.legendVisible,q=a.tooltipFormatter,j=e.slice();r.left&&r.right?j=r.left.concat(r.right):r.left&&!r.right?j=r.left:i.metrics?j=i.metrics:j.splice(e.indexOf(p[0]),1);var W=P&&getLegend$1({metrics:j,legendName:O,labelMap:C}),z=H&&getLineTooltip({axisSite:r,yAxisType:s,digit:N,labelMap:C,xAxisType:u,tooltipFormatter:q}),G=getLineXAxis({dimension:p,rows:t,xAxisName:g,axisVisible:h,xAxisType:u}),B=getLineYAxis({yAxisName:m,yAxisType:s,axisVisible:h,scale:A,min:V,max:L,digit:N});return{legend:W,xAxis:G,series:getLineSeries({rows:t,axisSite:r,metrics:j,area:x,stack:y,nullAddZero:w,labelMap:C,label:R,itemStyle:D,lineStyle:k,areaStyle:$,xAxisType:u,dimension:p}),yAxis:B,tooltip:z}},VeLine=_extends({},Core,{name:"VeLine",data:function(){return this.chartHandler=line$1,{}}}),pieRadius=100,ringRadius=[80,100],roseRingRadius=[20,100],pieOffsetY=200;function getPieSeries(e){var t=e.innerRows,i=e.dataType,a=e.percentShow,n=e.dimension,r=e.metrics,o=e.radius,s=e.offsetY,l=e.selectedMode,u=e.hoverAnimation,d=e.digit,m=e.roseType,c=e.label,p=e.level,f=e.limitShowNum,g=e.isRing,v=e.labelLine,h=e.itemStyle,x=[],y={},b=[];p?(p.forEach(function(e,t){e.forEach(function(e){utils.setArrayValue(y,e,t)})}),t.forEach(function(e){var t=y[e[n]];t&&t.length&&t.forEach(function(t){utils.setArrayValue(b,t,e)})})):b.push(t);var A={type:"pie",selectedMode:l,hoverAnimation:u,roseType:m,center:["50%",s]},S=b.length;if(b.forEach(function(e,t){var s=_extends({data:[]},A),l=o/S;if(t){var u=l+o/(2*S)*(2*t-1),m=u+o/(2*S);s.radius=[u,m]}else s.radius=g?o:l;S>1&&0===t&&(s.label={normal:{position:"inner"}}),c&&(s.label=c),v&&(s.labelLine=v),h&&(s.itemStyle=h),a&&(s.label={normal:{show:!0,position:S>1&&0===t?"inner":"outside",formatter:function(e){var t=[];return t.push(e.name+":"),t.push(utils.getFormated(e.value,i,d)),t.push("("+e.percent+"%)"),t.join(" ")}}}),s.data=e.map(function(e){return{name:e[n],value:e[r]}}),x.push(s)}),f&&f<x[0].data.length){var V=x[0].data,M=0;V.slice(f,V.length).forEach(function(e){M+=e.value}),x[0].data=V.slice(0,f),x[0].data.push({name:"其他",value:M})}return x}function getPieLegend(e){var t=e.innerRows,i=e.dimension,a=e.legendLimit,n=e.legendName,r=e.level,o=e.limitShowNum,s=[],l=[];if(r)r.forEach(function(e){e.forEach(function(e){l.push(e)})}),s=l;else if(o&&o<t.length){for(var u=0;u<o;u++)s.push(t[u][i]);s.push("其他")}else s=t.map(function(e){return e[i]});return!!s.length&&{data:s,show:s.length<a,formatter:function(e){return null!=n[e]?n[e]:e}}}function getPieTooltip(e){var t=e.dataType,i=e.innerRows,a=e.limitShowNum,n=e.digit,r=e.metrics,o=e.dimension,s=0,l=i.map(function(e){return s+=e[r],{name:e[o],value:e[r]}}).slice(a,i.length);return{formatter:function(e){var i=[];return i.push(constants.itemPoint(e.color)),a&&"其他"===e.name?(i.push("其他:"),l.forEach(function(e){var a=e.name,r=e.value,o=utils.getFormated(r/s,"percent");i.push("<br>"+a+":"),i.push(utils.getFormated(r,t,n)),i.push("("+o+")")})):(i.push(e.name+":"),i.push(utils.getFormated(e.value,t,n)),i.push("("+e.percent+"%)")),i.join(" ")}}}var pie$1=function(e,t,i,a,n){var r=utilsLite.cloneDeep(t),o=i.dataType,s=void 0===o?"normal":o,l=i.percentShow,u=i.dimension,d=void 0===u?e[0]:u,m=i.metrics,c=void 0===m?e[1]:m,p=i.roseType,f=void 0!==p&&p,g=i.radius,v=void 0===g?n?f?roseRingRadius:ringRadius:pieRadius:g,h=i.offsetY,x=void 0===h?pieOffsetY:h,y=i.legendLimit,b=void 0===y?30:y,A=i.selectedMode,S=void 0!==A&&A,V=i.hoverAnimation,M=void 0===V||V,L=i.digit,T=void 0===L?2:L,w=i.legendName,_=void 0===w?{}:w,N=i.label,E=void 0!==N&&N,O=i.level,F=void 0!==O&&O,C=i.limitShowNum,R=void 0===C?0:C,D=i.labelLine,k=i.itemStyle,$=a.tooltipVisible,H=a.legendVisible;return R&&r.sort(function(e,t){return t[c]-e[c]}),{series:getPieSeries({innerRows:r,dataType:s,percentShow:l,dimension:d,metrics:c,radius:v,offsetY:x,selectedMode:S,hoverAnimation:M,digit:T,roseType:f,label:E,level:F,legendName:_,limitShowNum:R,isRing:n,labelLine:D,itemStyle:k}),legend:H&&getPieLegend({innerRows:r,dimension:d,legendLimit:b,legendName:_,level:F,limitShowNum:R}),tooltip:$&&getPieTooltip({dataType:s,innerRows:r,limitShowNum:R,digit:T,metrics:c,dimension:d})}},ring=function(e,t,i,a){return pie$1(e,t,i,a,!0)},VePie=_extends({},Core,{name:"VePie",data:function(){return this.chartHandler=pie$1,{}}}),VeRing=_extends({},Core,{name:"VeRing",data:function(){return this.chartHandler=ring,{}}});function getWaterfallTooltip(e,t){return{trigger:"axis",axisPointer:{type:"shadow"},formatter:function(i){var a=i[1];return[a.name+"<br/>"+a.seriesName+" :",""+utils.getFormated(a.value,e,t)].join("")}}}function getWaterfallXAxis(e){var t=e.dimension,i=e.rows,a=e.remainStatus,n=e.totalName,r=e.remainName,o=e.labelMap,s=e.xAxisName,l=e.axisVisible,u=[n].concat(i.map(function(e){return e[t]}));return"have-remain"===a&&(u=u.concat([r])),{type:"category",name:o&&o[s]||s,splitLine:{show:!1},data:u,show:l}}function getWaterfallYAxis(e){var t=e.dataType,i=e.yAxisName,a=e.axisVisible,n=e.digit,r=e.labelMap;return{type:"value",name:null!=r[i]?r[i]:i,axisTick:{show:!1},axisLabel:{formatter:function(e){return utils.getFormated(e,t,n)}},show:a}}function getWaterfallSeries(e){var t=e.dataType,i=e.rows,a=e.metrics,n=e.totalNum,r=e.remainStatus,o=e.dataSum,s=e.digit,l={type:"bar",stack:"总量"},u=o,d=n,m=void 0,c=void 0,p=i.map(function(e){return e[a]});"have-remain"===r?(m=[0].concat(i.map(function(e){return d-=e[a]})).concat([0]),c=[n].concat(p).concat([n-o])):(m=[0].concat(i.map(function(e){return u-=e[a]})),c=[o].concat(p));var f=[];return f.push(_extends({name:"辅助",itemStyle:{normal:{opacity:0},emphasis:{opacity:0}},data:m},l)),f.push(_extends({name:"数值",label:{normal:{show:!0,position:"top",formatter:function(e){return utils.getFormated(e.value,t,s)}}},data:c},l)),f}function getWaterfallRemainStatus(e,t){return t?t>e?"have-remain":"none-remain":"not-total"}var waterfall=function(e,t,i,a){var n=i.dataType,r=void 0===n?"normal":n,o=i.dimension,s=void 0===o?e[0]:o,l=i.totalName,u=void 0===l?"总计":l,d=i.totalNum,m=i.remainName,c=void 0===m?"其他":m,p=i.xAxisName,f=void 0===p?s:p,g=i.labelMap,v=void 0===g?{}:g,h=i.axisVisible,x=void 0===h||h,y=i.digit,b=void 0===y?2:y,A=a.tooltipVisible,S=e.slice();S.splice(S.indexOf(s),1);var V=S[0],M=V,L=A&&getWaterfallTooltip(r,b),T=parseFloat(t.reduce(function(e,t){return e+Number(t[V])},0).toFixed(b)),w=getWaterfallRemainStatus(T,d);return{tooltip:L,xAxis:getWaterfallXAxis({dimension:s,rows:t,remainStatus:w,totalName:u,remainName:c,xAxisName:f,labelMap:v,axisVisible:x}),yAxis:getWaterfallYAxis({dataType:r,yAxisName:M,axisVisible:x,digit:b,labelMap:v}),series:getWaterfallSeries({dataType:r,rows:t,dimension:s,metrics:V,totalNum:d,remainStatus:w,dataSum:T,digit:b})}},VeWaterfall=_extends({},Core,{name:"VeWaterfall",data:function(){return this.chartHandler=waterfall,{}}});function getFunnelTooltip(e,t){return{trigger:"item",formatter:function(i){var a=[];return a.push(constants.itemPoint(i.color)),a.push(i.name+": "+utils.getFormated(i.data.realValue,e,t)),a.join("")}}}function getFunnelLegend(e){var t=e.data,i=e.legendName;return{data:t,formatter:function(e){return null!=i[e]?i[e]:e}}}function getFunnelSeries(e){var t=e.dimension,i=e.metrics,a=e.rows,n=e.sequence,r=e.ascending,o=e.label,s=e.labelLine,l=e.itemStyle,u=e.filterZero,d=e.useDefaultOrder,m={type:"funnel"},c=a.sort(function(e,i){return n.indexOf(e[t])-n.indexOf(i[t])});u&&(c=c.filter(function(e){return e[i]}));var p=!1;c.some(function(e,t){if(t&&e[i]>c[t-1][i])return p=!0,!0});var f=100/c.length;return m.data=p&&!d?c.slice().reverse().map(function(e,a){return{name:e[t],value:(a+1)*f,realValue:e[i]}}):c.map(function(e){return{name:e[t],value:e[i],realValue:e[i]}}),r&&(m.sort="ascending"),o&&(m.label=o),s&&(m.labelLine=s),l&&(m.itemStyle=l),m}var funnel$1=function(e,t,i,a){var n=e.slice(),r=t.slice(),o=i.dataType,s=void 0===o?"normal":o,l=i.dimension,u=void 0===l?n[0]:l,d=i.sequence,m=void 0===d?r.map(function(e){return e[u]}):d,c=i.digit,p=void 0===c?2:c,f=i.ascending,g=i.label,v=i.labelLine,h=i.legendName,x=void 0===h?{}:h,y=i.itemStyle,b=i.filterZero,A=i.useDefaultOrder,S=a.tooltipVisible,V=a.legendVisible,M=void 0;if(i.metrics)M=i.metrics;else{var L=n.slice();L.splice(n.indexOf(u),1),M=L[0]}return{tooltip:S&&getFunnelTooltip(s,p),legend:V&&getFunnelLegend({data:m,legendName:x}),series:getFunnelSeries({dimension:u,metrics:M,rows:r,sequence:m,ascending:f,label:g,labelLine:v,itemStyle:y,filterZero:b,useDefaultOrder:A})}},VeFunnel=_extends({},Core,{name:"VeFunnel",data:function(){return this.chartHandler=funnel$1,{}}});function getRadarLegend(e,t,i){return{data:e.map(function(e){return e[t]}),formatter:function(e){return null!=i[e]?i[e]:e}}}function getRadarTooltip(e,t,i){var a=[],n=[];return t.indicator.map(function(t,i){a[i]=e[t.name],n[i]=t.name}),{formatter:function(e){var t=[];return t.push(constants.itemPoint(e.color)),t.push(e.name+"<br />"),e.data.value.forEach(function(e,r){t.push(n[r]+": "),t.push(utils.getFormated(e,a[r],i)+"<br />")}),t.join("")}}}function getRadarSetting(e,t,i){var a={indicator:[],shape:"circle",splitNumber:5},n={};return e.forEach(function(e){t.forEach(function(t){var a=null!=i[t]?i[t]:t;n[a]?n[a].push(e[t]):n[a]=[e[t]]})}),a.indicator=Object.keys(n).map(function(e){return{name:e,max:Math.max.apply(null,n[e])}}),a}function getRadarSeries(e){var t=e.rows,i=e.dimension,a=e.metrics,n=e.radar,r=e.label,o=e.itemStyle,s=e.lineStyle,l=e.labelMap,u=e.areaStyle,d={};n.indicator.forEach(function(e,t){var i=e.name;d[i]=t});var m=t.map(function(e){var t={value:[],name:e[i]};return Object.keys(e).forEach(function(i){if(~a.indexOf(i)){var n=null!=l[i]?d[l[i]]:d[i];t.value[n]=e[i]}}),t}),c={name:i,type:"radar",data:m};return r&&(c.label=r),o&&(c.itemStyle=o),s&&(c.lineStyle=s),u&&(c.areaStyle=u),[c]}var radar$1=function(e,t,i,a){var n=i.dataType,r=void 0===n?{}:n,o=i.legendName,s=void 0===o?{}:o,l=i.labelMap,u=void 0===l?{}:l,d=i.dimension,m=void 0===d?e[0]:d,c=i.digit,p=void 0===c?2:c,f=i.label,g=i.itemStyle,v=i.lineStyle,h=i.areaStyle,x=a.tooltipVisible,y=a.legendVisible,b=e.slice();i.metrics?b=i.metrics:b.splice(e.indexOf(m),1);var A=y&&getRadarLegend(t,m,s),S=getRadarSetting(t,b,u);return{legend:A,tooltip:x&&getRadarTooltip(r,S,p),radar:S,series:getRadarSeries({rows:t,dimension:m,metrics:b,radar:S,label:f,itemStyle:g,lineStyle:v,labelMap:u,areaStyle:h})}},VeRadar=_extends({},Core,{name:"VeRadar",data:function(){return this.chartHandler=radar$1,{}}}),VeChart=_extends({},Core,{name:"VeChart",data:function(){return this.chartLib={bar:bar$1,histogram:histogram,line:line$1,pie:pie$1,ring:ring,funnel:funnel$1,radar:radar$1,waterfall:waterfall},this.chartHandler=this.chartLib[this.settings.type],{}}});function getTooltip(e,t,i,a,n,r){return{formatter:function(o){var s=[];return o.name?(s.push(o.name+"<br>"),a.forEach(function(a,l){var u=null!=r[a]?r[a]:a;s.push(constants.itemPoint(n[l])+" "+u+" : "),i[o.name]?s.push(utils.getFormated(i[o.name][a],e[a],t)):s.push("-"),s.push("<br>")}),s.join(" ")):""}}}function getSeries(e){var t=e.position,i=e.selectData,a=e.dimension,n=e.metrics,r=e.rows,o=e.label,s=e.itemStyle,l=e.selectedMode,u=e.roam,d=e.center,m=e.aspectScale,c=e.boundingCoords,p=e.zoom,f=e.labelMap,g=e.scaleLimit,v=e.mapGrid,h=[],x={type:"map",mapType:t};return n.forEach(function(e){var t=_extends({name:null!=f[e]?f[e]:e,data:[],selectedMode:l,roam:u,center:d,aspectScale:m,boundingCoords:c,zoom:p,scaleLimit:g},x);v&&Object.keys(v).forEach(function(e){t[e]=v[e]}),setGeoLabel(s,t,"itemStyle"),setGeoLabel(o,t,"label"),r.forEach(function(n){t.data.push({name:n[a],value:n[e],selected:i})}),h.push(t)}),h}function setGeoLabel(e,t,i){"object"===(void 0===e?"undefined":_typeof(e))?t[i]=e:e&&(t[i]={normal:{show:!0},emphasis:{show:!0}})}function getLegendMap(e){var t=e.metrics,i=e.legendName,a=e.labelMap;return i||a?{data:a?t.map(function(e){return null==a[e]?e:a[e]}):t,formatter:function(e){return null!=i[e]?i[e]:e}}:{data:t}}function registerMap(e,t){var i=e._once,a=e.registerSign,n=e.beforeRegisterMap,r=e.beforeRegisterMapOnce,o=e.registerSignOnce,s=e.position,l=e.specialAreas;i[a]||(n&&(t=n(t)),r&&!i[o]&&(i[o]=!0,t=r(t)),i[a]=!0,echarts.registerMap(s,t,l))}var map$1=function(e,t,i,a){var n=i.position,r=void 0===n?"china":n,o=i.selectData,s=void 0!==o&&o,l=i.selectedMode,u=i.label,d=void 0===u||u,m=i.dataType,c=void 0===m?{}:m,p=i.digit,f=void 0===p?2:p,g=i.dimension,v=void 0===g?e[0]:g,h=i.roam,x=i.center,y=i.aspectScale,b=i.boundingCoords,A=i.zoom,S=i.scaleLimit,V=i.legendName,M=void 0===V?{}:V,L=i.labelMap,T=void 0===L?{}:L,w=i.mapGrid,_=i.itemStyle,N=i.positionJsonLink,E=i.beforeRegisterMap,O=i.beforeRegisterMapOnce,F=i.mapURLProfix,C=void 0===F?"https://unpkg.com/echarts@3.6.2/map/json/":F,R=i.specialAreas,D=void 0===R?{}:R,k=i.mapOrigin,$=e.slice();i.metrics?$=i.metrics:$.splice(e.indexOf(v),1);var H=a.tooltipVisible,P=a.legendVisible,q=a.color,j=a._once,W={};t.forEach(function(e){W[e[v]]=e});var z=H&&getTooltip(c,f,W,$,q,T),G=P&&getLegendMap({metrics:$,legendName:M,labelMap:T}),B=getSeries({position:r,selectData:s,label:d,itemStyle:_,dimension:v,metrics:$,rows:t,selectedMode:l,roam:h,center:x,aspectScale:y,boundingCoords:b,zoom:A,labelMap:T,scaleLimit:S,mapGrid:w}),U={_once:j,beforeRegisterMap:E,beforeRegisterMapOnce:O,registerSign:"MAP_REGISTER_"+r,registerSignOnce:"ONCE_MAP_REGISTER_"+r,position:r,specialAreas:D};return k?(registerMap(U,k),{series:B,tooltip:z,legend:G}):utils.getMapJSON({position:r,positionJsonLink:N,beforeRegisterMapOnce:O,mapURLProfix:C}).then(function(e){return registerMap(U,e),{series:B,tooltip:z,legend:G}})},VeMap=_extends({},Core,{name:"VeMap",data:function(){return this.chartHandler=map$1,{}}}),bmap$1=function(e,t,i,a){var n=i.key,r=i.v,o=i.bmap,s=i.useOuterMap,l=a._once;return n||s||console.warn("settings.key must be a string."),l.bmap_register?{}:(l.bmap_register=!0,s?{bmap:o}:utils.getBmap(n,r).then(function(e){return{bmap:o}}))},VeBmap=_extends({},Core,{name:"VeBmap",data:function(){return this.chartHandler=bmap$1,{}}}),amap=function(e,t,i,a){var n=i.key,r=i.v,o=i.amap,s=i.useOuterMap,l=a._once;return n||s||console.warn("settings.key must be a string."),l.amap_register?{}:(l.amap_register=!0,s?{amap:o}:utils.getAmap(n,r).then(function(e){return{amap:o}}))},VeAmap=_extends({},Core,{name:"VeAmap",data:function(){return this.chartHandler=amap,{}}});function getTooltip$1(e){var t=e.itemDataType,i=e.linksDataType,a=e.digit;return{trigger:"item",formatter:function(e){var n=[],r=e.name,o=e.data,s=e.value,l=e.color;return n.push(constants.itemPoint(l)),n.push(r+" : "),o&&o.source?n.push(utils.getFormated(s,i,a)+"<br />"):n.push(utils.getFormated(s,t,a)+"<br />"),n.join("")}}}function getSeries$1(e){var t=e.rows,i=e.dimension,a=e.metrics,n=e.links,r=e.valueFull,o=e.useDataValue,s=e.label,l=e.itemStyle,u=e.lineStyle,d={},m={type:"sankey",data:t.map(function(e){return d[e[i]]=e[a],{name:e[i],value:e[a]}}),links:o?n.map(function(e){return _extends({},e,{value:d[e.target]})}):r?n:n.map(function(e){return null==e.value?_extends({},e,{value:d[e.target]}):e})};return s&&(m.label=s),l&&(m.itemStyle=l),u&&(m.lineStyle=u),[m]}var sankey$1=function(e,t,i,a){var n=i.links,r=i.dimension,o=void 0===r?e[0]:r,s=i.metrics,l=void 0===s?e[1]:s,u=i.dataType,d=void 0===u?["normal","normal"]:u,m=i.digit,c=void 0===m?2:m,p=i.valueFull,f=void 0!==p&&p,g=i.useDataValue,v=void 0!==g&&g,h=i.label,x=i.itemStyle,y=i.lineStyle;if(n)return{tooltip:getTooltip$1({itemDataType:d[0],linksDataType:d[1],digit:c}),series:getSeries$1({rows:t,dimension:o,metrics:l,links:n,valueFull:f,useDataValue:v,label:h,itemStyle:x,lineStyle:y})};console.warn("links is needed in settings!")},VeSankey=_extends({},Core,{name:"VeSankey",data:function(){return this.chartHandler=sankey$1,{}}});function getAxisList(e,t){var i=[];return e.forEach(function(e){~i.indexOf(e[t])||i.push(e[t])}),i}function getData(e){var t=e.rows,i=e.innerXAxisList,a=e.innerYAxisList,n=e.xDim,r=e.yDim,o=e.metrics,s=e.type,l=e.extraMetrics;return"cartesian"===s?t.map(function(e){var t=i.indexOf(e[n]),s=a.indexOf(e[r]),u=o?e[o]:1,d=l.map(function(t){return e[t]||"-"});return{value:[t,s,u].concat(d)}}):t.map(function(e){var t=o?e[o]:1;return{value:[e[n],e[r],t]}})}function getAxis(e,t){return{type:"category",data:e,name:t,nameLocation:"end",splitArea:{show:!0}}}function getVisualMap(e){var t=e.innerMin,i=e.innerMax,a=e.type,n=e.heatColor,r=e.series,o={min:t,max:i,calculable:!0},s=null;return"map"===a?(s={orient:"vertical",left:0,bottom:0,inRange:{color:n||constants.HEAT_MAP_COLOR}},r[0].data.length||(s.show=!1)):s="bmap"===a||"amap"===a?{show:!1,orient:"vertical",left:0,bottom:0,inRange:{color:n||constants.HEAT_BMAP_COLOR}}:{orient:"horizontal",left:"center",bottom:10,dimension:2,inRange:n&&{color:n}},_extends(o,s)}function getSeries$2(e){return[{type:"heatmap",data:e.chartData}]}function getTooltip$2(e){var t=e.dataType,i=e.innerXAxisList,a=e.innerYAxisList,n=e.digit,r=e.extraMetrics,o=e.metrics;return{trigger:"item",formatter:function(e){var s=e.color,l=toArray(e.data.value),u=l[0],d=l[1],m=l[2],c=l.slice(3),p=[];return p.push(i[u]+" ~ "+a[d]+"<br>"),r.forEach(function(e,t){p.push(e+": "+c[t]+"<br>")}),p.push(constants.itemPoint(s)+" "+o+": "+utils.getFormated(m,t,n)+"<br>"),p.join("")}}}var heatmap$1=function(e,t,i,a){var n=i.type,r=void 0===n?"cartesian":n,o=i.xAxisList,s=i.yAxisList,l=i.dimension,u=void 0===l?[e[0],e[1]]:l,d=i.metrics,m=void 0===d?e[2]:d,c=i.dataType,p=void 0===c?"normal":c,f=i.min,g=i.max,v=i.digit,h=i.bmap,x=i.amap,y=i.geo,b=i.key,A=i.v,S=void 0===A?"2.0":A,V=i.position,M=i.positionJsonLink,L=i.beforeRegisterMap,T=i.pointSize,w=void 0===T?10:T,_=i.blurSize,N=void 0===_?5:_,E=i.heatColor,O=i.yAxisName,F=i.xAxisName,C=i.beforeRegisterMapOnce,R=i.mapURLProfix,D=void 0===R?"https://unpkg.com/echarts@3.6.2/map/json/":R,k=i.specialAreas,$=void 0===k?{}:k,H=a.tooltipVisible,P=o,q=s,j=[],W=[],z=u.concat([m]);e.forEach(function(e){~z.indexOf(e)||W.push(e)}),"cartesian"===r?(P&&P.length||(P=getAxisList(t,u[0])),q&&q.length||(q=getAxisList(t,u[1])),j=getData({rows:t,innerXAxisList:P,innerYAxisList:q,xDim:u[0],yDim:u[1],metrics:m,type:r,extraMetrics:W})):j=getData({rows:t,xDim:u[0],yDim:u[1],metrics:m,type:r,extraMetrics:W});var G=m?t.map(function(e){return e[m]}):[0,5];G.length||(G=[0]);var B=f||Math.min.apply(null,G),U=g||Math.max.apply(null,G),Y=getAxis(P,F),I=getAxis(q,O),X=getSeries$2({chartData:j}),Z=getVisualMap({innerMin:B,innerMax:U,type:r,heatColor:E,series:X}),J=H&&getTooltip$2({dataType:p,innerXAxisList:P,innerYAxisList:q,digit:v,extraMetrics:W,metrics:m}),K={visualMap:Z,series:X};return"bmap"===r?(_extends(K.series[0],{coordinateSystem:"bmap",pointSize:w,blurSize:N}),utils.getBmap(b,S).then(function(e){return _extends({bmap:h},K)})):"map"===r?(K.series[0].coordinateSystem="geo",utils.getMapJSON({position:V,positionJsonLink:M,beforeRegisterMapOnce:C,mapURLProfix:D}).then(function(e){var t=_extends({map:V},y);return L&&(e=L(e)),echarts.registerMap(V,e,$),_extends({geo:t},K)})):"amap"===r?(_extends(K.series[0],{coordinateSystem:"amap",pointSize:w,blurSize:N}),utils.getAmap(b,S).then(function(e){return _extends({amap:x},K)})):_extends({xAxis:Y,yAxis:I,tooltip:J},K)},VeHeatmap=_extends({},Core,{name:"VeHeatmap",data:function(){return this.chartHandler=heatmap$1,{}}});function getScatterLegend(e,t){return{data:e,formatter:function(e){return null!=t[e]?t[e]:e}}}function getScatterTooltip(e){return{trigger:e.tooltipTrigger,formatter:function(t){return utilsLite.isArray(t)?t.map(function(t){return getTooltipContent(t,e)}).join(""):getTooltipContent(t,e)}}}function getTooltipContent(e,t){var i=t.labelMap,a=t.columns,n=t.dataType,r=t.digit,o=[],s=e.color,l=e.seriesName,u=e.data.value;return o.push(constants.itemPoint(s)+" "+l+"<br>"),u.forEach(function(e,t){var s=i[a[t]]||a[t],l=isNaN(e)?e:utils.getFormated(e,n[a[t]],r);o.push(s+": "+l+"<br>")}),o.join("")}function getScatterXAxis(e){var t=e.xAxisName,i=e.axisVisible,a=e.xAxisType,n=e.rows,r=e.dataLabels,o=e.dimension,s=[];return r.forEach(function(e){n[e].forEach(function(e){var t=e[o];t&&!~s.indexOf(t)&&s.push(t)})}),[{type:a,show:i,name:t,data:s}]}function getScatterYAxis(e){var t=e.min,i=e.max,a=e.scale,n=e.yAxisName,r=e.dataType,o=e.metrics,s=e.digit;return{type:"value",show:e.axisVisible,scale:a,min:t,max:i,axisTick:{show:!1},name:n,axisLabel:{formatter:function(e){return utils.getFormated(e,r[o[0]],s)}}}}function getScatterSeries(e){var t=e.rows,i=e.dataLabels,a=e.columns,n=e.metrics,r=e.dimension,o=e.label,s=e.itemStyle,l=e.symbol,u=e.symbolSizeMax,d=e.symbolSize,m=e.symbolRotate,c=e.symbolOffset,p=e.cursor,f=a.filter(function(e){return!~n.indexOf(e)&&e!==r}),g=[];i.forEach(function(e){t[e].forEach(function(e){g.push(e[n[1]])})});var v=Math.max.apply(null,g),h=[];return i.forEach(function(e){var i=[];t[e].forEach(function(e){var t={value:[]};t.value.push(e[r],e[n[0]],e[n[1]]),f.forEach(function(i){t.value.push(e[i])}),t.symbolSize=d||e[n[1]]/v*u,i.push(t)}),h.push({type:"scatter",data:i,name:e,label:o,itemStyle:s,symbol:l,symbolRotate:m,symbolOffset:c,cursor:p})}),h}var scatter$1=function(e,t,i,a){var n=i.dimension,r=void 0===n?e[0]:n,o=i.metrics,s=void 0===o?[e[1],e[2]]:o,l=i.dataType,u=void 0===l?{}:l,d=i.xAxisType,m=void 0===d?"category":d,c=i.xAxisName,p=i.yAxisName,f=i.digit,g=void 0===f?2:f,v=i.legendName,h=void 0===v?{}:v,x=i.labelMap,y=void 0===x?{}:x,b=i.tooltipTrigger,A=void 0===b?"item":b,S=i.axisVisible,V=void 0===S||S,M=i.symbolSizeMax,L=void 0===M?50:M,T=i.symbol,w=i.symbolSize,_=i.symbolRotate,N=i.symbolOffset,E=i.cursor,O=i.min,F=i.max,C=i.scale,R=i.label,D=i.itemStyle;if(utilsLite.isArray(t)){var k=_extends({},i,{xAxisName:c?[c]:void 0,yAxisName:p?[p]:void 0,scale:C?[C]:void 0,min:O?[O]:void 0,max:F?[F]:void 0,dimension:r?[r]:void 0}),$=line$1(e,t,k,a);return $&&$.series?($.series.forEach(function(e){_extends(e,{type:"scatter",symbol:T,symbolSize:w||10,symbolRotate:_,symbolOffset:N,cursor:E,label:R,itemStyle:D})}),$):{}}var H=a.tooltipVisible,P=a.legendVisible,q=Object.keys(t);return{legend:P&&getScatterLegend(q,h),tooltip:H&&getScatterTooltip({tooltipTrigger:A,labelMap:y,columns:e,dataType:u,digit:g}),xAxis:getScatterXAxis({xAxisName:c,axisVisible:V,xAxisType:m,dataLabels:q,dimension:r,rows:t}),yAxis:getScatterYAxis({min:O,max:F,scale:C,yAxisName:p,dataType:u,metrics:s,digit:g,axisVisible:V}),series:getScatterSeries({rows:t,dataLabels:q,columns:e,metrics:s,dimension:r,label:R,itemStyle:D,symbol:T,symbolSizeMax:L,symbolSize:w,symbolRotate:_,symbolOffset:N,cursor:E})}},VeScatter=_extends({},Core,{name:"VeScatter",data:function(){return this.chartHandler=scatter$1,{}}}),DEFAULT_MA=[5,10,20,30],DEFAULT_K_NAME="日K",DEFAULT_DOWN_COLOR="#ec0000",DEFAULT_UP_COLOR="#00da3c",DEFAULT_START=50,DEFAULT_END=100,SHOW_FALSE={show:!1};function getCandleLegend(e){var t=e.showMA,i=e.MA,a=e.legendName,n=e.labelMap,r=[DEFAULT_K_NAME];return t&&(r=r.concat(i.map(function(e){return"MA"+e}))),n&&(r=r.map(function(e){return null==n[e]?e:n[e]})),{data:r,formatter:function(e){return null!=a[e]?a[e]:e}}}function getCandleTooltip(e){var t=e.metrics,i=e.dataType,a=e.digit,n=e.labelMap;return{trigger:"axis",axisPointer:{type:"cross"},position:function(e,t,i,a,n){var r={top:10};return r[e[0]<n.viewSize[0]/2?"right":"left"]=60,r},formatter:function(e){var r=[];return r.push(e[0].axisValue+"<br>"),e.forEach(function(e){var o=e.data,s=e.seriesName,l=e.componentSubType,u=e.color,d=null==n[s]?s:n[s];if(r.push(constants.itemPoint(u)+" "+d+": "),"candlestick"===l)r.push("<br>"),t.slice(0,4).forEach(function(e,t){var s=null!=n[e]?n[e]:e,l=utils.getFormated(o[t+1],i,a);r.push("- "+s+": "+l+"<br>")});else if("line"===l){var m=utils.getFormated(o,i,a);r.push(m+"<br>")}else if("bar"===l){var c=utils.getFormated(o[1],i,a);r.push(c+"<br>")}}),r.join("")}}}function getCandleVisualMap(e){var t=e.downColor,i=e.upColor,a=e.MA;return{show:!1,seriesIndex:e.showMA?1+a.length:1,dimension:2,pieces:[{value:1,color:t},{value:-1,color:i}]}}function getCandleGrid(e){return[{left:"10%",right:"8%",top:"10%",height:e.showVol?"50%":"65%",containLabel:!1},{left:"10%",right:"8%",top:"65%",height:"16%",containLabel:!1}]}function getCandleXAxis(e){var t=e.dims,i={onZero:!1};return[{type:"category",data:t,scale:!0,boundaryGap:!1,axisLine:i,splitLine:SHOW_FALSE,min:"dataMin",max:"dataMax"},{type:"category",gridIndex:1,data:t,scale:!0,boundaryGap:!1,axisLine:i,axisTick:SHOW_FALSE,splitLine:SHOW_FALSE,axisLabel:SHOW_FALSE,min:"dataMin",max:"dataMax"}]}function getCandleYAxis(e){var t=e.dataType,i=e.digit;return[{scale:!0,axisTick:SHOW_FALSE,axisLabel:{formatter:function(e){return utils.getFormated(e,t,i)}}},{scale:!0,gridIndex:1,splitNumber:2,axisLine:SHOW_FALSE,axisTick:SHOW_FALSE,splitLine:SHOW_FALSE,axisLabel:SHOW_FALSE}]}function getCandleDataZoom(e){var t=e.start,i=e.end;return[{type:"inside",xAxisIndex:[0,1],start:t,end:i},{show:!0,xAxisIndex:[0,1],type:"slider",top:"85%",start:t,end:i}]}function getCandleSeries(e){var t=e.values,i=e.volumes,a=e.upColor,n=e.downColor,r=e.showMA,o=e.MA,s=e.showVol,l=e.labelMap,u=e.digit,d=e.itemStyle||{normal:{color:a,color0:n,borderColor:null,borderColor0:null}},m={normal:{opacity:.5}},c=[{name:null==l[DEFAULT_K_NAME]?DEFAULT_K_NAME:l[DEFAULT_K_NAME],type:"candlestick",data:t,itemStyle:d}];return r&&o.forEach(function(e){var i="MA"+e;c.push({name:null==l[i]?i:l[i],data:calculateMA(e,t,u),type:"line",lineStyle:m,smooth:!0})}),s&&c.push({name:"Volume",type:"bar",xAxisIndex:1,yAxisIndex:1,data:i}),c}function calculateMA(e,t,i){var a=[];return t.forEach(function(n,r){if(r<e)a.push("-");else{for(var o=0,s=0;s<e;s++)o+=t[r-s][1];a.push(+(o/e).toFixed(i))}}),a}var candle=function(e,t,i,a){var n=i.dimension,r=void 0===n?e[0]:n,o=i.metrics,s=void 0===o?e.slice(1,6):o,l=i.digit,u=void 0===l?2:l,d=i.itemStyle,m=i.labelMap,c=void 0===m?{}:m,p=i.legendName,f=void 0===p?{}:p,g=i.MA,v=void 0===g?DEFAULT_MA:g,h=i.showMA,x=void 0!==h&&h,y=i.showVol,b=void 0!==y&&y,A=i.showDataZoom,S=void 0!==A&&A,V=i.downColor,M=void 0===V?DEFAULT_DOWN_COLOR:V,L=i.upColor,T=void 0===L?DEFAULT_UP_COLOR:L,w=i.start,_=void 0===w?DEFAULT_START:w,N=i.end,E=void 0===N?DEFAULT_END:N,O=i.dataType,F=a.tooltipVisible,C=a.legendVisible,R=utilsLite.isArray(t[0]),D=[],k=[],$=[],H=s.slice(0,4),P=s[4];R?t.forEach(function(t){var i=[];D.push(t[e.indexOf(r)]),H.forEach(function(a){i.push(t[e.indexOf(a)])}),k.push(i),P&&$.push(t[e.indexOf(P)])}):t.forEach(function(e,t){var i=[];if(D.push(e[r]),H.forEach(function(t){i.push(e[t])}),k.push(i),P){var a=e[s[0]]>e[s[1]]?1:-1;$.push([t,e[P],a])}});var q=C&&getCandleLegend({showMA:x,MA:v,legendName:f,labelMap:c}),j=F&&getCandleTooltip({metrics:s,dataType:O,digit:u,labelMap:c}),W=b&&getCandleVisualMap({downColor:M,upColor:T,MA:v,showMA:x}),z=S&&getCandleDataZoom({start:_,end:E});return{legend:q,tooltip:j,visualMap:W,grid:getCandleGrid({showVol:b}),xAxis:getCandleXAxis({dims:D}),yAxis:getCandleYAxis({dataType:O,digit:u}),dataZoom:z,series:getCandleSeries({values:k,volumes:$,upColor:T,downColor:M,showMA:x,MA:v,showVol:b,labelMap:c,digit:u,itemStyle:d}),axisPointer:{link:{xAxisIndex:"all"}}}},VeCandle=_extends({},Core,{name:"VeCandle",data:function(){return this.chartHandler=candle,{}}});function getTooltip$3(e){var t=e.tooltipFormatter,i=e.dataType,a=e.digit;return{formatter:function(e){var n=e.seriesName,r=e.data,o=r.value,s=r.name;if(t)return t.apply(null,arguments);var l=[];return l.push(n+": "),l.push(utils.getFormated(o,i[n],a)+" "+s),l.join("")}}}function getSeries$3(e){var t=e.rows,i=e.dimension,a=e.metrics,n=e.digit,r=e.dataType,o=e.labelMap,s=e.seriesMap,l=e.dataName;return t.map(function(e){var t=e[i],u=s[t],d={type:"gauge",name:null!=o[t]?o[t]:t,data:[{name:l[t]||"",value:e[a]}],detail:{formatter:function(e){return utils.getFormated(e,r[t],n)}},axisLabel:{formatter:function(e){return utils.getFormated(e,r[t],n)}}};return u&&Object.keys(u).forEach(function(e){utilsLite.isObject(d[e])?_extends(d[e],u[e]):d[e]=u[e]}),d})}var gauge$1=function(e,t,i,a){var n=i.dimension,r=void 0===n?e[0]:n,o=i.metrics,s=void 0===o?e[1]:o,l=i.digit,u=void 0===l?2:l,d=i.dataType,m=void 0===d?{}:d,c=i.labelMap,p=void 0===c?{}:c,f=i.seriesMap,g=void 0===f?{}:f,v=i.dataName,h=void 0===v?{}:v,x=a.tooltipFormatter;return{tooltip:a.tooltipVisible&&getTooltip$3({tooltipFormatter:x,dataType:m}),series:getSeries$3({rows:t,dimension:r,metrics:s,digit:u,dataType:m,labelMap:p,seriesMap:g,dataName:h})}},VeGauge=_extends({},Core,{name:"VeGauge",data:function(){return this.chartHandler=gauge$1,{}}});function getTreeLegend(e){var t=e.dimension;return{data:e.rows.map(function(e){return e[t]})}}function getTreeTooltip(e){return{trigger:"item",triggerOn:"mousemove",formatter:e.tooltipFormatter}}function getTreeSeries(e){var t=e.dimension,i=e.metrics,a=e.rows,n=e.seriesMap,r=[];return a.forEach(function(e){var a=e[t],o=n[a],s={type:"tree",name:e[t],data:e[i]};n[e[t]]&&Object.keys(o).forEach(function(e){utilsLite.isObject(s[e])?_extends(s[e],o[e]):s[e]=o[e]}),r.push(s)}),r}var tree$1=function(e,t,i,a){var n=i.dimension,r=void 0===n?e[0]:n,o=i.metrics,s=void 0===o?e[1]:o,l=i.seriesMap,u=void 0===l?{}:l,d=a.legendVisible,m=a.tooltipFormatter,c=a.tooltipVisible;return{series:getTreeSeries({dimension:r,metrics:s,rows:t,seriesMap:u}),legend:d&&t.length>1&&getTreeLegend({dimension:r,rows:t}),tooltip:c&&getTreeTooltip({tooltipFormatter:m})}},VeTree=_extends({},Core,{name:"VeTree",data:function(){return this.chartHandler=tree$1,{}}});function getTooltip$4(e){var t=e.tooltipFormatter,i=e.dataType,a=e.digit;return{show:!0,formatter:function(e){var n=e.seriesName,r=e.value;return t?t.apply(null,arguments):[n+": ",utils.getFormated(r,i,a)].join("")}}}function getSeries$4(e){var t=e.dimension,i=e.metrics,a=e.seriesMap,n=e.rows,r=e.wave,o=r,s=utilsLite.isArray(a)?a.length:0;return n.slice().map(function(e,n){var l=[],u={type:"liquidFill"},d=e[t],m=Number(e[i]),c={};return utilsLite.isArray(a)?c=a[n]?a[n]:a[s-1]:utilsLite.isObject(a[d])&&(c=a[d]),utilsLite.isArray(r)&&utilsLite.isArray(r[0])&&(o=utilsLite.isArray(r[n])?r[n]:r[r.length-1]),l.push({value:m}),o&&o.length&&(l=l.concat(o.map(function(e){return{value:e}}))),u=_extends(u,{data:l,name:d},c)})}var liquidfill=function(e,t,i,a){var n=i.dimension,r=void 0===n?e[0]:n,o=i.metrics,s=void 0===o?e[1]:o,l=i.seriesMap,u=void 0===l?{}:l,d=i.dataType,m=void 0===d?"percent":d,c=i.digit,p=void 0===c?2:c,f=i.wave,g=void 0===f?[]:f,v=a.tooltipVisible,h=a.tooltipFormatter;return{tooltip:v&&getTooltip$4({tooltipFormatter:h,dataType:m,digit:p}),series:getSeries$4({rows:t,columns:e,dimension:r,metrics:s,seriesMap:u,wave:g})}},VeLiquidfill=_extends({},Core,{name:"VeLiquidfill",data:function(){return this.chartHandler=liquidfill,{}}});function getSeries$5(e){var t=e.dimension,i=e.metrics,a=e.rows,n=e.color,r=e.sizeMax,o=e.sizeMin,s=e.shape,l={type:"wordCloud",textStyle:{normal:{color:!utilsLite.isArray(n)&&n?n:function(){return"rgb("+[Math.round(160*Math.random()),Math.round(160*Math.random()),Math.round(160*Math.random())].join(",")+")"}}},shape:s,sizeRange:[o,r]},u=utilsLite.isArray(n)?n.length:0,d=a.slice().map(function(e){var a={name:e[t],value:e[i]};return u>0&&(a.textStyle={normal:{color:n[Math.floor(Math.random()*u)]}}),a});return l.data=d,[l]}function getTooltip$5(e){var t=e.tooltipFormatter;return{show:!0,formatter:function(e){var i=e.data,a=i.name,n=i.value;return t?t.apply(null,e):a+": "+n}}}var wordcloud=function(e,t,i,a){var n=i.dimension,r=void 0===n?e[0]:n,o=i.metrics,s=void 0===o?e[1]:o,l=i.color,u=void 0===l?"":l,d=i.sizeMax,m=void 0===d?60:d,c=i.sizeMin,p=void 0===c?12:c,f=i.shape,g=void 0===f?"circle":f,v=a.tooltipVisible,h=a.tooltipFormatter;return{series:getSeries$5({dimension:r,metrics:s,rows:t,color:u,sizeMax:m,sizeMin:p,shape:g}),tooltip:v&&getTooltip$5({tooltipFormatter:h})}},VeWordcloud=_extends({},Core,{name:"VeWordcloud",data:function(){return this.chartHandler=wordcloud,{}}}),components=[VeBar,VeHistogram,VeLine,VePie,VeRing,VeWaterfall,VeFunnel,VeRadar,VeChart,VeMap,VeBmap,VeAmap,VeSankey,VeHeatmap,VeScatter,VeCandle,VeGauge,VeTree,VeLiquidfill,VeWordcloud];function install(e,t){components.forEach(function(t){e.component(t.name,t)})}"undefined"!=typeof window&&window.Vue&&install(window.Vue);var index={VeBar:VeBar,VeHistogram:VeHistogram,VeRing:VeRing,VeLine:VeLine,VePie:VePie,VeWaterfall:VeWaterfall,VeFunnel:VeFunnel,VeRadar:VeRadar,VeChart:VeChart,VeMap:VeMap,VeBmap:VeBmap,VeAmap:VeAmap,VeSankey:VeSankey,VeScatter:VeScatter,VeCandle:VeCandle,VeGauge:VeGauge,VeTree:VeTree,VeLiquidfill:VeLiquidfill,VeWordcloud:VeWordcloud,install:install};module.exports=index;
