/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.statistics.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.QueryFilter;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.model.SysDictionaryDetail;
import com.artfess.yhxt.basedata.dao.RoadDao;
import com.artfess.yhxt.basedata.manager.BizCourseDetailsManager;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.budget.manager.YearBudgetDetailedManager;
import com.artfess.yhxt.budget.manager.YearBudgetManager;
import com.artfess.yhxt.budget.model.YearBudget;
import com.artfess.yhxt.budget.model.YearBudgetDetailed;
import com.artfess.yhxt.contract.dao.WorkOrderInformationDao;
import com.artfess.yhxt.contract.manager.WorkOrderInformationManager;
import com.artfess.yhxt.contract.model.WorkOrderInformation;
import com.artfess.yhxt.disease.model.Disease;
import com.artfess.yhxt.schedule.StatisticsSchedule;
import com.artfess.yhxt.specialproject.manager.BizEngineeringProjectManager;
import com.artfess.yhxt.specialproject.manager.BizProjectContractDetailsManager;
import com.artfess.yhxt.specialproject.manager.BizProjectContractManager;
import com.artfess.yhxt.specialproject.manager.ProjectAcceptanceManager;
import com.artfess.yhxt.specialproject.model.BizEngineeringProject;
import com.artfess.yhxt.statistics.dao.SiteStatisticDao;
import com.artfess.yhxt.statistics.dao.WorkStatisticDao;
import com.artfess.yhxt.statistics.manager.WorkStatisticManager;
import com.artfess.yhxt.statistics.model.SiteStatistic;
import com.artfess.yhxt.statistics.model.WorkStatistic;
import com.artfess.yhxt.statistics.model.YearBudgetSum;
import com.artfess.yhxt.statistics.vo.CheckRoadVo;
import com.artfess.yhxt.statistics.vo.CheckVo;
import com.artfess.yhxt.statistics.vo.CountDayDisease;
import com.artfess.yhxt.statistics.vo.CountDisease;
import com.artfess.yhxt.statistics.vo.CountSpecialProject;
import com.artfess.yhxt.statistics.vo.CountTypeDisease;
import com.artfess.yhxt.statistics.vo.CountWorkOrder;
import com.artfess.yhxt.statistics.vo.MoneyVo;
import com.artfess.yhxt.statistics.vo.NewCountWorkOrderVo;
import com.artfess.yhxt.statistics.vo.NewWorkCountVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Service;

@Service
public class WorkStatisticManagerImpl
extends BaseManagerImpl<WorkStatisticDao, WorkStatistic>
implements WorkStatisticManager {
    @Resource
    private RoadDao roadDao;
    @Resource
    private BizCourseDetailsManager bizCourseDetailsManager;
    @Resource
    private WorkOrderInformationManager workOrderInformationManager;
    @Resource
    private RoadManager roadManager;
    @Resource
    private BizEngineeringProjectManager bizEngineeringProjectManager;
    @Resource
    private StatisticsSchedule statisticsSchedule;
    @Resource
    private SiteStatisticDao siteStatisticDao;
    @Resource
    private SysDictionaryManager sysDictionaryManager;
    @Resource
    private YearBudgetManager yearBudgetManager;
    @Resource
    private YearBudgetDetailedManager yearBudgetDetailedManager;
    @Resource
    private ProjectAcceptanceManager projectAcceptanceManager;
    @Resource
    private BizProjectContractManager bizProjectContractManager;
    @Resource
    private BizProjectContractDetailsManager bizProjectContractDetailsManager;
    @Resource
    private WorkOrderInformationDao workOrderInformationDao;

    @Override
    public List<WorkStatistic> getWorkJson(QueryFilter<WorkStatistic> queryFilter) {
        try {
            this.statisticsSchedule.scheduleWorkeCount();
            Map params = queryFilter.getParams();
            ArrayList<WorkStatistic> workStatisticArrayList = new ArrayList<WorkStatistic>();
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq(ObjectUtils.isNotEmpty(params.get("companyId")), (Object)"COMPANY_ID", params.get("companyId"));
            queryWrapper.eq(ObjectUtils.isNotEmpty(params.get("roadSegmentId")), (Object)"ID_", params.get("roadSegmentId"));
            queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
            List list = this.roadManager.list((Wrapper)queryWrapper);
            if (list.size() > 0) {
                for (Road road : list) {
                    WorkStatistic workStatistic;
                    if (ObjectUtils.isEmpty(params.get("accDateYear")) && ObjectUtils.isEmpty(params.get("accDateMonth"))) {
                        String mouth = new SimpleDateFormat("yyyy-MM").format(new Date());
                        params.put("accDateMonth", mouth);
                    }
                    if ((workStatistic = ((WorkStatisticDao)this.baseMapper).countWorkStatistic(params, road.getId())) == null) {
                        workStatistic = new WorkStatistic();
                    }
                    workStatistic.setRoadSegmentId(road.getId());
                    workStatistic.setRoadSegmentName(road.getName());
                    workStatisticArrayList.add(workStatistic);
                }
            }
            return workStatisticArrayList;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<SiteStatistic> getSiteJson(QueryFilter<WorkStatistic> queryFilter) {
        Map params = queryFilter.getParams();
        ArrayList<SiteStatistic> siteStatistics = new ArrayList<SiteStatistic>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(ObjectUtils.isNotEmpty(params.get("companyId")), (Object)"COMPANY_ID", params.get("companyId"));
        queryWrapper.eq(ObjectUtils.isNotEmpty(params.get("roadSegmentId")), (Object)"ID_", params.get("roadSegmentId"));
        queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        List list = this.roadManager.list((Wrapper)queryWrapper);
        if (list.size() > 0) {
            for (Road road : list) {
                if (ObjectUtils.isEmpty(params.get("accDateYear")) && ObjectUtils.isEmpty(params.get("accDateMonth"))) {
                    String mouth = new SimpleDateFormat("yyyy-MM").format(new Date());
                    params.put("accDateMonth", mouth);
                }
                SiteStatistic siteStatistic = ((WorkStatisticDao)this.baseMapper).countSiteStatistic(params, road.getId());
                siteStatistic.setRoadSegmentId(road.getId());
                siteStatistic.setRoadSegmentName(road.getName());
                siteStatistic.setAccDateMonth(params.get("accDateMonth").toString());
                siteStatistics.add(siteStatistic);
            }
        }
        return siteStatistics;
    }

    @Override
    public List<CheckVo> getCheckJson(QueryFilter<WorkStatistic> queryFilter) {
        Map params = queryFilter.getParams();
        if (ObjectUtils.isEmpty(params.get("accDateYear")) && ObjectUtils.isEmpty(params.get("accDateMonth"))) {
            String mouth = new SimpleDateFormat("yyyy-MM").format(new Date());
            params.put("accDateMonth", mouth);
        }
        return ((WorkStatisticDao)this.baseMapper).getCheckJson(params);
    }

    @Override
    public List<CheckRoadVo> getCheckRodeJson(QueryFilter<WorkStatistic> queryFilter) {
        Map params = queryFilter.getParams();
        ArrayList<CheckRoadVo> checkRoadVos = new ArrayList<CheckRoadVo>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(ObjectUtils.isNotEmpty(params.get("companyId")), (Object)"COMPANY_ID", params.get("companyId"));
        queryWrapper.eq(ObjectUtils.isNotEmpty(params.get("roadSegmentId")), (Object)"ID_", params.get("roadSegmentId"));
        queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        List list = this.roadManager.list((Wrapper)queryWrapper);
        if (ObjectUtils.isEmpty(params.get("accDateYear")) && ObjectUtils.isEmpty(params.get("accDateMonth"))) {
            String year = new SimpleDateFormat("yyyy").format(new Date());
            params.put("accDateYear", year);
        }
        if (list.size() > 0) {
            for (Road road : list) {
                List<CheckVo> checkVo = ((WorkStatisticDao)this.baseMapper).countcheckVo(params, road.getId());
                CheckRoadVo checkRoadVo = new CheckRoadVo();
                checkRoadVo.setRoadSegmentId(road.getId());
                checkRoadVo.setRoadSegmentName(road.getName());
                checkRoadVo.setCheckVos(checkVo);
                checkRoadVos.add(checkRoadVo);
            }
        }
        return checkRoadVos;
    }

    @Override
    public List<CountSpecialProject> countSpecialProject(QueryFilter<WorkStatistic> queryFilter) {
        ArrayList<CountSpecialProject> countSpecialProjects = new ArrayList<CountSpecialProject>();
        Map params = queryFilter.getParams();
        if (ObjectUtils.isNotEmpty(params.get("accDateMonth"))) {
            String[] split = params.get("accDateMonth").toString().split("-");
            params.put("accDateYear", split[0]);
        }
        if (ObjectUtils.isEmpty(params.get("accDateYear")) && ObjectUtils.isEmpty(params.get("accDateMonth"))) {
            String year = new SimpleDateFormat("yyyy").format(new Date());
            params.put("accDateYear", year);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        queryWrapper.eq(ObjectUtils.isNotEmpty(params.get("roadSegmentId")), (Object)"id_", params.get("roadSegmentId"));
        List roadList = this.roadDao.selectList((Wrapper)queryWrapper);
        for (Road road : roadList) {
            CountSpecialProject countSpecialProject = new CountSpecialProject();
            countSpecialProject.setRoadSegmentId(road.getId());
            countSpecialProject.setRoadSegmentName(road.getName());
            QueryWrapper queryWrapperYearBudget = new QueryWrapper();
            queryWrapperYearBudget.eq((Object)"IS_DELE_", (Object)"0");
            queryWrapperYearBudget.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
            queryWrapperYearBudget.eq(ObjectUtils.isNotEmpty(params.get("accDateYear")), (Object)"ASCRIPTION_YEAR_", params.get("accDateYear"));
            YearBudget yearBudget = (YearBudget)((Object)this.yearBudgetManager.getOne((Wrapper)queryWrapperYearBudget));
            if (yearBudget != null) {
                QueryWrapper yearBudgetDetailedQueryWrapperFRCZX = new QueryWrapper();
                yearBudgetDetailedQueryWrapperFRCZX.eq((Object)"YEAR_BUDGET_ID_", (Object)yearBudget.getId());
                yearBudgetDetailedQueryWrapperFRCZX.eq((Object)"BUDGET_TYPE_", (Object)"FRCZX");
                List yearBudgetDetailedListFRCZX = this.yearBudgetDetailedManager.list((Wrapper)yearBudgetDetailedQueryWrapperFRCZX);
                countSpecialProject.setPlannedProject(String.valueOf(yearBudgetDetailedListFRCZX.size()));
                BigDecimal bigDecimal = yearBudgetDetailedListFRCZX.stream().filter(s -> s != null && s.getTotalPrice() != null).map(YearBudgetDetailed::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            QueryWrapper runWrapper = new QueryWrapper();
            runWrapper.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
            runWrapper.eq((Object)"PROJECT_TYPE_", (Object)"2");
            runWrapper.eq((Object)"IS_DELE_", (Object)"0");
            runWrapper.eq((Object)"STARTUP_FLAG_", (Object)"1");
            countSpecialProject.setRunningProject(String.valueOf(this.bizEngineeringProjectManager.list((Wrapper)runWrapper).size()));
            QueryWrapper unQueryWrapperProject = new QueryWrapper();
            unQueryWrapperProject.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
            unQueryWrapperProject.eq((Object)"PROJECT_TYPE_", (Object)"2");
            unQueryWrapperProject.eq((Object)"IS_DELE_", (Object)"0");
            unQueryWrapperProject.eq(ObjectUtils.isNotEmpty(params.get("accDateYear")), (Object)"PROJECT_YEAR_", params.get("accDateYear"));
            List list = this.bizEngineeringProjectManager.list((Wrapper)unQueryWrapperProject);
            if (list.size() > 0) {
                String projectIds = list.stream().map(BizEngineeringProject::getId).collect(Collectors.joining(","));
                List<String> ids = Arrays.asList(projectIds.split(","));
                QueryWrapper acceptanceQueryWrapper = new QueryWrapper();
                acceptanceQueryWrapper.in((Object)"PROJECT_ID_", ids);
                int count = this.projectAcceptanceManager.count((Wrapper)acceptanceQueryWrapper);
                countSpecialProject.setFinishProject(String.valueOf(count));
            }
            countSpecialProjects.add(countSpecialProject);
        }
        return countSpecialProjects;
    }

    @Override
    public List<YearBudgetSum> countYearBudgetData(QueryFilter<WorkStatistic> queryFilter) {
        Map params = queryFilter.getParams();
        Object accDateMonth = params.get("accDateMonth");
        if (ObjectUtils.isNotEmpty(accDateMonth)) {
            String[] split = accDateMonth.toString().split("-");
            params.put("accDateMonth", split[0]);
        }
        if (ObjectUtils.isEmpty(params.get("accDateYear")) && ObjectUtils.isEmpty(params.get("accDateMonth"))) {
            String year = new SimpleDateFormat("yyyy").format(new Date());
            params.put("accDateYear", year);
        }
        return ((WorkStatisticDao)this.baseMapper).countYearBudgetData(params);
    }

    @Override
    public List<SiteStatistic> countCheckJsonDetail() {
        QueryWrapper queryWrapper = new QueryWrapper();
        return this.siteStatisticDao.selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<MoneyVo> getMoneyJson(QueryFilter<WorkStatistic> queryFilter) {
        Map params = queryFilter.getParams();
        ArrayList<MoneyVo> moneyVos = new ArrayList<MoneyVo>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(ObjectUtils.isNotEmpty(params.get("companyId")), (Object)"COMPANY_ID", params.get("companyId"));
        queryWrapper.eq(ObjectUtils.isNotEmpty(params.get("roadSegmentId")), (Object)"ID_", params.get("roadSegmentId"));
        queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        List list = this.roadManager.list((Wrapper)queryWrapper);
        if (ObjectUtils.isEmpty(params.get("accDateYear")) && ObjectUtils.isEmpty(params.get("accDateMonth"))) {
            String year = new SimpleDateFormat("yyyy").format(new Date());
            params.put("accDateYear", year);
        }
        if (list.size() > 0) {
            for (Road road : list) {
                MoneyVo moneyVo = ((WorkStatisticDao)this.baseMapper).countMoneyRoadSegment(params, road.getId());
                if (moneyVo == null) {
                    moneyVo = new MoneyVo();
                }
                moneyVo.setRoadSegmentId(road.getId());
                moneyVo.setRoadSegmentName(road.getName());
                moneyVos.add(moneyVo);
            }
        }
        return moneyVos;
    }

    @Override
    public List<YearBudgetSum> getYearBudgetJson(QueryFilter<WorkStatistic> queryFilter) {
        Map params = queryFilter.getParams();
        Object accDateMonth = params.get("accDateMonth");
        if (ObjectUtils.isNotEmpty(accDateMonth)) {
            String[] split = accDateMonth.toString().split("-");
            params.put("accDateMonth", split[0]);
        }
        if (ObjectUtils.isEmpty(params.get("accDateYear")) && ObjectUtils.isEmpty(params.get("accDateMonth"))) {
            String year = new SimpleDateFormat("yyyy").format(new Date());
            params.put("accDateYear", year);
        }
        return ((WorkStatisticDao)this.baseMapper).getYearBudgetJson(params);
    }

    @Override
    public List<CountDisease> countAmountDisease(QueryFilter queryFilter) {
        Map params = queryFilter.getParams();
        Object roadId = params.get("roadSegmentId");
        ArrayList<CountDisease> countDiseaseList = new ArrayList<CountDisease>();
        if (ObjectUtils.isEmpty(params.get("accDateYear")) && ObjectUtils.isEmpty(params.get("accDateMonth"))) {
            String mouth = new SimpleDateFormat("yyyy-MM").format(new Date());
            params.put("accDateMonth", mouth);
        }
        if (ObjectUtils.isEmpty(roadId)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
            List roadList = this.roadDao.selectList((Wrapper)queryWrapper);
            for (Road road : roadList) {
                CountDisease countDisease = new CountDisease();
                String id = road.getId();
                params.put("roadSegmentId", id);
                Integer finished = ((WorkStatisticDao)this.baseMapper).countAmountDiseaseFinished(params);
                Integer unFinished = ((WorkStatisticDao)this.baseMapper).countAmountDiseaseUnFinished(params);
                countDisease.setRoadId(road.getId());
                countDisease.setRoadName(road.getName());
                countDisease.setCountDisFinished(finished.toString());
                countDisease.setCountDisUnFinished(unFinished.toString());
                countDiseaseList.add(countDisease);
            }
        } else {
            CountDisease countDisease = new CountDisease();
            String id = roadId.toString();
            Integer finished = ((WorkStatisticDao)this.baseMapper).countAmountDiseaseFinished(params);
            Integer unFinished = ((WorkStatisticDao)this.baseMapper).countAmountDiseaseUnFinished(params);
            Road road = (Road)((Object)this.roadDao.selectById((Serializable)((Object)id)));
            countDisease.setRoadId(id);
            countDisease.setRoadName(road.getName());
            QueryWrapper queryWrapper = new QueryWrapper();
            countDisease.setRoadName(((Road)((Object)this.roadDao.selectOne((Wrapper)queryWrapper.eq((Object)"ID_", (Object)id)))).getName());
            countDisease.setCountDisFinished(finished.toString());
            countDisease.setCountDisUnFinished(unFinished.toString());
            countDiseaseList.add(countDisease);
        }
        return countDiseaseList;
    }

    @Override
    public List<CountTypeDisease> countTypeDisease(QueryFilter queryFilter) {
        try {
            Map bhlx = this.sysDictionaryManager.queryDictItemsByCode("bhlx");
            Map params = queryFilter.getParams();
            Object roadId = params.get("roadSegmentId");
            ArrayList<CountTypeDisease> countTypeDiseases = new ArrayList<CountTypeDisease>();
            if (ObjectUtils.isEmpty(params.get("accDateYear")) && ObjectUtils.isEmpty(params.get("accDateMonth"))) {
                String mouth = new SimpleDateFormat("yyyy-MM").format(new Date());
                params.put("accDateMonth", mouth);
            }
            if (ObjectUtils.isEmpty(roadId)) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
                List roadList = this.roadDao.selectList((Wrapper)queryWrapper);
                for (Road road : roadList) {
                    List list = (List)bhlx.get("bhlx");
                    ArrayList<SysDictionaryDetail> sysDictionaryDetails = new ArrayList<SysDictionaryDetail>();
                    for (int i = 0; i < list.size(); ++i) {
                        SysDictionaryDetail detail = null;
                        try {
                            Map map = (Map)list.get(i);
                            detail = (SysDictionaryDetail)BeanUtil.toBean((Object)map, SysDictionaryDetail.class);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            detail = (SysDictionaryDetail)list.get(i);
                        }
                        sysDictionaryDetails.add(detail);
                    }
                    for (SysDictionaryDetail sysDictionaryDetail : sysDictionaryDetails) {
                        params.put("roadSegmentId", road.getId());
                        params.put("type", sysDictionaryDetail.getValue());
                        List<Disease> countType = ((WorkStatisticDao)this.baseMapper).countTypeDisease(params);
                        CountTypeDisease countTypeDisease = new CountTypeDisease();
                        countTypeDisease.setSubjectName(sysDictionaryDetail.getName());
                        countTypeDisease.setSubjectCode(sysDictionaryDetail.getValue());
                        countTypeDisease.setRoadSegmentId(road.getId());
                        countTypeDisease.setRoadSegmentName(road.getName());
                        countTypeDisease.setCountTypeDis(String.valueOf(countType.size()));
                        countTypeDiseases.add(countTypeDisease);
                    }
                }
                return countTypeDiseases;
            }
            List list = (List)bhlx.get("bhlx");
            ArrayList<SysDictionaryDetail> sysDictionaryDetails = new ArrayList<SysDictionaryDetail>();
            Road road = (Road)((Object)this.roadDao.selectById((Serializable)((Object)roadId.toString())));
            for (int i = 0; i < list.size(); ++i) {
                Map map = (Map)list.get(i);
                SysDictionaryDetail detail = (SysDictionaryDetail)BeanUtil.toBean((Object)map, SysDictionaryDetail.class);
                sysDictionaryDetails.add(detail);
            }
            for (SysDictionaryDetail sysDictionaryDetail : sysDictionaryDetails) {
                params.put("type", sysDictionaryDetail.getValue());
                List<Disease> countType = ((WorkStatisticDao)this.baseMapper).countTypeDisease(params);
                CountTypeDisease countTypeDisease = new CountTypeDisease();
                countTypeDisease.setSubjectName(sysDictionaryDetail.getName());
                countTypeDisease.setSubjectCode(sysDictionaryDetail.getValue());
                countTypeDisease.setRoadSegmentId(road.getId());
                countTypeDisease.setRoadSegmentName(road.getName());
                countTypeDisease.setCountTypeDis(String.valueOf(countType.size()));
                countTypeDiseases.add(countTypeDisease);
            }
            return countTypeDiseases;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<CountDayDisease> countDayDisease(QueryFilter queryFilter) {
        ArrayList<CountDayDisease> countDayDiseases = new ArrayList<CountDayDisease>();
        Map params = queryFilter.getParams();
        Object roadId = params.get("roadSegmentId");
        if (ObjectUtils.isEmpty(params.get("accDateYear")) && ObjectUtils.isEmpty(params.get("accDateMonth"))) {
            String mouth = new SimpleDateFormat("yyyy-MM").format(new Date());
            params.put("accDateMonth", mouth);
        }
        if (ObjectUtils.isEmpty(roadId)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
            List roadList = this.roadDao.selectList((Wrapper)queryWrapper);
            for (Road road : roadList) {
                CountDayDisease countDayDisease = new CountDayDisease();
                String id = road.getId();
                params.put("roadSegmentId", id);
                Integer daySum = ((WorkStatisticDao)this.baseMapper).countDayDiseaseSum(params);
                Integer diseaseSum = ((WorkStatisticDao)this.baseMapper).countDiseaseSum(params);
                Integer avg = diseaseSum != 0 ? Integer.valueOf(daySum / diseaseSum) : Integer.valueOf(0);
                countDayDisease.setRoadId(road.getId());
                countDayDisease.setRoadName(road.getName());
                countDayDisease.setCountDayAvg(avg.toString());
                countDayDiseases.add(countDayDisease);
            }
        } else {
            CountDayDisease countDayDisease = new CountDayDisease();
            String id = roadId.toString();
            Integer daySum = ((WorkStatisticDao)this.baseMapper).countDayDiseaseSum(params);
            Integer diseaseSum = ((WorkStatisticDao)this.baseMapper).countDiseaseSum(params);
            Integer avg = diseaseSum != 0 ? Integer.valueOf(daySum / diseaseSum) : Integer.valueOf(0);
            countDayDisease.setRoadId(id);
            QueryWrapper queryWrapper = new QueryWrapper();
            countDayDisease.setRoadName(((Road)((Object)this.roadDao.selectOne((Wrapper)queryWrapper.eq((Object)"ID_", (Object)id)))).getName());
            countDayDisease.setCountDayAvg(avg.toString());
            countDayDiseases.add(countDayDisease);
        }
        return countDayDiseases;
    }

    @Override
    public List<NewCountWorkOrderVo> newCountWorkOrder(QueryFilter<WorkStatistic> queryFilter) {
        QueryWrapper orderQueryWrapper = new QueryWrapper();
        Map params = queryFilter.getParams();
        if (ObjectUtils.isEmpty(params.get("accDateYear")) && ObjectUtils.isEmpty(params.get("accDateMonth"))) {
            String mouth = new SimpleDateFormat("yyyy-MM").format(new Date());
            params.put("accDateMonth", mouth);
        }
        if (ObjectUtils.isNotEmpty(params.get("roadSegmentId"))) {
            List<String> ids = Arrays.asList(params.get("roadSegmentId").toString().split(","));
            params.put("ids", ids);
            orderQueryWrapper.in((Object)"ROAD_SEGMENT_ID_", ids);
        }
        List<Map<String, Object>> mapList = ((WorkStatisticDao)this.baseMapper).countWorkOrder(params);
        ArrayList<NewCountWorkOrderVo> returnList = new ArrayList<NewCountWorkOrderVo>();
        Map<String, List<Map>> groupMap = mapList.stream().collect(Collectors.groupingBy(e -> e.get("roadName").toString()));
        ArrayList<NewWorkCountVo> task1Children = new ArrayList<NewWorkCountVo>();
        ArrayList<NewWorkCountVo> task2Children = new ArrayList<NewWorkCountVo>();
        ArrayList<NewWorkCountVo> task4Children = new ArrayList<NewWorkCountVo>();
        ArrayList<NewWorkCountVo> task5Children = new ArrayList<NewWorkCountVo>();
        ArrayList<NewWorkCountVo> endChildren = new ArrayList<NewWorkCountVo>();
        ArrayList<NewWorkCountVo> overChildren = new ArrayList<NewWorkCountVo>();
        long userTask1 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask1")).count();
        for (String key : groupMap.keySet()) {
            List roadList;
            QueryWrapper queryWrapper;
            long task1Count = groupMap.get(key).stream().filter(s -> s.get("taskKey").equals("UserTask1")).count();
            long task7Count = groupMap.get(key).stream().filter(s -> s.get("taskKey").equals("UserTask7")).count();
            long task2Count = groupMap.get(key).stream().filter(s -> s.get("taskKey").equals("UserTask2")).count();
            long task3Count = groupMap.get(key).stream().filter(s -> s.get("taskKey").equals("UserTask3")).count();
            long task4Count = groupMap.get(key).stream().filter(s -> s.get("taskKey").equals("UserTask4")).count();
            long task5Count = groupMap.get(key).stream().filter(s -> s.get("taskKey").equals("UserTask5")).count();
            long task6Count = groupMap.get(key).stream().filter(s -> s.get("taskKey").equals("UserTask6")).count();
            long endCount = groupMap.get(key).stream().filter(s -> s.get("taskKey").equals("EndEvent1")).count();
            if (!"0".equals(String.valueOf(task1Count + task7Count))) {
                NewWorkCountVo task1 = new NewWorkCountVo();
                task1.setNumber(task1Count + task7Count);
                task1.setRoadName(key);
                queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
                queryWrapper.eq((Object)"NAME_", (Object)key);
                roadList = this.roadDao.selectList((Wrapper)queryWrapper);
                if (roadList.size() > 0) {
                    task1.setRoadId(((Road)((Object)roadList.get(0))).getId());
                }
                task1Children.add(task1);
            }
            if (!"0".equals(String.valueOf(task2Count + task3Count))) {
                NewWorkCountVo task2 = new NewWorkCountVo();
                task2.setNumber(task2Count + task3Count);
                task2.setRoadName(key);
                queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
                queryWrapper.eq((Object)"NAME_", (Object)key);
                roadList = this.roadDao.selectList((Wrapper)queryWrapper);
                if (roadList.size() > 0) {
                    task2.setRoadId(((Road)((Object)roadList.get(0))).getId());
                }
                task2Children.add(task2);
            }
            if (!"0".equals(String.valueOf(task4Count))) {
                NewWorkCountVo task4 = new NewWorkCountVo();
                task4.setNumber(task4Count);
                task4.setRoadName(key);
                queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
                queryWrapper.eq((Object)"NAME_", (Object)key);
                roadList = this.roadDao.selectList((Wrapper)queryWrapper);
                if (roadList.size() > 0) {
                    task4.setRoadId(((Road)((Object)roadList.get(0))).getId());
                }
                task4Children.add(task4);
            }
            if (!"0".equals(String.valueOf(task5Count + task6Count))) {
                NewWorkCountVo task5 = new NewWorkCountVo();
                task5.setNumber(task5Count + task6Count);
                task5.setRoadName(key);
                queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
                queryWrapper.eq((Object)"NAME_", (Object)key);
                roadList = this.roadDao.selectList((Wrapper)queryWrapper);
                if (roadList.size() > 0) {
                    task5.setRoadId(((Road)((Object)roadList.get(0))).getId());
                }
                task5Children.add(task5);
            }
            if ("0".equals(String.valueOf(endCount))) continue;
            NewWorkCountVo taskEnd = new NewWorkCountVo();
            taskEnd.setNumber(endCount);
            taskEnd.setRoadName(key);
            queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
            queryWrapper.eq((Object)"NAME_", (Object)key);
            roadList = this.roadDao.selectList((Wrapper)queryWrapper);
            if (roadList.size() > 0) {
                taskEnd.setRoadId(((Road)((Object)roadList.get(0))).getId());
            }
            endChildren.add(taskEnd);
        }
        long userTask7 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask7")).count();
        NewCountWorkOrderVo pdVo = new NewCountWorkOrderVo();
        pdVo.setName("\u6d3e\u5355\u4e2d");
        pdVo.setNumber(String.valueOf(userTask1 + userTask7));
        pdVo.setChildren(task1Children);
        returnList.add(pdVo);
        long userTask2 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask2")).count();
        long userTask3 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask3")).count();
        NewCountWorkOrderVo sgVo = new NewCountWorkOrderVo();
        sgVo.setName("\u65bd\u5de5\u4e2d");
        sgVo.setNumber(String.valueOf(userTask2 + userTask3));
        sgVo.setChildren(task2Children);
        returnList.add(sgVo);
        long userTask4 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask4")).count();
        NewCountWorkOrderVo ysVo = new NewCountWorkOrderVo();
        ysVo.setName("\u65bd\u5de5\u5355\u4f4d\u9a8c\u6536");
        ysVo.setNumber(String.valueOf(userTask4 + userTask7));
        ysVo.setChildren(task4Children);
        returnList.add(ysVo);
        long userTask5 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask5")).count();
        long userTask6 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask6")).count();
        NewCountWorkOrderVo shVo = new NewCountWorkOrderVo();
        shVo.setName("\u5ba1\u6838\u4e2d");
        shVo.setNumber(String.valueOf(userTask5 + userTask6));
        shVo.setChildren(task5Children);
        returnList.add(shVo);
        long endEvent1 = mapList.stream().filter(s -> s.get("taskKey").equals("EndEvent1")).count();
        NewCountWorkOrderVo endVo = new NewCountWorkOrderVo();
        endVo.setName("\u5df2\u5b8c\u6210");
        endVo.setNumber(String.valueOf(endEvent1));
        endVo.setChildren(endChildren);
        returnList.add(endVo);
        orderQueryWrapper.eq((Object)"OVERDUE_", (Object)"1");
        orderQueryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        if (ObjectUtils.isNotEmpty(params.get("accDateMonth"))) {
            Object month = params.get("accDateMonth");
            orderQueryWrapper.apply("date_format(ISSUE_DATE_,'%Y-%m') = {0}", new Object[]{month});
        }
        List overList = this.workOrderInformationDao.selectList((Wrapper)orderQueryWrapper);
        Map<String, List<WorkOrderInformation>> overMap = overList.stream().collect(Collectors.groupingBy(WorkOrderInformation::getRoadSegmentId));
        for (String key : overMap.keySet()) {
            HashMap overdueMap = new HashMap();
            Road road = (Road)((Object)this.roadManager.getById((Serializable)((Object)key)));
            if (overMap.get(key).size() <= 0) continue;
            NewWorkCountVo taskOver = new NewWorkCountVo();
            taskOver.setNumber(overMap.get(key).size());
            taskOver.setRoadName(road.getName());
            taskOver.setRoadId(key);
            overChildren.add(taskOver);
        }
        NewCountWorkOrderVo overVo = new NewCountWorkOrderVo();
        overVo.setName("\u5df2\u903e\u671f");
        overVo.setNumber(String.valueOf(overList.size()));
        overVo.setChildren(overChildren);
        returnList.add(overVo);
        return returnList;
    }

    @Override
    public CountWorkOrder countWorkOrder(QueryFilter<WorkStatistic> queryFilter) {
        QueryWrapper orderQueryWrapper = new QueryWrapper();
        Map params = queryFilter.getParams();
        if (ObjectUtils.isEmpty(params.get("accDateYear")) && ObjectUtils.isEmpty(params.get("accDateMonth"))) {
            String mouth = new SimpleDateFormat("yyyy-MM").format(new Date());
            params.put("accDateMonth", mouth);
        }
        if (ObjectUtils.isNotEmpty(params.get("roadSegmentId"))) {
            List<String> ids = Arrays.asList(params.get("roadSegmentId").toString().split(","));
            params.put("ids", ids);
            orderQueryWrapper.in((Object)"ROAD_SEGMENT_ID_", ids);
        }
        List<Map<String, Object>> mapList = ((WorkStatisticDao)this.baseMapper).countWorkOrder(params);
        long userTask1 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask1")).count();
        long userTask2 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask2")).count();
        long userTask3 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask3")).count();
        long userTask4 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask4")).count();
        long userTask5 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask5")).count();
        long userTask6 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask6")).count();
        long userTask7 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask7")).count();
        long endEvent1 = mapList.stream().filter(s -> s.get("taskKey").equals("EndEvent1")).count();
        orderQueryWrapper.eq((Object)"OVERDUE_", (Object)"1");
        orderQueryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        if (ObjectUtils.isNotEmpty(params.get("accDateMonth"))) {
            Object month = params.get("accDateMonth");
            orderQueryWrapper.apply("date_format(ISSUE_DATE_,'%Y-%m') = {0}", new Object[]{month});
        }
        List overList = this.workOrderInformationDao.selectList((Wrapper)orderQueryWrapper);
        long overdueWorkOrderCountUnFinish = overList.size();
        CountWorkOrder countWorkOrder = new CountWorkOrder();
        countWorkOrder.setBacklogWorkOrder(String.valueOf(userTask1 + userTask7));
        countWorkOrder.setConstructionWorkOrder(String.valueOf(userTask2 + userTask3));
        countWorkOrder.setDebitWorkOrder(String.valueOf(userTask4));
        countWorkOrder.setAuditWorkOrder(String.valueOf(userTask5 + userTask6));
        countWorkOrder.setFinishWorkOrder(String.valueOf(endEvent1));
        countWorkOrder.setOverdueWorkOrder(String.valueOf(overdueWorkOrderCountUnFinish));
        return countWorkOrder;
    }

    @Override
    public List<CountWorkOrder> countWorkOrders(QueryFilter<WorkStatistic> queryFilter) {
        ArrayList<CountWorkOrder> list = new ArrayList<CountWorkOrder>();
        Map params = queryFilter.getParams();
        Object roadSegmentId = params.get("roadSegmentId");
        if (ObjectUtils.isEmpty(params.get("accDateYear")) && ObjectUtils.isEmpty(params.get("accDateMonth"))) {
            String mouth = new SimpleDateFormat("yyyy-MM").format(new Date());
            params.put("accDateMonth", mouth);
        }
        if (ObjectUtils.isEmpty(roadSegmentId)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
            List roadList = this.roadDao.selectList((Wrapper)queryWrapper);
            for (Road road : roadList) {
                String id = road.getId();
                params.put("roadSegmentId", id);
                List<Map<String, Object>> mapList = ((WorkStatisticDao)this.baseMapper).countWorkOrder4Open(params);
                long userTask1 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask1")).count();
                long userTask2 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask2")).count();
                long userTask3 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask3")).count();
                long userTask4 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask4")).count();
                long userTask5 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask5")).count();
                long userTask6 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask6")).count();
                long userTask7 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask7")).count();
                long endEvent1 = mapList.stream().filter(s -> s.get("taskKey").equals("EndEvent1")).count();
                QueryWrapper orderQueryWrapper = new QueryWrapper();
                orderQueryWrapper.eq((Object)"OVERDUE_", (Object)"1");
                orderQueryWrapper.eq((Object)"IS_DELE_", (Object)"0");
                orderQueryWrapper.eq((Object)"ROAD_SEGMENT_ID_", (Object)id);
                if (ObjectUtils.isNotEmpty(params.get("accDateMonth"))) {
                    Object month = params.get("accDateMonth");
                    orderQueryWrapper.apply("date_format(ISSUE_DATE_,'%Y-%m') = {0}", new Object[]{month});
                }
                List overList = this.workOrderInformationDao.selectList((Wrapper)orderQueryWrapper);
                long overdueWorkOrderCountUnFinish = overList.size();
                CountWorkOrder countWorkOrder = new CountWorkOrder();
                countWorkOrder.setRoadSegmentId(id);
                countWorkOrder.setRoadSegmentName(road.getName());
                countWorkOrder.setBacklogWorkOrder(String.valueOf(userTask1 + userTask7));
                countWorkOrder.setConstructionWorkOrder(String.valueOf(userTask2 + userTask3));
                countWorkOrder.setDebitWorkOrder(String.valueOf(userTask4));
                countWorkOrder.setAuditWorkOrder(String.valueOf(userTask5 + userTask6));
                countWorkOrder.setFinishWorkOrder(String.valueOf(endEvent1));
                countWorkOrder.setOverdueWorkOrder(String.valueOf(overdueWorkOrderCountUnFinish));
                list.add(countWorkOrder);
            }
        } else {
            List<String> ids = Arrays.asList(params.get("roadSegmentId").toString().split(","));
            params.put("ids", ids);
            List<Map<String, Object>> mapList = ((WorkStatisticDao)this.baseMapper).countWorkOrder4Open(params);
            long userTask1 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask1")).count();
            long userTask2 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask2")).count();
            long userTask3 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask3")).count();
            long userTask4 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask4")).count();
            long userTask5 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask5")).count();
            long userTask6 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask6")).count();
            long userTask7 = mapList.stream().filter(s -> s.get("taskKey").equals("UserTask7")).count();
            long endEvent1 = mapList.stream().filter(s -> s.get("taskKey").equals("EndEvent1")).count();
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"OVERDUE_", (Object)"1");
            queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
            queryWrapper.in((Object)"ROAD_SEGMENT_ID_", ids);
            List overList = this.workOrderInformationDao.selectList((Wrapper)queryWrapper);
            long overdueWorkOrderCountUnFinish = overList.size();
            CountWorkOrder countWorkOrder = new CountWorkOrder();
            countWorkOrder.setRoadSegmentId(roadSegmentId.toString());
            countWorkOrder.setRoadSegmentName(((Road)((Object)this.roadDao.selectById((Serializable)((Object)roadSegmentId.toString())))).getName());
            countWorkOrder.setBacklogWorkOrder(String.valueOf(userTask1 + userTask7));
            countWorkOrder.setConstructionWorkOrder(String.valueOf(userTask2 + userTask3));
            countWorkOrder.setDebitWorkOrder(String.valueOf(userTask4));
            countWorkOrder.setAuditWorkOrder(String.valueOf(userTask5 + userTask6));
            countWorkOrder.setFinishWorkOrder(String.valueOf(endEvent1));
            countWorkOrder.setOverdueWorkOrder(String.valueOf(overdueWorkOrderCountUnFinish));
            list.add(countWorkOrder);
        }
        return list;
    }
}

