/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.basedata.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.model.Org;
import com.artfess.yhxt.basedata.dao.BizEmergeMaterialManagementDao;
import com.artfess.yhxt.basedata.manager.BizEmergeMaterialManagementManager;
import com.artfess.yhxt.basedata.manager.BizMaterialsManagementManager;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.model.BizEmergeMaterialManagement;
import com.artfess.yhxt.basedata.model.BizMaterialsManagement;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.basedata.vo.BizEmergeMaterialManagementVO;
import com.artfess.yhxt.contract.vo.BizEmergeMaterialManagementDetailExcel;
import com.artfess.yhxt.contract.vo.BizEmergeMaterialManagementGoodsVo;
import com.artfess.yhxt.statistics.vo.Org4emergeVO;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BizEmergeMaterialManagementManagerImpl
extends BaseManagerImpl<BizEmergeMaterialManagementDao, BizEmergeMaterialManagement>
implements BizEmergeMaterialManagementManager {
    @Resource
    BaseContext baseContext;
    @Resource
    PermissionUtils permissionUtils;
    @Resource
    BizMaterialsManagementManager bizMaterialsManagementManager;
    @Resource
    private OrgDao orgDao;
    @Resource
    private RoadManager roadManager;

    @Override
    public List<Org4emergeVO> getEmergeCount() {
        String orgId = StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId()) && !"0".equals(this.baseContext.getCurrentOrgId()) ? this.baseContext.getCurrentOrgId() : "1419863231459102720";
        List<Org4emergeVO> lists = new ArrayList<Org4emergeVO>();
        ArrayList<Org> rtnList = new ArrayList<Org>();
        QueryWrapper rgQueryWrapper = new QueryWrapper();
        rgQueryWrapper.eq((Object)"is_dele_", (Object)"0");
        List allList = this.orgDao.selectList((Wrapper)rgQueryWrapper);
        List<Org> list = BizEmergeMaterialManagementManagerImpl.getOrgChild(allList, orgId, rtnList);
        for (Org org : list) {
            Org4emergeVO fvo = new Org4emergeVO();
            BeanUtils.copyProperties((Object)org, (Object)fvo);
            lists.add(fvo);
        }
        lists = BizEmergeMaterialManagementManagerImpl.getChild(lists, orgId);
        return this.setCount(lists);
    }

    public List<Org4emergeVO> setCount(List<Org4emergeVO> list) {
        Iterator<Org4emergeVO> it = list.iterator();
        while (it.hasNext()) {
            Org4emergeVO orgVO = it.next();
            Integer grade = Integer.valueOf(orgVO.getGrade());
            List<String> roadList = new ArrayList<String>();
            if (grade < 4) {
                QueryWrapper roadQueryWrapper = new QueryWrapper();
                roadQueryWrapper.like((Object)"COMPANY_IDS_", (Object)orgVO.getId());
                roadList = this.roadManager.list((Wrapper)roadQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            } else if (grade == 4) {
                QueryWrapper roadByNameQueryWrapper = new QueryWrapper();
                roadByNameQueryWrapper.eq((Object)"NAME_", (Object)orgVO.getName());
                roadList = this.roadManager.list((Wrapper)roadByNameQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }
            if (roadList.size() > 0) {
                orgVO = this.newCount(roadList, orgVO);
            } else {
                it.remove();
            }
            if (orgVO.getChirldren().size() <= 0 || Integer.valueOf(orgVO.getGrade()) >= 4) continue;
            this.setCount(orgVO.getChirldren());
        }
        return list;
    }

    public Org4emergeVO newCount(List<String> ids, Org4emergeVO orgVO) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"ROAD_SEGMENT_ID_", ids);
        List list = this.list((Wrapper)wrapper);
        orgVO.setCountNum(list.size());
        if ("4".equals(orgVO.getGrade())) {
            orgVO.setRoadSegmentId(ids.get(0));
        }
        return orgVO;
    }

    public static List<Org> getOrgChild(List<Org> orgList, String parentId, List<Org> rtnList) {
        for (Org org : orgList) {
            if (!parentId.equals(org.getParentId())) continue;
            BizEmergeMaterialManagementManagerImpl.getOrgChild(orgList, org.getId(), rtnList);
            rtnList.add(org);
        }
        return rtnList;
    }

    public static List<Org4emergeVO> getChild(List<Org4emergeVO> allList, String pCode) {
        ArrayList<Org4emergeVO> returnList = new ArrayList<Org4emergeVO>();
        for (Org4emergeVO entity : allList) {
            if (!pCode.equals(entity.getParentId())) continue;
            entity.setChirldren(BizEmergeMaterialManagementManagerImpl.getChild(allList, entity.getId()));
            returnList.add(entity);
        }
        return returnList;
    }

    @Override
    public PageList<BizEmergeMaterialManagementVO> queryEmergeMaterialManagement(QueryFilter<BizEmergeMaterialManagement> queryFilter) {
        if (StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId())) {
            this.permissionUtils.addPermission(queryFilter);
        }
        PageList list = this.query(queryFilter);
        ArrayList<BizEmergeMaterialManagementVO> rerurnList = new ArrayList<BizEmergeMaterialManagementVO>();
        for (BizEmergeMaterialManagement model : list.getRows()) {
            BizEmergeMaterialManagementVO vo = new BizEmergeMaterialManagementVO();
            BeanUtils.copyProperties((Object)((Object)model), (Object)vo);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"STRUCTURAL_ID_", (Object)vo.getId());
            vo.setMaterialsManagements(this.bizMaterialsManagementManager.list((Wrapper)queryWrapper));
            rerurnList.add(vo);
        }
        PageList pageList = new PageList();
        pageList.setPage(list.getPage());
        pageList.setPageSize(list.getPageSize());
        pageList.setTotal(list.getTotal());
        pageList.setRows(rerurnList);
        return pageList;
    }

    @Override
    public void saveOrUpdateManagementGoodsVo(BizEmergeMaterialManagementGoodsVo vo) {
        BizEmergeMaterialManagement bizEmergeMaterialManagement = vo.getBizEmergeMaterialManagement();
        this.saveOrUpdate((Object)bizEmergeMaterialManagement);
        List<BizMaterialsManagement> detailList = vo.getDetailList();
        this.bizMaterialsManagementManager.deleteAllByManId(bizEmergeMaterialManagement.getId());
        detailList.forEach(s -> {
            s.setStructuralId(bizEmergeMaterialManagement.getId());
            this.bizMaterialsManagementManager.save(s);
        });
    }

    @Override
    public CommonResult<String> importData(String manId, MultipartFile file) {
        try {
            ArrayList<BizMaterialsManagement> detailList = new ArrayList<BizMaterialsManagement>();
            List detailExcels = ExcelUtil.readExcel(BizEmergeMaterialManagementDetailExcel.class, (MultipartFile)file);
            if (null != detailExcels && detailExcels.size() > 0) {
                for (BizEmergeMaterialManagementDetailExcel detailExcel : detailExcels) {
                    if (null == detailExcel.getMaterialTypeValue()) continue;
                    BizMaterialsManagement detail = new BizMaterialsManagement();
                    BeanUtils.copyProperties((Object)detailExcel, (Object)((Object)detail));
                    detail.setStructuralId(manId);
                    detailList.add(detail);
                }
            }
            this.bizMaterialsManagementManager.saveBatch(detailList);
            return new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u5165\u5931\u8d25");
        }
    }
}

