/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.statistics.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.model.CommonResult;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.statistics.manager.StatisticalStatementManager;
import com.artfess.yhxt.statistics.vo.CountStructureVo;
import com.artfess.yhxt.statistics.vo.MaintainMessageVo;
import com.artfess.yhxt.statistics.vo.MqiDataVo;
import com.artfess.yhxt.statistics.vo.OrgMessageVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/statisticalStatement/v1/"})
@Api(tags={"\u7edf\u8ba1\u62a5\u8868"})
@ApiGroup(group={"group_biz"})
public class StatisticalStatementController {
    @Resource
    StatisticalStatementManager statisticalStatementManager;
    @Resource
    RoadManager roadManager;

    @RequestMapping(value={"findAllRoadIds"}, method={RequestMethod.GET})
    @ApiOperation(value="\u67e5\u8be2\u6240\u5c5e\u8def\u6bb5", httpMethod="GET")
    public CommonResult<List<String>> findAllRoadIds(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.like((Object)"COMPANY_IDS_", (Object)id);
        queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        List list = this.roadManager.list((Wrapper)queryWrapper).stream().map(Road::getId).collect(Collectors.toList());
        return new CommonResult(true, "\u6210\u529f", list);
    }

    @RequestMapping(value={"countDisease"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9053\u8def\u75c5\u5bb3\u7edf\u8ba1", httpMethod="POST")
    public Map<String, Object> countDisease(@ApiParam(name="map", value="roadSegmentId:\u8def\u6bb5id,companyId:\u516c\u53f8id startTime:\u5f00\u59cb\u65f6\u95f4 endTime:\u7ed3\u675f\u65f6\u95f4") @RequestBody Map<String, Object> map) {
        return this.statisticalStatementManager.countDisease(map);
    }

    @RequestMapping(value={"countMaintenance"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u65e5\u5e38\u517b\u62a4\u7edf\u8ba1-\u5e9f\u5f03", httpMethod="POST")
    public Map<String, Object> countMaintenance(@ApiParam(name="map", value="roadSegmentId:\u8def\u6bb5id,companyId:\u516c\u53f8id , pcode: \u7c7b\u522bCode,subjectCode:\u7ec6\u76eeCode") @RequestBody Map<String, Object> map) {
        return this.statisticalStatementManager.countMaintenance(map);
    }

    @RequestMapping(value={"countMaintenance/new"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u65e5\u5e38\u517b\u62a4\u7edf\u8ba1", httpMethod="POST")
    public Map<String, Object> countMaintenanceNew(@ApiParam(name="map", value="roadSegmentId:\u8def\u6bb5id\uff08\u6bcf\u6b21\u5fc5\u4f20\u4e00\u6761\u8def\u6bb5id\uff09,companyId:\u516c\u53f8id , pcode: \u7c7b\u522bCode") @RequestBody Map<String, Object> map) {
        return this.statisticalStatementManager.countMaintenanceNew(map);
    }

    @RequestMapping(value={"countSiteDaily"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u65e5\u5de1\u68c0", httpMethod="POST")
    public Map<String, Object> countSiteDaily(@ApiParam(name="map", value="roadSegmentId:\u8def\u6bb5id, startTime:\u5f00\u59cb\u65f6\u95f4 endTime:\u7ed3\u675f\u65f6\u95f4") @RequestBody Map<String, Object> map) {
        return this.statisticalStatementManager.countSiteDaily(map);
    }

    @RequestMapping(value={"countSiteNight"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u591c\u5de1\u68c0", httpMethod="POST")
    public Map<String, Object> countSiteNight(@ApiParam(name="map", value="roadSegmentId:\u8def\u6bb5id, startTime:\u5f00\u59cb\u65f6\u95f4 endTime:\u7ed3\u675f\u65f6\u95f4") @RequestBody Map<String, Object> map) {
        return this.statisticalStatementManager.countSiteNight(map);
    }

    @RequestMapping(value={"countBridgeCheck"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6865\u6881\u7ecf\u5e38\u68c0\u67e5", httpMethod="POST")
    public Map<String, Object> countBridgeCheck(@ApiParam(name="map", value="roadSegmentId:\u8def\u6bb5id, accDateYear:\u5e74 accDateMonth:\u6708  \u9ed8\u8ba4\u4f20\u5f53\u524d\u5e74\u5f53\u524d\u6708") @RequestBody Map<String, Object> map) {
        return this.statisticalStatementManager.countBridgeCheck(map);
    }

    @RequestMapping(value={"countTunnelCheck"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u96a7\u9053\u7ecf\u5e38\u68c0\u67e5", httpMethod="POST")
    public Map<String, Object> countTunnelCheck(@ApiParam(name="map", value="roadSegmentId:\u8def\u6bb5id, accDateYear:\u5e74 accDateMonth:\u6708  \u9ed8\u8ba4\u4f20\u5f53\u524d\u5e74\u5f53\u524d\u6708") @RequestBody Map<String, Object> map) {
        return this.statisticalStatementManager.countTunnelCheck(map);
    }

    @RequestMapping(value={"countSideSlopCheck"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8fb9\u5761\u7ecf\u5e38\u68c0\u67e5", httpMethod="POST")
    public Map<String, Object> countSideSlopCheck(@ApiParam(name="map", value="roadSegmentId:\u8def\u6bb5id, accDateYear:\u5e74 accDateMonth:\u6708  \u9ed8\u8ba4\u4f20\u5f53\u524d\u5e74\u5f53\u524d\u6708") @RequestBody Map<String, Object> map) {
        return this.statisticalStatementManager.countSideSlopCheck(map);
    }

    @RequestMapping(value={"countCulvertCheck"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6db5\u6d1e\u7ecf\u5e38\u68c0\u67e5", httpMethod="POST")
    public Map<String, Object> countCulvertCheck(@ApiParam(name="map", value="roadSegmentId:\u8def\u6bb5id, accDateYear:\u5e74 startTime:\u5f00\u59cb\u6708  endTime\uff1a\u7ed3\u675f\u6708") @RequestBody Map<String, Object> map) {
        return this.statisticalStatementManager.countCulvertCheck(map);
    }

    @RequestMapping(value={"countReportBridge"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6865\u6881\u7ed3\u6784\u7edf\u8ba1", httpMethod="POST")
    public Map<String, Object> countReportBridge(@ApiParam(name="map", value="roadSegmentId:\u8def\u6bb5id") @RequestBody Map<String, Object> map) {
        return this.statisticalStatementManager.countReportBridge(map);
    }

    @RequestMapping(value={"exportBridge"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6865\u6881\u7ed3\u6784-\u5bfc\u51fa", httpMethod="POST")
    public void exportBridge(HttpServletResponse response, @ApiParam(name="map", value="roadSegmentId:\u8def\u6bb5id") @RequestBody Map<String, Object> map) {
        try {
            HSSFWorkbook workbook = this.statisticalStatementManager.exportBridge(response, map);
            ExcelUtil.downloadExcel((HSSFWorkbook)workbook, (String)"\u6865\u6881\u7ed3\u6784", (HttpServletResponse)response);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"countMqiReport"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="MQI\u7edf\u8ba1", httpMethod="POST")
    public CommonResult<List<MqiDataVo>> mqiReport(@ApiParam(name="map", value="roadSegmentId:\u8def\u6bb5id year:\u5e74\u4efd") @RequestBody Map<String, Object> map) {
        List<MqiDataVo> vos = this.statisticalStatementManager.countMqiReport(map);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", vos);
    }

    @RequestMapping(value={"countStructure"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7ed3\u6784\u7269\u68c0\u67e5\u60c5\u51b5", httpMethod="POST")
    public CommonResult<List<CountStructureVo>> countStructure(@ApiParam(name="map", value="roadSegmentId:\u8def\u6bb5id") @RequestBody Map<String, Object> map) {
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", this.statisticalStatementManager.countStructure(map));
    }

    @RequestMapping(value={"maintainMessage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7ba1\u517b\u4fe1\u606f\u7edf\u8ba1", httpMethod="POST")
    public CommonResult<List<MaintainMessageVo>> maintainMessage(@ApiParam(name="map", value="roadSegmentId:\u8def\u6bb5id") @RequestBody Map<String, Object> map) {
        List<MaintainMessageVo> maintainMessageVos = this.statisticalStatementManager.maintainMessage(map);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", maintainMessageVos);
    }

    @RequestMapping(value={"getMessageCountVo"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7ba1\u517b\u4fe1\u606f\u7edf\u8ba1\u6570\u91cf", httpMethod="POST", notes="\u83b7\u53d6\u7ba1\u517b\u4fe1\u606f\u7edf\u8ba1\u6570\u91cf")
    public List<OrgMessageVo> getMessageCountVo() throws Exception {
        return this.statisticalStatementManager.getMessageCountVo();
    }
}

