package com.artfess.yhxt.task.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.task.model.TaskAlreadyHandleHistory;
import com.artfess.base.manager.BaseManager;
import com.artfess.yhxt.task.model.TaskWaitHandle;
import com.artfess.yhxt.task.vo.TaskAlreadyHandleHistoryVo;

/**
 * 主要是从待办处理完毕之后，向“已办”表中插入相关数据 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2021-09-16
 */
public interface TaskAlreadyHandleHistoryManager extends BaseManager<TaskAlreadyHandleHistory> {

    /**
     * 分页查询已办管理
     * @param queryFilter
     * @return
     */
    PageList<TaskAlreadyHandleHistoryVo> queryTaskWaitHandleHistory(QueryFilter<TaskAlreadyHandleHistory> queryFilter);

    /**
     * 流程日志查询
     * @param queryFilter
     * @return
     */
    PageList<TaskAlreadyHandleHistory> queryTaskWaitHandleLog(QueryFilter<TaskAlreadyHandleHistory> queryFilter);
}
