package com.artfess.yhxt.specialproject.model;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 计量支付-计量支付明细表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xmz
 * @since 2022-06-29
 */
@ApiModel(value="MeasurementPaymentDetails对象", description="计量支付-计量支付明细表")
@TableName("biz_measurement_payment_details")
public class MeasurementPaymentDetails extends BaseModel<MeasurementPaymentDetails> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "计量支付id")
    @TableField("MEASUREMENT_PAYMENT_ID_")
    private String measurementPaymentId;

    @ApiModelProperty(value = "清单名称")
    @TableField("SUBJECT_NAME_")
    private String subjectName;

    @ApiModelProperty(value = "施工/收方日期")
    @TableField("COMMENCEMENT_DATE_")
    private LocalDate commencementDate;

    @ApiModelProperty(value = "工程部位及桩号")
    @TableField("CONSTRUCTION_SITE_")
    private String constructionSite;

    @ApiModelProperty(value = "收方示意图/计算式")
    @TableField("CALCULA_METHOD_")
    private String calculaMethod;

    @ApiModelProperty(value = "单位")
    @TableField("SUBJECT_UNIT_")
    private String subjectUnit;

    @ApiModelProperty(value = "数量")
    @TableField("SUBJECT_AMOUNT_")
    private BigDecimal subjectAmount;

    @ApiModelProperty(value = "单价（元）")
    @TableField("SUBJECT_PRICE_")
    private BigDecimal subjectPrice;

    @ApiModelProperty(value = "金额（元）")
    @TableField("SUBJECT_MONEY_")
    private BigDecimal subjectMoney;

    @ApiModelProperty(value = "完成已计量数量")
    @TableField("COMPLETE_AMOUNT_")
    private BigDecimal completeAmount;

    @ApiModelProperty(value = "完成已计量金额（元）")
    @TableField("PAID_MONEY_")
    private BigDecimal paidMoney;

    @ApiModelProperty(value = "备注")
    @TableField("REMARK_")
    private String remark;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getMeasurementPaymentId() {
        return measurementPaymentId;
    }

    public void setMeasurementPaymentId(String measurementPaymentId) {
        this.measurementPaymentId = measurementPaymentId;
    }
    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }
    public LocalDate getCommencementDate() {
        return commencementDate;
    }

    public void setCommencementDate(LocalDate commencementDate) {
        this.commencementDate = commencementDate;
    }
    public String getConstructionSite() {
        return constructionSite;
    }

    public void setConstructionSite(String constructionSite) {
        this.constructionSite = constructionSite;
    }
    public String getCalculaMethod() {
        return calculaMethod;
    }

    public void setCalculaMethod(String calculaMethod) {
        this.calculaMethod = calculaMethod;
    }
    public String getSubjectUnit() {
        return subjectUnit;
    }

    public void setSubjectUnit(String subjectUnit) {
        this.subjectUnit = subjectUnit;
    }
    public BigDecimal getSubjectAmount() {
        return subjectAmount;
    }

    public void setSubjectAmount(BigDecimal subjectAmount) {
        this.subjectAmount = subjectAmount;
    }
    public BigDecimal getSubjectPrice() {
        return subjectPrice;
    }

    public void setSubjectPrice(BigDecimal subjectPrice) {
        this.subjectPrice = subjectPrice;
    }
    public BigDecimal getSubjectMoney() {
        return subjectMoney;
    }

    public void setSubjectMoney(BigDecimal subjectMoney) {
        this.subjectMoney = subjectMoney;
    }
    public BigDecimal getCompleteAmount() {
        return completeAmount;
    }

    public void setCompleteAmount(BigDecimal completeAmount) {
        this.completeAmount = completeAmount;
    }
    public BigDecimal getPaidMoney() {
        return paidMoney;
    }

    public void setPaidMoney(BigDecimal paidMoney) {
        this.paidMoney = paidMoney;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "MeasurementPaymentDetails{" +
            "id=" + id +
            ", measurementPaymentId=" + measurementPaymentId +
            ", subjectName=" + subjectName +
            ", commencementDate=" + commencementDate +
            ", constructionSite=" + constructionSite +
            ", calculaMethod=" + calculaMethod +
            ", subjectUnit=" + subjectUnit +
            ", subjectAmount=" + subjectAmount +
            ", subjectPrice=" + subjectPrice +
            ", subjectMoney=" + subjectMoney +
            ", completeAmount=" + completeAmount +
            ", paidMoney=" + paidMoney +
            ", remark=" + remark +
            ", tenantId=" + tenantId +
        "}";
    }
}
