package com.artfess.yhxt.specialproject.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.specialproject.manager.BizEngineeringAccessoriesManager;
import com.artfess.yhxt.specialproject.model.BizConstructionLog;
import com.artfess.yhxt.specialproject.dao.BizConstructionLogDao;
import com.artfess.yhxt.specialproject.manager.BizConstructionLogManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.yhxt.specialproject.model.BizConstructionLog;
import com.artfess.yhxt.specialproject.model.BizConstructionLog;
import com.artfess.yhxt.specialproject.model.BizEngineeringAccessories;
import com.artfess.yhxt.specialproject.vo.BizConstructionLogVo;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * 施工日志表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-11
 */
@Service
public class BizConstructionLogManagerImpl extends BaseManagerImpl<BizConstructionLogDao, BizConstructionLog> implements BizConstructionLogManager {

    @Resource
    private BizEngineeringAccessoriesManager bizEngineeringAccessoriesManager;

    @Override
    public PageList<BizConstructionLog> queryBizConstructionLog(QueryFilter<BizConstructionLog> queryFilter) {
        IPage<BizConstructionLog> result = baseMapper.queryBizConstructionLog(convert2IPage(queryFilter.getPageBean()),convert2Wrapper(queryFilter,currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public BizConstructionLog getBizConstructionLogById(String id) {
        BizConstructionLog bizConstructionLog = baseMapper.selectById(id);
        return bizConstructionLog;
    }

    @Override
    public BizConstructionLogVo getVo(String id) {
        BizConstructionLogVo bizConstructionLogVo= new BizConstructionLogVo();
        BizConstructionLog bizConstructionLog = this.getById(id);
        List<BizEngineeringAccessories> engineeringAccessories = this.bizEngineeringAccessoriesManager.getEngineeringAccessoriesBySourceId(id);
        bizConstructionLogVo.setBizConstructionLog(bizConstructionLog);
        bizConstructionLogVo.setBizEngineeringAccessoriesList(engineeringAccessories);
        return bizConstructionLogVo;
    }

    @Override
    public void saveVo(BizConstructionLogVo bizConstructionLogVo) {
        //施工日志
        BizConstructionLog bizConstructionLog = bizConstructionLogVo.getBizConstructionLog();
        this.create(bizConstructionLog);
        //附件
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = bizConstructionLogVo.getBizEngineeringAccessoriesList();
        String sourceId = bizConstructionLog.getId();
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.bizEngineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);
    }

    @Override
    public void updateVo(BizConstructionLogVo bizConstructionLogVo) {
        //监理巡查记录
        BizConstructionLog bizConstructionLog = bizConstructionLogVo.getBizConstructionLog();
        this.update(bizConstructionLog);
        String sourceId = bizConstructionLog.getId();
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = bizConstructionLogVo.getBizEngineeringAccessoriesList();
        bizEngineeringAccessoriesManager.removeEngineeringAccessories(sourceId);
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.bizEngineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);
    }
}
