package com.artfess.yhxt.specialproject.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.specialproject.manager.BizProjectManageQualityManager;
import com.artfess.yhxt.specialproject.model.BizEngineeringAccessories;
import com.artfess.yhxt.specialproject.model.BizProjectManageQualityChange;
import com.artfess.yhxt.specialproject.vo.BizProjectManageQualityChangeVo;
import com.artfess.yhxt.specialproject.vo.ProjectManageQualityChangeVo;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.hasor.utils.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.specialproject.manager.BizProjectManageQualityChangeManager;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

/**
 * 工程质量管理质检单整改表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-16
 */
@RestController
@RequestMapping("/bizProjectManageQualityChange/v1/")
@Api(tags = "工程质量管理质检单整改")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizProjectManageQualityChangeController extends BaseController<BizProjectManageQualityChangeManager, BizProjectManageQualityChange> {

    @Resource
    BizProjectManageQualityManager bizProjectManageQualityManager;
    @Resource
    private BaseContext baseContext;

    @RequestMapping(value = "/savebizProjectManageQualityChange",method = RequestMethod.POST,produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改工程质量管理质检单整改信息",httpMethod = "POST")
    public CommonResult<String> saveEngineeringProject(@ApiParam(name = "bizProjectManageQualityChange",value = "工程质量管理质检单整改专项检查对象") @RequestBody BizProjectManageQualityChange bizProjectManageQualityChange) throws Exception {
        String msg = "添加成功";
        int ConfirmResult = bizProjectManageQualityChange.getConfirmResult();
        if (StringUtils.isEmpty(bizProjectManageQualityChange.getId())){
            bizProjectManageQualityChange.setReformFlag(0);
            bizProjectManageQualityChange.setConfirmResult(0);
            bizProjectManageQualityChange.setIsDele("0");
            baseService.create(bizProjectManageQualityChange);
        }else {
            baseService.update(bizProjectManageQualityChange);
            if (bizProjectManageQualityChange.getReformFlag()==1){
            bizProjectManageQualityManager.updateReformFlag(bizProjectManageQualityChange.getTestId());
            }
            if (ConfirmResult == 1 || ConfirmResult == 2){
                bizProjectManageQualityManager.updateConfirmResult(bizProjectManageQualityChange.getTestId());
            }else{
                bizProjectManageQualityManager.updateConfirmResults(bizProjectManageQualityChange.getTestId());
            }
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }

    @RequestMapping(value = "/saveVo",method = RequestMethod.POST,produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改工程质量管理质检单整改信息",httpMethod = "POST")
    public CommonResult<String> saveVo(@ApiParam(name = "projectManageQualityChangeVo",value = "工程质量管理质检单整改专项检查对象 vo") @RequestBody ProjectManageQualityChangeVo projectManageQualityChangeVo) throws Exception {
        String msg = "添加成功";
        BizProjectManageQualityChange bizProjectManageQualityChange = projectManageQualityChangeVo.getBizProjectManageQualityChange();
        int ConfirmResult = bizProjectManageQualityChange.getConfirmResult();
        if (StringUtils.isEmpty(bizProjectManageQualityChange.getId())){
            baseService.saveVo(projectManageQualityChangeVo);
        }else {
            baseService.updateVo(projectManageQualityChangeVo);
            if (bizProjectManageQualityChange.getReformFlag()==1){
            bizProjectManageQualityManager.updateReformFlag(bizProjectManageQualityChange.getTestId());
            }
            if (ConfirmResult == 1 || ConfirmResult == 2){
                bizProjectManageQualityManager.updateConfirmResult(bizProjectManageQualityChange.getTestId());
            }else{
                bizProjectManageQualityManager.updateConfirmResults(bizProjectManageQualityChange.getTestId());
            }
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }

    @GetMapping(value = "getVo/{id}")
    @ApiOperation(value = "根据ID查询工程质量管理质检单整改信息",httpMethod = "GET",notes = "根据ID查询工程质量管理质检单整改信息")
    public ProjectManageQualityChangeVo getVo(@ApiParam(name = "id",value = "业务对象主键",required = true)@PathVariable String id) throws Exception{
        return baseService.getVo(id);
    }


    @RequestMapping(value = "getJson",method = RequestMethod.POST,produces = {"application/json;charset=utf-8" })
    @ApiOperation(value = "分页查询工程质量管理质检单整改信息",httpMethod ="POST")
    public PageList<BizProjectManageQualityChange> getJson(@ApiParam(name = "queryFilter",value = "分页查询信息")@RequestBody QueryFilter<BizProjectManageQualityChange> queryFilter){
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){

        }
        PageList<BizProjectManageQualityChange> pageList = baseService.queryBizProjectManageQualityChange(queryFilter);
        return pageList;
    }

    @GetMapping(value = "get/{id}")
    @ApiOperation(value = "根据ID查询工程质量管理质检单整改信息",httpMethod = "GET",notes = "根据ID查询工程质量管理质检单整改信息")
    public BizProjectManageQualityChange get(@ApiParam(name = "id",value = "业务对象主键",required = true)@PathVariable String id) throws Exception{
        return baseService.getBizProjectManageQualityChangeById(id);
    }

    @RequestMapping(value="/getJsonVo",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询工程质量及整改信息",httpMethod = "POST")
    public PageList<BizProjectManageQualityChangeVo> getJsonVo(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BizProjectManageQualityChange> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){

        }
        PageList<BizProjectManageQualityChangeVo> pageList = baseService.queryProjectManageQuality(queryFilter);
        return  pageList;
    }

    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除工程质量管理质检单整改信息",httpMethod = "DELETE",notes = "批量删除工程质量管理质检单整改信息")
    public CommonResult<String> removes(@ApiParam(name = "ids",value = "对各主键用逗号分隔",required = true) @RequestParam String... ids) throws Exception{
        baseService.removeByIds(Arrays.asList(ids));
        return new CommonResult<String>(true,"删除成功");
    }

    @RequestMapping(value = "/updateManageQualityChange",method = RequestMethod.DELETE,produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "逻辑删除工程质量管理质检单整改信息",httpMethod = "DELETE",notes = "逻辑删除工程质量管理质检单整改信息")
    public CommonResult<String> updateManageQualityChange(@ApiParam(name = "ids",value = "ID集合以，隔开",required = true)
                                              @RequestParam(value = "ids",required = true)String ids)throws Exception{
        if (StringUtils.isNotBlank(ids)){
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<BizProjectManageQualityChange> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_",idsList);
            updateWrapper.set("is_dele_","1");
            baseService.update(null,updateWrapper);
        }
        return new CommonResult<>(true,"删除成功");
    }
}
