package com.artfess.yhxt.specialcheck.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 巡检任务-任务配置表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-26
 */
@ApiModel(value="InspectionTaskConfig对象", description="巡检任务-任务配置表")
@TableName("biz_inspection_task_config")
public class InspectionTaskConfig extends BizModel<InspectionTaskConfig> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "巡检类型，使用数据字典，1：日巡检，2：夜巡检")
    @TableField("TYPE_")
    private Integer type;

    @ApiModelProperty(value = "任务类型，1：按月，2：按天")
    @TableField("TASK_TYPE")
    private Integer taskType;

    @ApiModelProperty(value = "任务频率，")
    @TableField("FREQUENCY_")
    private Integer frequency;

    @ApiModelProperty(value = "所属管理中心ID")
    @TableField("MANAGE_UNIT_ID_")
    private String manageUnitId;

    @ApiModelProperty(value = "所属管理中心NAME")
    @TableField("MANAGE_UNIT_NAME_")
    private String manageUnitName;

    @ApiModelProperty(value = "所属路段(关联路段表ID)")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "所属路段NAME")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;

    @ApiModelProperty(value = "路线ID，选择路段时带入")
    @TableField("ROUTE_ID_")
    private String routeId;

    @ApiModelProperty(value = "路线名称，选择路段时带入")
    @TableField("ROUTE_NAME_")
    private String routeName;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "所属公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "开始日期")
    @TableField("PATROL_DATE_")
    private LocalDate patrolDate;

    @ApiModelProperty(value = "开始时间")
    @TableField("START_TIME_")
    private String startTime;

    @ApiModelProperty(value = "结束时间")
    @TableField("END_TIME_")
    private String endTime;

    @ApiModelProperty(value = "天气")
    @TableField("WEATHER_")
    private String weather;

    @ApiModelProperty(value = "巡检人ID")
    @TableField("RUMMAGER_ID_")
    private String rummagerId;

    @ApiModelProperty(value = "巡检人登录账户，用于为用户发送消息")
    @TableField("RUMMAGER_ACCOUNT_")
    private String rummagerAccount;

    @ApiModelProperty(value = "记录人ID")
    @TableField("RECORDER_ID_")
    private String recorderId;

    @ApiModelProperty(value = "记录人登录账户")
    @TableField("RECORDER_ACCOUNT_")
    private String recorderAccount;

    @ApiModelProperty(value = "巡查情况及存在问题")
    @TableField("PROBLEM_")
    private String problem;

    @ApiModelProperty(value = "巡检内容")
    @TableField("CONTENT_")
    private String content;

    @TableField("STATUS_")
    @ApiModelProperty(value="状态：启用（0）、禁用（1）")
    protected String status;


    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
    public Integer getTaskType() {
        return taskType;
    }

    public void setTaskType(Integer taskType) {
        this.taskType = taskType;
    }
    public Integer getFrequency() {
        return frequency;
    }

    public void setFrequency(Integer frequency) {
        this.frequency = frequency;
    }
    public String getManageUnitId() {
        return manageUnitId;
    }

    public void setManageUnitId(String manageUnitId) {
        this.manageUnitId = manageUnitId;
    }
    public String getManageUnitName() {
        return manageUnitName;
    }

    public void setManageUnitName(String manageUnitName) {
        this.manageUnitName = manageUnitName;
    }
    public String getRoadSegmentId() {
        return roadSegmentId;
    }

    public void setRoadSegmentId(String roadSegmentId) {
        this.roadSegmentId = roadSegmentId;
    }
    public String getRoadSegmentName() {
        return roadSegmentName;
    }

    public void setRoadSegmentName(String roadSegmentName) {
        this.roadSegmentName = roadSegmentName;
    }
    public String getRouteId() {
        return routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }
    public String getRouteName() {
        return routeName;
    }

    public void setRouteName(String routeName) {
        this.routeName = routeName;
    }
    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }
    public LocalDate getPatrolDate() {
        return patrolDate;
    }

    public void setPatrolDate(LocalDate patrolDate) {
        this.patrolDate = patrolDate;
    }
    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }
    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }
    public String getWeather() {
        return weather;
    }

    public void setWeather(String weather) {
        this.weather = weather;
    }
    public String getRummagerId() {
        return rummagerId;
    }

    public void setRummagerId(String rummagerId) {
        this.rummagerId = rummagerId;
    }
    public String getRummagerAccount() {
        return rummagerAccount;
    }

    public void setRummagerAccount(String rummagerAccount) {
        this.rummagerAccount = rummagerAccount;
    }
    public String getRecorderId() {
        return recorderId;
    }

    public void setRecorderId(String recorderId) {
        this.recorderId = recorderId;
    }
    public String getRecorderAccount() {
        return recorderAccount;
    }

    public void setRecorderAccount(String recorderAccount) {
        this.recorderAccount = recorderAccount;
    }
    public String getProblem() {
        return problem;
    }

    public void setProblem(String problem) {
        this.problem = problem;
    }
    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }




    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "InspectionTaskConfig{" +
            "id=" + id +
            ", type=" + type +
            ", taskType=" + taskType +
            ", frequency=" + frequency +
            ", manageUnitId=" + manageUnitId +
            ", manageUnitName=" + manageUnitName +
            ", roadSegmentId=" + roadSegmentId +
            ", roadSegmentName=" + roadSegmentName +
            ", routeId=" + routeId +
            ", routeName=" + routeName +
            ", companyId=" + companyId +
            ", companyName=" + companyName +
            ", patrolDate=" + patrolDate +
            ", startTime=" + startTime +
            ", endTime=" + endTime +
            ", weather=" + weather +
            ", rummagerId=" + rummagerId +
            ", rummagerAccount=" + rummagerAccount +
            ", recorderId=" + recorderId +
            ", recorderAccount=" + recorderAccount +
            ", problem=" + problem +
            ", content=" + content +
        "}";
    }
}
