package com.artfess.yhxt.specialcheck.dao;

        import com.artfess.yhxt.specialcheck.model.SiteInspection;
        import com.artfess.yhxt.specialcheck.vo.*;
        import com.baomidou.mybatisplus.core.conditions.Wrapper;
        import com.baomidou.mybatisplus.core.mapper.BaseMapper;
        import com.baomidou.mybatisplus.core.metadata.IPage;
        import com.baomidou.mybatisplus.core.toolkit.Constants;
        import org.apache.ibatis.annotations.Param;
        import org.apache.ibatis.annotations.Select;

        import java.util.HashMap;
        import java.util.List;
        import java.util.Map;

/**
 * 巡检表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-12
 */
public interface SiteInspectionDao extends BaseMapper<SiteInspection> {

    IPage<SiteInspectionVo> querySiteInspection(IPage<SiteInspection> convert2IPage,
                                                @Param("map") Map<String, Object> params,
                                                @Param(Constants.WRAPPER) Wrapper<SiteInspection> convert2Wrapper);

    /**
     * 根据id查询巡检信息
     * @param id 巡检id
     * @return
     */
    SiteDiseaseVo getSiteInspectionById(String id);

    IPage<DefaultBpmCheckOpinionVo> getSiteInspectionStatus(IPage<SiteInspection> convert2IPage,

                                                          @Param(Constants.WRAPPER) Wrapper<SiteInspection> convert2Wrapper);


    IPage<SiteInspectionTaskVo> getSiteInspectionTask(IPage<SiteInspection> convert2IPage,@Param(Constants.WRAPPER) Wrapper<SiteInspection> convert2Wrapper);

    @Select("SELECT DISTINCT BIZ_ID FROM biz_task_already_handle_history WHERE RECEIVE_USER_ID =#{userId} OR SEND_USER_ID=#{userId}")
    List<String> selectBizId(String userId);

    IPage<SiteInspectionVo> queryTaskHistory(IPage<SiteInspection> convert2IPage,
                                             @Param("map") Map<String, Object> params,
                                             @Param(Constants.WRAPPER) Wrapper<SiteInspection> convert2Wrapper);

    IPage<SiteInspectionVo> querySiteInspectionList(IPage<SiteInspection> convert2IPage,
                                                    @Param("map") Map<String, Object> params,
                                                    @Param(Constants.WRAPPER) Wrapper<SiteInspection> convert2Wrapper);
}
