package com.artfess.yhxt.specialcheck.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.specialcheck.model.BizMqiCheckData;
import com.artfess.yhxt.specialcheck.vo.BizMqiCheckDataVo;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.yhxt.specialcheck.manager.BizMqiCheckDataManager;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

/**
 * MQI检查数据表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-10
 */
@RestController
@RequestMapping("/bizMqiCheckData/v1/")
@Api(tags = "MQI数据检查接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizMqiCheckDataController extends BaseController<BizMqiCheckDataManager, BizMqiCheckData> {
    @Resource
    PermissionUtils permissionUtils;

//    @RequestMapping(value = "/saveMqi", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
//    @ApiOperation(value = "保存,修改MQI数据检查信息", httpMethod = "POST")
//    public CommonResult<BizMqiCheckData> saveTunnel(@ApiParam(name = "bizMqiCheckData", value = "MQI数据检查对象") @RequestBody BizMqiCheckData bizMqiCheckData) throws Exception {
//        String msg = "添加成功";
//        if (StringUtils.isEmpty(bizMqiCheckData.getId())) {
//            bizMqiCheckData.setIsDele("0");
//            baseService.create(bizMqiCheckData);
//        } else {
//            baseService.update(bizMqiCheckData);
//            msg = "修改成功";
//        }
//        return new CommonResult<BizMqiCheckData>(true,msg,bizMqiCheckData);
//    }

    @Resource
    private BaseContext baseContext;

    @RequestMapping(value = "/save", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存MQI数据检查信息", httpMethod = "POST", notes = "保存MQI数据检查信息")
    public CommonResult<String> save(@ApiParam(name = "vo", value = "MQI数据检查对象") @RequestBody BizMqiCheckDataVo vo) throws Exception {
        this.baseService.saveBizMqiCheckDataVo(vo);
        return new CommonResult<>(true, "保存成功");
    }

    @RequestMapping(value = "/saveVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存MQI数据检查、附件信息", httpMethod = "POST", notes = "保存MQI数据检查、附件信息")
    public CommonResult<String> saveVo(@ApiParam(name = "vo", value = "MQI数据检查对象") @RequestBody BizMqiCheckDataVo vo) throws Exception {
        try {
            this.baseService.saveVo(vo);
            return new CommonResult<>(true, "保存成功");
        } catch (Exception e) {
            e.printStackTrace();
            return new CommonResult<>(false, "保存失败");
        }
    }


    @RequestMapping(value="/getJson",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询MQI数据检查信息",httpMethod = "POST")
    public PageList<BizMqiCheckData> getJson(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BizMqiCheckData> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        if (StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){
            permissionUtils.addPermission(queryFilter);
        }
        PageList<BizMqiCheckData> pageList = baseService.queryBizMqiCheckData(queryFilter);
        return pageList;
    }


    @GetMapping(value="get/{id}")
    @ApiOperation(value="根据ID查询MQI数据检查信息",httpMethod = "GET",notes = "根据ID查询MQI数据检查信息")
    public BizMqiCheckDataVo get(@ApiParam(name="id",value="业务对象主键", required = true)@PathVariable String id) throws Exception{
        return baseService.getBizBridgeSpecialById(id);
    }


    @GetMapping(value="getVo/{id}")
    @ApiOperation(value="根据ID查询MQI数据检查、附件信息",httpMethod = "GET",notes = "根据ID查询MQI数据检查、附件信息")
    public BizMqiCheckDataVo getVo(@ApiParam(name="id",value="业务对象主键", required = true)@PathVariable String id) throws Exception{
        return baseService.getVo(id);
    }

    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除MQI数据检查信息", httpMethod = "DELETE", notes = "批量删除MQI数据检查信息")
    public CommonResult<String> removes(@ApiParam(name = "ids", value = "多个主键之间用逗号分隔", required = true) @RequestParam String... ids) throws Exception {
        baseService.removeByIds(Arrays.asList(ids));
        return new CommonResult<String>(true, "删除成功");
    }

    @RequestMapping(value = "/updateBridge", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "逻辑删除MQI数据检查信息", httpMethod = "POST", notes = "逻辑删除MQI数据检查信息")
    public CommonResult<String> updateBridge(@ApiParam(name = "ids", value = "可视化分类ID集合以，隔开", required = true)
                                             @RequestParam(value = "ids", required = true) String ids) throws Exception {
        if (StringUtils.isNotBlank(ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<BizMqiCheckData> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_", idsList);
            updateWrapper.set("is_dele_", "1");
            baseService.update(null, updateWrapper);
        }
        return new CommonResult<>(true, "删除成功");
    }

}
