package com.artfess.yhxt.budget.manager.impl;


import com.artfess.yhxt.budget.dao.YearBudgetDetailedDao;
import com.artfess.yhxt.budget.manager.YearBudgetDetailedManager;
import com.artfess.yhxt.budget.manager.YearBudgetManager;
import com.artfess.yhxt.budget.model.YearBudgetDetailed;

import com.artfess.yhxt.budget.vo.YearBudgetDetailedVo;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.List;

/**
 * 年度总预算明细表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-02
 */
@Service
public class YearBudgetDetailedManagerImpl extends BaseManagerImpl<YearBudgetDetailedDao, YearBudgetDetailed> implements YearBudgetDetailedManager {

    @Autowired
    @Lazy
    private YearBudgetManager yearBudgetManager;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveYearBudget(Integer ascriptionYear,String yearBudgetId) {
        BigDecimal bigDecimal = baseMapper.saveYearBudget(ascriptionYear,yearBudgetId);
        yearBudgetManager.updateYear(bigDecimal,ascriptionYear);
    }

    @Override
    public PageList<YearBudgetDetailedVo> queryVo(QueryFilter<YearBudgetDetailed> queryFilter) {
//        PageBean pageBean = queryFilter.getPageBean();

        IPage<YearBudgetDetailedVo> result =  this.baseMapper.getYearBudgetDetailed(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public YearBudgetDetailed getYearBudgetDetailedById(String id) {
        return this.baseMapper.selectById(id);

    }
}
