package com.artfess.yhxt.basedata.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.basedata.vo.BizEmergencyRescueManagementVO;
import com.artfess.yhxt.statistics.vo.Org4RescueVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.basedata.model.BizEmergencyRescueManagement;
import com.artfess.yhxt.basedata.manager.BizEmergencyRescueManagementManager;

import java.util.List;

/**
 * 救援点统计 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xmz
 * @since 2022-04-19
 */
@RestController
@RequestMapping("/bizEmergencyRescueManagement/v1/")
@Api(tags = "救援点统计")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizEmergencyRescueManagementController extends BaseController<BizEmergencyRescueManagementManager, BizEmergencyRescueManagement> {
    @PostMapping("/query")
    @ApiOperation(value = "救援点-分页", httpMethod = "POST", notes = "救援点-分页")
    public PageList<BizEmergencyRescueManagementVO> list(@ApiParam(name = "queryFilter", value = "查询对象") @RequestBody QueryFilter<BizEmergencyRescueManagement> queryFilter)  {

        return baseService.queryEmergencyRescueManagement(queryFilter);
    }

    @RequestMapping(value = "getRescueVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取救援点统计", httpMethod = "POST", notes = "获取救援点统计")
    public List<Org4RescueVO> getRescueVo() throws Exception {
        return baseService.getRescueCount();
    }


    @PostMapping("save")
    @ApiOperation(value = "保存或修改救援点", httpMethod = "POST", notes = "保存或修改救援点")
    public CommonResult<String> save(@RequestBody BizEmergencyRescueManagement bizMaintenanceWorkArea)  {
        baseService.saveOrUpdate(bizMaintenanceWorkArea);
        return new CommonResult<>(true,"操作成功");
    }
}
