package com.artfess.yhxt.tree.manager.impl;

import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.yhxt.tree.model.TreeDictionary;
import com.artfess.yhxt.tree.dao.TreeDictionaryDao;
import com.artfess.yhxt.tree.manager.TreeDictionaryManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;

/**
 * 树形字典表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 超级管理员
 * @since 2021-08-04
 */
@Service
public class TreeDictionaryManagerImpl extends BaseManagerImpl<TreeDictionaryDao, TreeDictionary> implements TreeDictionaryManager {

    @Override
    public void checkNumber(TreeDictionary treeDictionary) {
        QueryWrapper<TreeDictionary> queryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotBlank(treeDictionary.getId())) {
            queryWrapper.notIn("id_", treeDictionary.getId());
        }
        queryWrapper.eq(StringUtils.isNotBlank(treeDictionary.getCompanyId()),"COMPANY_ID_",treeDictionary.getCompanyId());
        queryWrapper.eq(StringUtils.isNotBlank(treeDictionary.getCode()),"CODE_", treeDictionary.getCode())
                .or().eq(StringUtils.isNotBlank(treeDictionary.getPcode()),"PCODE_",treeDictionary.getPcode());
        List<TreeDictionary> list = baseMapper.selectList(queryWrapper);
        if (list.size() > 0) {
            throw new RuntimeException("该编码已经存在");
        }
    }

    @Override
    public Integer getSn() {
        HashMap<String, Object> map = new HashMap<>();
        IUser user= ContextUtil.getCurrentUser();
        if(ObjectUtils.isNotEmpty(user)){
            map.put("tenant_id_", user.getTenantId());
        }
        return this.getNextSequence(map);
    }
}
