package com.artfess.yhxt.budget.model;

import java.math.BigDecimal;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 年度总预算明细表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-02
 */
@ApiModel(value="BizYearBudgetDetailed对象", description="年度总预算明细表")
@TableName("biz_year_budget_detailed")
@Data
public class YearBudgetDetailed extends BizModel<YearBudgetDetailed> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "年度总预算表ID")
    @TableField("YEAR_BUDGET_ID_")
    private String yearBudgetId;

    @ApiModelProperty(value = "所属年限")
    @TableField("ASCRIPTION_YEAR_")
    private Integer ascriptionYear;

    @ApiModelProperty(value = "是否是追加预算，0：否，1：是")
    @TableField("ADD_TO_")
    private Integer addTo;

    @ApiModelProperty(value = "支出分类，1：付现成本支出，2：非付现成本支出")
    @TableField("EXPENDITURE_TYPE_")
    private String expenditureType;

    @ApiModelProperty(value = "预算分类")
    @TableField("BUDGET_TYPE_")
    private String budgetType;

    @ApiModelProperty(value = "预算项目,使用字典维护")
    @TableField("BUDGET_ITEM_")
    private String budgetItem;

    @ApiModelProperty(value = "预算内容")
    @TableField("BUDGET_CONTENT")
    private String budgetContent;

    @ApiModelProperty(value = "单位")
    @TableField("COMPANY_")
    private String company;

    @ApiModelProperty(value = "工程量")
    @TableField("QUANTITIES_")
    private BigDecimal quantities;

    @ApiModelProperty(value = "单价")
    @TableField("UNIT_PRICE_")
    private BigDecimal unitPrice;

    @ApiModelProperty(value = "总价")
    @TableField("TOTAL_PRICE_")
    private BigDecimal totalPrice;

    @ApiModelProperty(value = "备注")
    @TableField("REMARK_")
    private String remark;

    @ApiModelProperty(value = "形象进度")
    @TableField("IMAGE_PROGRESS_")
    private BigDecimal imageProgress;

    @ApiModelProperty(value = "排序")
    @TableField("SORT_")
    private BigDecimal sort;



}
