package com.artfess.yhxt.budget.controller;


import com.artfess.yhxt.budget.manager.YearBudgetManager;
import com.artfess.yhxt.budget.model.YearBudget;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.budget.vo.YearBudgetVo;
import com.artfess.yhxt.statistics.vo.Org4BudgetVO;
import com.artfess.yhxt.statistics.vo.OrgVO;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;

import java.util.Arrays;
import java.util.List;


/**
 * 年度总预算表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-02
 */
@RestController
@RequestMapping("/yearBudget/v1/")
@Api(tags = "年度总预算")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class YearBudgetController extends BaseController<YearBudgetManager, YearBudget> {

//    @RequestMapping(value = "saveYearBudget", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
//    @ApiOperation(value = "保存,修改年度总预算", httpMethod = "POST")
//    public CommonResult<String> saveYearBudget(@ApiParam(name = "yearBudget", value = "年度总预算对象") @RequestBody YearBudget yearBudget) throws Exception {
//        String msg = "添加成功";
//        this.baseService.checkYear(yearBudget);
//        if (StringUtils.isEmpty(yearBudget.getId())) {
//            yearBudget.setIsDele("0");
//            baseService.create(yearBudget);
//        } else {
//            baseService.update(yearBudget);
//            msg = "修改成功";
//        }
//        return new CommonResult<String>(msg);
//    }


    @RequestMapping(value = "getBudgetCountVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取预算数量", httpMethod = "POST", notes = "获取预算数量")
    public List<Org4BudgetVO> getBudgetCountVo(String year) throws Exception {
        return baseService.getBudgetCount(year);
    }

    @RequestMapping(value="getJson",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询年度总预算",httpMethod = "POST")
    public PageList<YearBudget> getJson(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<YearBudget> queryFilter) {
        queryFilter.addFilter("IS_DELE_", "0", QueryOP.EQUAL);
        PageList<YearBudget> pageList = baseService.queryYearBuget(queryFilter);
        return  pageList;
    }



//    @RequestMapping(value="get/{id}",method = RequestMethod.GET, produces={"application/json; charset=utf-8" })
//    @ApiOperation(value="根据ID查询年度总预算",httpMethod = "GET",notes = "根据ID查询年度总预算")
//    public YearBudget get(@ApiParam(name="id",value="业务对象主键", required = true)@PathVariable String id) throws Exception{
//        return baseService.getYearBudgetById(id);
//    }


    @RequestMapping(value = "updateYearBudget", method = RequestMethod.DELETE, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "逻辑删除年度总预算", httpMethod = "DELETE", notes = "逻辑删除年度总预算")
    public CommonResult<String> updateYearBudget(@ApiParam(name = "ids", value = "可视化分类ID集合以，隔开", required = true)
                                             @RequestParam(value = "ids", required = true) String ids) throws Exception {
        if (StringUtils.isNotBlank(ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<YearBudget> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_", idsList);
            updateWrapper.set("is_dele_", "1");
            baseService.update(null, updateWrapper);
        }
        return new CommonResult<>(true, "删除成功");
    }

    @RequestMapping(value="get/{id}",method = RequestMethod.GET, produces={"application/json; charset=utf-8" })
    @ApiOperation(value="根据ID查询年度总预算",httpMethod = "GET",notes = "根据ID查询年度总预算")
    public YearBudgetVo get(@ApiParam(name="id",value="业务对象主键", required = true)@PathVariable String id) throws Exception{
        return baseService.getYearBudgetVoById(id);
    }

    @RequestMapping(value = "saveYearBudget", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改年度总预算和明细", httpMethod = "POST")
    public CommonResult<String> saveYearBudgetVo(@ApiParam(name = "yearBudget", value = "年度总预算对象") @RequestBody YearBudgetVo yearBudgetVo) throws Exception {
        String msg = "添加成功";
        this.baseService.checkYear(yearBudgetVo.getYearBudget());
        if (StringUtils.isEmpty(yearBudgetVo.getYearBudget().getId())) {

            baseService.saveYearBudgetVo(yearBudgetVo);
        } else {
            baseService.updateYearBudgetVo(yearBudgetVo);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }

}
