package com.artfess.yhxt.basedata.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 路段实体对象
 *
 * @company 阿特菲斯
 * @author wangping
 * @email
 * @date 2021-07-15 17:49:50
 */
@ApiModel(description="路段实体对象")
@TableName("biz_road_section")
@JsonInclude
@Data
public class Road extends BizModel<Road> {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId("id_")
    private String id;

    @ApiModelProperty(value = "编号")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "简称")
    @TableField("SIMPLICITY_")
    private String simplicity;

    @ApiModelProperty(value = "名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "地址")
    @TableField("ADDRESS_")
    private String address;

    @ApiModelProperty(value = "所属公司ID")
    @TableField("COMPANY_ID")
    private String companyId;

    @ApiModelProperty(value = "所属公司多个ID")
    @TableField("COMPANY_IDS_")
    private String companyIds;

    @ApiModelProperty(value = "所属公司名称")
    @TableField("COMPANY_NAME")
    private String companyName;

    @ApiModelProperty(value = "所属路线ID(关联路线表ID)")
    @TableField("ROUTE_ID_")
    private String routeId;

    @ApiModelProperty(value = "所属路线NAME")
    @TableField("ROUTE_NAME_")
    private String routeName;

    @ApiModelProperty(value = "设计深度")
    @TableField("DESIGN_DEEP_")
    private String designDeep;

    @ApiModelProperty(value = "类型1:检查路段 2:费用路段")
    @TableField("TYPE_")
    private Integer type;

    @ApiModelProperty(value = "长度")
    @TableField("LENGTH_")
    private Float length;

    @ApiModelProperty(value = "宽度")
    @TableField("WIDTH_")
    private Float width;

    @ApiModelProperty(value = "路面类型 11:沥青混凝土 12:水泥混凝土 21:沥青贯入式 22:沥青碎石 23:沥青表面处治 31:砂石路面 32:石质路面 33:渣石路面 34:砖铺路面 35砼预制块 36:无路面")
    @TableField("ROADSURFACE_TYPE_")
    private String roadsurfaceType;

    @ApiModelProperty(value = "技术等级")
    @TableField("TECHNOLOGY_CLASS_")
    private String technologyClass;

    @ApiModelProperty(value = "车道类型:2:双向二车道 4:双向四车道 6:双向六车道")
    @TableField("DRIVEWAY_TYPE_")
    private String drivewayType;

    @ApiModelProperty(value = "车道宽度")
    @TableField("DRIVEWAY_WIDTH_")
    private Float drivewayWidth;

    @ApiModelProperty(value = "起始点")
    @TableField("STARTING_POINT_")
    private String startingPoint;

    @ApiModelProperty(value = "终点")
    @TableField("TERMINAL_POINT_")
    private String terminalPoint;

    @ApiModelProperty(value = "起点桩号")
    @TableField("START_PEG_")
    private Float startPeg;

    @ApiModelProperty(value = "止点桩号")
    @TableField("END_PEG_")
    private Float endPeg;

    @ApiModelProperty(value = "通过日期")
    @TableField("PASS_DAY_")
    private String passDay;

    @ApiModelProperty(value = "类型值")
    @TableField("TYPE_VALUE_")
    private String typeValue;

    @ApiModelProperty(value = "起点桩号KM")
    @TableField("START_PEG_K_")
    private String startPegK;

    @ApiModelProperty(value = "止点桩号KM")
    @TableField("END_PEG_K_")
    private String endPegK;

    @ApiModelProperty(value = "路面类型值")
    @TableField("ROADSURFACE_TYPE_VALUE_")
    private String roadsurfaceTypeValue;

    @ApiModelProperty(value = "技术等级值")
    @TableField("TECHNOLOGY_CLASS_VALUE_")
    private String technologyClassValue;

    @ApiModelProperty(value = "车道类型值")
    @TableField("DRIVEWAY_TYPE_VALUE_")
    private String drivewayTypeValue;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "上行方向起点经度")
    @TableField("UP_START_PEG_LNG_")
    private String upStartPegLng;

    @ApiModelProperty(value = "上行方向起点纬度")
    @TableField("UP_START_PEG_LAT_")
    private String upStartPegLat;

    @ApiModelProperty(value = "上行方向途径点经度")
    @TableField("UP_WAY_LNG_")
    private String upWayLng;

    @ApiModelProperty(value = "上行方向途径点纬度")
    @TableField("UP_WAY_LAT_")
    private String upWayLat;

    @ApiModelProperty(value = "下行方向途径点经度")
    @TableField("DW_WAY_LNG_")
    private String dwWayLng;

    @ApiModelProperty(value = "上行方向途径点纬度")
    @TableField("DW_WAY_LAT_")
    private String dwWayLat;

    @ApiModelProperty(value = "上行方向终点经度")
    @TableField("UP_END_PEG_LNG_")
    private String upEndPegLng;

    @ApiModelProperty(value = "上行方向终点纬度")
    @TableField("UP_END_PEG_LAT_")
    private String upEndPegLat;

    @ApiModelProperty(value = "下行方向起点经度")
    @TableField("DW_START_PEG_LNG_")
    private String dwStartPegLng;

    @ApiModelProperty(value = "下行方向起点纬度")
    @TableField("DW_START_PEG_LAT_")
    private String dwStartPegLat;

    @ApiModelProperty(value = "下行方向终点经度")
    @TableField("DW_END_PEG_LNG_")
    private String dwEndPegLng;

    @ApiModelProperty(value = "下行方向终点纬度")
    @TableField("DW_END_PEG_LAT_")
    private String dwEndPegLat;

    @ApiModelProperty(value = "里程(KM)")
    @TableField("MILEAGE_")
    private String mileage;

    @Override
    public String toString() {
        return "Road{" +
                "id='" + id + '\'' +
                ", code='" + code + '\'' +
                ", simplicity='" + simplicity + '\'' +
                ", name='" + name + '\'' +
                ", address='" + address + '\'' +
                ", companyId='" + companyId + '\'' +
                ", companyName='" + companyName + '\'' +
                ", routeId='" + routeId + '\'' +
                ", routeName='" + routeName + '\'' +
                ", designDeep='" + designDeep + '\'' +
                ", type=" + type +
                ", length=" + length +
                ", width=" + width +
                ", roadsurfaceType='" + roadsurfaceType + '\'' +
                ", technologyClass='" + technologyClass + '\'' +
                ", drivewayType='" + drivewayType + '\'' +
                ", drivewayWidth=" + drivewayWidth +
                ", startingPoint='" + startingPoint + '\'' +
                ", terminalPoint='" + terminalPoint + '\'' +
                ", startPeg=" + startPeg +
                ", endPeg=" + endPeg +
                ", passDay='" + passDay + '\'' +
                ", typeValue='" + typeValue + '\'' +
                ", startPegK='" + startPegK + '\'' +
                ", endPegK='" + endPegK + '\'' +
                ", roadsurfaceTypeValue='" + roadsurfaceTypeValue + '\'' +
                ", technologyClassValue='" + technologyClassValue + '\'' +
                ", drivewayTypeValue='" + drivewayTypeValue + '\'' +
                ", sn=" + sn +
                '}';
    }
}
