package com.artfess.yhxt.basedata.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 结构物车辆类型
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xmz
 * @since 2022-04-19
 */


@ApiModel(value="BizStructureVehicle对象", description="结构物车辆类型")
@TableName("biz_structure_vehicle")
@Data
public class BizStructureVehicle extends BaseModel<BizStructureVehicle> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主表id")
    @TableField("STRUCTURAL_ID_")
    private String structuralId;

    @ApiModelProperty(value = "数量")
    @TableField("QUANTITY_")
    private Integer quantity;

    @ApiModelProperty(value = "车辆类型")
    @TableField("TYPE_")
    private String type;

    @ApiModelProperty(value = "车辆类型值")
    @TableField("TYPE_VALUE_")
    private String typeValue;

    @ApiModelProperty(value = "车牌号")
    @TableField("CAR_NUMBER_")
    private String carNumber;

    @ApiModelProperty(value = "性质")
    @TableField("NATURE_")
    private String natrue;



    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getStructuralId() {
        return structuralId;
    }

    public void setStructuralId(String structuralId) {
        this.structuralId = structuralId;
    }
    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
    public String getTypeValue() {
        return typeValue;
    }

    public void setTypeValue(String typeValue) {
        this.typeValue = typeValue;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizStructureVehicle{" +
            "id=" + id +
            ", structuralId=" + structuralId +
            ", quantity=" + quantity +
            ", type=" + type +
            ", typeValue=" + typeValue +
        "}";
    }
}
