/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.contract.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.contract.manager.ContractManager;
import com.artfess.yhxt.contract.model.Contract;
import com.artfess.yhxt.contract.vo.ContractVo;
import com.artfess.yhxt.statistics.vo.Org4ContractVO;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/contract/v1/"})
@Api(tags={"\u5408\u540c\u63a5\u53e3"})
@ApiGroup(group={"group_biz"})
public class ContractController
extends BaseController<ContractManager, Contract> {
    @Resource
    private BaseContext baseContext;
    @Resource
    PermissionUtils permissionUtils;

    @RequestMapping(value={"getContractVo"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u65e5\u5e38\u517b\u62a4\u5408\u540c\u7edf\u8ba1", httpMethod="POST", notes="\u83b7\u53d6\u65e5\u5e38\u517b\u62a4\u5408\u540c\u7edf\u8ba1")
    public List<Org4ContractVO> getContractVo(String year) throws Exception {
        return ((ContractManager)this.baseService).getContractCount(year);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5408\u540c\u8868", httpMethod="POST")
    public PageList<Contract> getJson(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<Contract> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        if (StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId())) {
            this.permissionUtils.addPermission(queryFilter);
        }
        List querys = queryFilter.getQuerys();
        for (QueryField query : querys) {
            if (!query.getProperty().equals("contractDateLimit")) continue;
            query.setProperty("contract_date_limit_");
        }
        return ((ContractManager)this.baseService).queryContract(queryFilter);
    }

    @GetMapping(value={"get/{id}"})
    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u5408\u540c\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636eID\u67e5\u8be2\u5408\u540c\u4fe1\u606f")
    public ContractVo get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @PathVariable String id) throws Exception {
        return ((ContractManager)this.baseService).getContractById(id);
    }

    @RequestMapping(value={"/updateContract"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u903b\u8f91\u5220\u9664\u5408\u540c\u4fe1\u606f", httpMethod="POST", notes="\u903b\u8f91\u5220\u9664\u5408\u540c\u4fe1\u606f")
    public CommonResult<String> updateContract(@ApiParam(name="ids", value="\u53ef\u89c6\u5316\u5206\u7c7bID\u96c6\u5408\u4ee5\uff0c\u9694\u5f00", required=true) @RequestParam(value="ids", required=true) String ids) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.in((Object)"id_", idsList);
            updateWrapper.set((Object)"is_dele_", (Object)"1");
            ((ContractManager)this.baseService).update(null, (Wrapper)updateWrapper);
        }
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u5408\u540c\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u5408\u540c\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="vo", value="\u5408\u540c\u5bf9\u8c61") @RequestBody ContractVo vo) throws Exception {
        String id = ((ContractManager)this.baseService).saveContractVo(vo);
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f", (Object)id);
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539\u5408\u540c\u4fe1\u606f", httpMethod="POST", notes="\u4fee\u6539\u5408\u540c\u4fe1\u606f")
    public CommonResult<String> update(@ApiParam(name="vo", value="\u5408\u540c\u5bf9\u8c61") @RequestBody ContractVo vo) throws Exception {
        ((ContractManager)this.baseService).checkUniqueNumber(vo.getContract());
        ((ContractManager)this.baseService).updateContractVo(vo);
        return new CommonResult(true, "\u4fee\u6539\u6210\u529f");
    }

    @PostMapping(value={"/minioDrawingUpload"})
    @ApiOperation(value="\u5408\u540c\u6587\u4ef6\u4e0a\u4f20\u63a5\u53e3")
    public CommonResult<String> minioContractUpload(MultipartFile file, @ApiParam(name="sourceId", value="\u8d44\u6e90Id", required=true) @RequestParam(value="sourceId", required=true) String sourceId) {
        return new CommonResult(((ContractManager)this.baseService).minioContractUpload(file, sourceId));
    }

    @RequestMapping(value={"/downloadContractUpload"})
    @ApiOperation(value="\u5408\u540c\u6587\u4ef6\u4e0b\u8f7d\u63a5\u53e3", httpMethod="GET", notes="\u5408\u540c\u6587\u4ef6\u4e0b\u8f7d\u63a5\u53e3")
    public void downloadContractUpload(@ApiParam(name="ids", value="\u9644\u4ef6ID\u96c6\u5408\u4ee5\uff0c\u9694\u5f00") @RequestParam(value="ids", required=true) String ids, HttpServletResponse response) throws IOException {
        ((ContractManager)this.baseService).downloadContractUpload(ids, response);
    }

    @DeleteMapping(value={"/removesContract"})
    @ApiOperation(value="\u5220\u9664\u5b9a\u671f\u68c0\u67e5\u9644\u4ef6", httpMethod="DELETE", notes="\u5220\u9664\u75c5\u5bb3\u56fe\u7247")
    public CommonResult<String> minioContractDel(@ApiParam(name="ids", value="\u591a\u4e2a\u4e3b\u952e\u4e4b\u95f4\u7528\u9017\u53f7\u5206\u9694", required=true) @RequestParam String ids) throws Exception {
        ((ContractManager)this.baseService).minioContractDel(Arrays.asList(ids));
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/saveVo"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u5408\u540c\u4fe1\u606f\u3001\u9644\u4ef6", httpMethod="POST", notes="\u4fdd\u5b58\u5408\u540c\u4fe1\u606f\u3001\u9644\u4ef6")
    public CommonResult<String> saveVo(@ApiParam(name="vo", value="\u5408\u540c\u5bf9\u8c61") @RequestBody ContractVo vo) throws Exception {
        String id = "";
        Contract contract = vo.getContract();
        id = StringUtils.isEmpty((CharSequence)contract.getId()) ? ((ContractManager)this.baseService).saveContractVo(vo) : ((ContractManager)this.baseService).updateContractVo(vo);
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f", (Object)id);
    }
}

