/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.ljzc.loan.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.ljzc.loan.manager.AssetLoanInfoManager;
import com.artfess.ljzc.loan.model.AssetLoanInfo;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/biz/loan/loanInfo/v1/"})
@Api(tags={"\u503a\u6743\u8d44\u4ea7\u4fe1\u606f"})
@ApiGroup(group={"group_biz"})
public class AssetLoanInfoController
extends BaseController<AssetLoanInfoManager, AssetLoanInfo> {
    @PostMapping(value={"/queryPageLoanInfoAuthority"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u503a\u6743\u8d44\u4ea7")
    public PageList<AssetLoanInfo> queryPageCompanyAuthority(@RequestBody QueryFilter<AssetLoanInfo> queryFilter) {
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin()) {
            queryFilter.addFilter("belongs_org_full_id_", (Object)ContextUtil.getCurrentOrgFullId(), QueryOP.RIGHT_LIKE);
        }
        queryFilter.addFilter("is_dele_", (Object)"0", QueryOP.EQUAL);
        List sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("end_date_", Direction.DESC));
        sorter.add(new FieldSort("belongs_org_id_", Direction.ASC));
        queryFilter.setSorter(sorter);
        return ((AssetLoanInfoManager)this.baseService).query(queryFilter);
    }

    @PostMapping(value={"/insertLoanInfo"})
    @ApiOperation(value="\u4fdd\u5b58\u503a\u6743\u8d44\u4ea7")
    public CommonResult<String> insertLoanInfo(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody AssetLoanInfo assetLoanInfo) throws Exception {
        String id = ((AssetLoanInfoManager)this.baseService).insertLoanInfo(assetLoanInfo);
        if (StringUtil.isEmpty((String)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f\uff01", (Object)id);
    }

    @PostMapping(value={"/updateLoanInfo"})
    @ApiOperation(value="\u4fee\u6539\u503a\u6743\u8d44\u4ea7")
    public CommonResult<String> updateLoanInfo(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody AssetLoanInfo assetLoanInfo) throws Exception {
        boolean result = ((AssetLoanInfoManager)this.baseService).updateLoanInfo(assetLoanInfo);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/deleteLoanInfo"})
    @ApiOperation(value="\u5220\u9664\u503a\u6743\u8d44\u4ea7")
    public CommonResult<String> deleteLoanInfo(@ApiParam(name="id", value="id") @RequestParam String id) {
        boolean result = ((AssetLoanInfoManager)this.baseService).deleteLoanInfo(id);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/deleteBachLoanInfo"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u503a\u6743\u8d44\u4ea7")
    public CommonResult<String> deleteBachLoanInfo(String ... ids) {
        boolean result = ((AssetLoanInfoManager)this.baseService).deleteBachLoanInfo(Arrays.asList(ids));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/findById"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u503a\u6743\u8d44\u4ea7")
    public AssetLoanInfo findById(@RequestParam(name="id", required=true) String id) {
        AssetLoanInfo loanInfo = ((AssetLoanInfoManager)this.baseService).findLoanInfo(id);
        return loanInfo;
    }

    @PostMapping(value={"/auditLoan"})
    @ApiOperation(value="\u5ba1\u6838\u503a\u6743\u8d44\u4ea7\u5165\u5e93")
    public CommonResult<String> auditLoan(@ApiParam(name="status", value="\u5165\u5e93\u5ba1\u6838\u72b6\u6001\uff080\uff1a\u672a\u5ba1\u6838\uff0c1\uff1a\u5df2\u5ba1\u6838\uff09") @RequestParam String status, @ApiParam(name="msg", value="\u5ba1\u6838\u610f\u89c1") @RequestParam String msg, String ... ids) {
        boolean result = ((AssetLoanInfoManager)this.baseService).auditLoan(status, msg, Arrays.asList(ids));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5ba1\u6838\u5931\u8d25");
        }
        return new CommonResult();
    }
}

