package com.artfess.ljzc.welfare.model;

import java.math.BigDecimal;

import com.artfess.base.entity.AutoFillFullModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 公益资产使用信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@TableName("biz_asset_public_use")
@ApiModel(value="BizAssetPublicUse对象", description="公益资产使用信息")
public class AssetPublicUse extends AutoFillFullModel<AssetPublicUse> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "公益资产id")
    @TableField("public_id_")
    private String publicId;

    @ApiModelProperty(value = "填报年")
    @TableField("fill_year_")
    private Integer fillYear;

    @ApiModelProperty(value = "已建成规模")
    @TableField("completed_size_")
    private BigDecimal completedSize;

    @ApiModelProperty(value = "投入使用规模")
    @TableField("used_size_")
    private BigDecimal usedSize;

    @ApiModelProperty(value = "未使用规模")
    @TableField("unused_size_")
    private BigDecimal unusedSize;

    @ApiModelProperty(value = "在建规模")
    @TableField("building_size_")
    private BigDecimal buildingSize;

    @ApiModelProperty(value = "未来规划规模")
    @TableField("plan_size_")
    private BigDecimal planSize;

    @ApiModelProperty(value = "规模数量单位")
    @TableField("unit_")
    private String unit;

    @ApiModelProperty(value = "备注")
    @TableField("remark_")
    private String remark;


    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("is_dele_")
    @TableLogic
    private String isDele = "0";

    @ApiModelProperty(value = "租户ID")
    @TableField("tenant_id_")
    private String tenantId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPublicId() {
        return publicId;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public Integer getFillYear() {
        return fillYear;
    }

    public void setFillYear(Integer fillYear) {
        this.fillYear = fillYear;
    }

    public BigDecimal getCompletedSize() {
        return completedSize;
    }

    public void setCompletedSize(BigDecimal completedSize) {
        this.completedSize = completedSize;
    }

    public BigDecimal getUsedSize() {
        return usedSize;
    }

    public void setUsedSize(BigDecimal usedSize) {
        this.usedSize = usedSize;
    }

    public BigDecimal getUnusedSize() {
        return unusedSize;
    }

    public void setUnusedSize(BigDecimal unusedSize) {
        this.unusedSize = unusedSize;
    }

    public BigDecimal getBuildingSize() {
        return buildingSize;
    }

    public void setBuildingSize(BigDecimal buildingSize) {
        this.buildingSize = buildingSize;
    }

    public BigDecimal getPlanSize() {
        return planSize;
    }

    public void setPlanSize(BigDecimal planSize) {
        this.planSize = planSize;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizAssetPublicUse{" +
            "id=" + id +
            ", publicId=" + publicId +
            ", fillYear=" + fillYear +
            ", completedSize=" + completedSize +
            ", usedSize=" + usedSize +
            ", unusedSize=" + unusedSize +
            ", buildingSize=" + buildingSize +
            ", planSize=" + planSize +
            ", unit=" + unit +
            ", remark=" + remark +
            ", isDele=" + isDele +
            ", tenantId=" + tenantId +
        "}";
    }
}
