package com.artfess.ljzc.intangible.model;

import com.artfess.base.entity.BizDelModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;

import java.time.LocalDate;

import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;

/**
 * 无形资产信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@Data
@ApiModel(value="BizAssetIntangibleInfo对象", description="无形资产信息")
public class BizAssetIntangibleInfo extends BizDelModel<BizAssetIntangibleInfo> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请填写资产名称", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "资产名称")
    @TableField("name_")
    private String name;

    @NotBlank(message = "请填写资产编码", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "资产编码")
    @TableField("code_")
    private String code;

    @ApiModelProperty(value = "资产类型（字典：商标，专利，著作权，非专利技术）")
    @TableField("asset_type_")
    private String assetType;

    @ApiModelProperty(value = "有效起始日期")
    @TableField("start_date_")
    private LocalDate startDate;

    @ApiModelProperty(value = "有效截止日期")
    @TableField("end_date_")
    private LocalDate endDate;

    @ApiModelProperty(value = "风控措施")
    @TableField("risk_measures_")
    private String riskMeasures;

    @ApiModelProperty(value = "状态（字典：正常，到期）")
    @TableField("loan_status_")
    private String loanStatus;

    @ApiModelProperty(value = "归属单位ID")
    @TableField("belongs_org_id_")
    private String belongsOrgId;

    @ApiModelProperty(value = "归属单位")
    @TableField("belongs_org_name_")
    private String belongsOrgName;

    @ApiModelProperty(value = "归属单位fullid")
    @TableField("belongs_org_full_id_")
    private String belongsOrgFullId;

    @ApiModelProperty(value = "备注")
    @TableField("remark_")
    private String remark;

    @ApiModelProperty(value = "资产审核状态（-1：草稿，0：未审核，1：不通过，2：已审核）")
    @TableField("asset_audit_")
    private String assetAudit;

    @ApiModelProperty(value = "审核意见")
    @TableField("audit_msg_")
    private String assetMsg;

}
