package com.artfess.ljzc.business.model;

import com.artfess.base.entity.BizDelModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDate;

/**
 * 客户信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@Data
@ApiModel(value="BizCustomerInfo对象", description="客户信息")
public class BizCustomerInfo extends BizDelModel<BizCustomerInfo> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请选择客户类型", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "客户类型（1：个人，2：企业）")
    @TableField("clients_type_")
    private String clientsType;

    @NotBlank(message = "请输入客户名称", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "客户名称")
    @TableField("clients_name_")
    private String clientsName;

    @NotBlank(message = "请选择证件类型", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "证件类型（营业执照:0，身份证:1，驾驶证:2，军官证:3，护照:4）")
    @TableField("card_type_")
    private String cardType;

    @NotBlank(message = "请输入证件编码", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "证件编码")
    @TableField("card_no_")
    private String cardNo;

    @ApiModelProperty(value = "通信地址")
    @TableField("address_")
    private String address;

    @ApiModelProperty(value = "联系电话")
    @TableField("contact_tel_")
    private String contactTel;

    @ApiModelProperty(value = "E-mail")
    @TableField("email_")
    private String email;

    @ApiModelProperty(value = "开户银行")
    @TableField("bank_name_")
    private String bankName;

    @ApiModelProperty(value = "银行账号")
    @TableField("bank_no_")
    private String bankNo;

    @ApiModelProperty(value = "纳税人识别号")
    @TableField("tax_no_")
    private String taxNo;

    @ApiModelProperty(value = "联系人/法人")
    @TableField("contact_name_")
    private String contactName;

    @ApiModelProperty(value = "经营范围")
    @TableField("operate_range_")
    private String operateRange;

    @ApiModelProperty(value = "成立日期")
    @TableField("establish_time_")
    private LocalDate establishTime;

    @ApiModelProperty(value = "所属行业")
    @TableField("industry_")
    private String industry;

    @ApiModelProperty(value = "企业是否上市(1：是，0：否)")
    @TableField("is_listed_")
    private String isListed;

    @ApiModelProperty(value = "股票代码")
    @TableField("stock_code_")
    private String stockCode;

    @ApiModelProperty(value = "备注")
    @TableField("remark_")
    private String remark;

    @ApiModelProperty(value = "客户状态（0：正常，1：黑名单）")
    @TableField("clients_status_")
    private String clientsStatus;

    @ApiModelProperty(value = "所属业主id")
    @TableField("belongs_org_id_")
    private String belongsOrgId;

    @ApiModelProperty(value = "所属业主名称")
    @TableField("belongs_org_name_")
    private String belongsOrgName;

    @ApiModelProperty(value = "所属业主fullID")
    @TableField("belongs_org_full_id_")
    private String belongsOrgFullId;

    @ApiModelProperty(value = "租户ID")
    @TableField("tenant_id_")
    private String tenantId;

}
