package com.artfess.ljzc.business.manager.impl;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.vo.TreeVo;
import com.artfess.ljzc.business.model.BizAssetBusinessProject;
import com.artfess.ljzc.business.dao.BizAssetBusinessProjectDao;
import com.artfess.ljzc.business.manager.BizAssetBusinessProjectManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.uc.util.ContextUtil;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 经营性资产的项目信息business 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@Service
public class BizAssetBusinessProjectManagerImpl extends BaseManagerImpl<BizAssetBusinessProjectDao, BizAssetBusinessProject> implements BizAssetBusinessProjectManager {

    @Override
    public List<TreeVo> getOrgTree() {
        String fullId = ContextUtil.getCurrentOrgFullId();
        List<TreeVo> list = this.baseMapper.getOrgTree(fullId+"%");
        List<TreeVo> treeVos = BeanUtils.listToTree(list);
        return treeVos;
    }
}
