package com.artfess.ljzc.business.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.ljzc.business.model.BizAssetBusinessInfo;
import com.artfess.uc.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.ljzc.business.model.BizCustomerInfo;
import com.artfess.ljzc.business.manager.BizCustomerInfoManager;

/**
 * 客户信息 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@Slf4j
@Api(tags = "经营性资产-客户信息")
@RestController
@RequestMapping("/biz/customerInfo/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizCustomerInfoController extends BaseController<BizCustomerInfoManager, BizCustomerInfo> {

    @GetMapping("/black/{id}")
    @ApiOperation("添加、删除黑名单")
    public CommonResult<String> black(@ApiParam(name="id", value="实体id") @PathVariable String id) {
        Boolean result = baseService.black(id);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "操作失败");
        }
        return new CommonResult<>();
    }

    @Override
    @PostMapping(value = "/query", produces = {"application/json; charset=utf-8"})
    @ApiOperation("分页查询结果")
    public PageList<BizCustomerInfo> query(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizCustomerInfo> queryFilter) {
        String fullId = ContextUtil.getCurrentOrgFullId();
        queryFilter.addFilter("belongs_org_full_id_", fullId, QueryOP.RIGHT_LIKE);
        return baseService.query(queryFilter);
    }

}
