/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.ljzc.business.controller;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.ljzc.business.manager.BizAssetBusinessInfoManager;
import com.artfess.ljzc.business.model.BizAssetBusinessInfo;
import com.artfess.uc.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ecf\u8425\u6027\u8d44\u4ea7-\u8d44\u4ea7\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/biz/assetBusinessInfo/v1/"})
@ApiGroup(group={"group_biz"})
public class BizAssetBusinessInfoController
extends BaseController<BizAssetBusinessInfoManager, BizAssetBusinessInfo> {
    private static final Logger log = LoggerFactory.getLogger(BizAssetBusinessInfoController.class);

    @GetMapping(value={"/audit"})
    @ApiOperation(value="\u6279\u91cf\u5ba1\u6838")
    public CommonResult<String> auditAsset(@ApiParam(name="status", value="\u5ba1\u6838\u72b6\u6001") @RequestParam String status, @ApiParam(name="assetMsg", value="\u5ba1\u6838\u610f\u89c1") @RequestParam String assetMsg, String ... ids) {
        boolean result = ((BizAssetBusinessInfoManager)this.baseService).audit(Arrays.asList(ids), status, assetMsg);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<BizAssetBusinessInfo> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizAssetBusinessInfo> queryFilter) {
        String fullId = ContextUtil.getCurrentOrgFullId();
        queryFilter.addFilter("belongs_org_full_id_", (Object)fullId, QueryOP.RIGHT_LIKE);
        return ((BizAssetBusinessInfoManager)this.baseService).findByPage(queryFilter);
    }

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @Validated(value={AddGroup.class}) @RequestBody BizAssetBusinessInfo t) {
        boolean result = ((BizAssetBusinessInfoManager)this.baseService).createInfo(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return CommonResult.success((Object)((Object)t), null);
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53")
    public BizAssetBusinessInfo getById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((BizAssetBusinessInfoManager)this.baseService).findById(id);
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @Validated(value={UpdateGroup.class}) @RequestBody BizAssetBusinessInfo t) {
        boolean result = ((BizAssetBusinessInfoManager)this.baseService).updateInfo(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return CommonResult.success((Object)((Object)t), null);
    }

    @DeleteMapping(value={"/"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIds(String ... ids) {
        boolean result = ((BizAssetBusinessInfoManager)this.baseService).removeInfo(Arrays.asList(ids));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/gatherStatistics"})
    @ApiOperation(value="\u7edf\u8ba1-\u8d44\u4ea7\u6c47\u603b")
    public CommonResult<String> gatherStatistics() {
        String fullId = ContextUtil.getCurrentOrgFullId();
        JSONObject result = ((BizAssetBusinessInfoManager)this.baseService).gatherStatistics(fullId);
        return CommonResult.success((Object)result, (String)"");
    }

    @PostMapping(value={"/belongStatistics"})
    @ApiOperation(value="\u7edf\u8ba1-\u8d44\u4ea7\u5f52\u5c5e\u5206\u5e03")
    public CommonResult<String> belongStatistics() {
        String fullId = ContextUtil.getCurrentOrgFullId();
        List<JSONObject> result = ((BizAssetBusinessInfoManager)this.baseService).belongStatistics(fullId);
        return CommonResult.success(result, (String)"");
    }

    @PostMapping(value={"/natureStatistics"})
    @ApiOperation(value="\u7edf\u8ba1-\u8d44\u4ea7\u5c5e\u6027\u5206\u5e03")
    public CommonResult<String> natureStatistics() {
        String fullId = ContextUtil.getCurrentOrgFullId();
        List<JSONObject> result = ((BizAssetBusinessInfoManager)this.baseService).natureStatistics(fullId);
        return CommonResult.success(result, (String)"");
    }

    @PostMapping(value={"/typeStatistics"})
    @ApiOperation(value="\u7edf\u8ba1-\u8d44\u4ea7\u7c7b\u578b\u5206\u5e03")
    public CommonResult<String> typeStatistics() {
        String fullId = ContextUtil.getCurrentOrgFullId();
        List<JSONObject> result = ((BizAssetBusinessInfoManager)this.baseService).typeStatistics(fullId);
        return CommonResult.success(result, (String)"");
    }

    @PostMapping(value={"/sourceStatistics"})
    @ApiOperation(value="\u7edf\u8ba1-\u8d44\u4ea7\u6765\u6e90\u60c5\u51b5")
    public CommonResult<String> sourceStatistics() {
        String fullId = ContextUtil.getCurrentOrgFullId();
        List<JSONObject> result = ((BizAssetBusinessInfoManager)this.baseService).sourceStatistics(fullId);
        return CommonResult.success(result, (String)"");
    }

    @PostMapping(value={"/statusStatistics"})
    @ApiOperation(value="\u7edf\u8ba1-\u8d44\u4ea7\u72b6\u6001\u60c5\u51b5")
    public CommonResult<String> statusStatistics() {
        String fullId = ContextUtil.getCurrentOrgFullId();
        List<JSONObject> result = ((BizAssetBusinessInfoManager)this.baseService).statusStatistics(fullId);
        return CommonResult.success(result, (String)"");
    }

    @PostMapping(value={"/operationStatistics"})
    @ApiOperation(value="\u7edf\u8ba1-\u8d44\u4ea7\u4e1a\u6001\u60c5\u51b5")
    public CommonResult<String> operationStatistics() {
        String fullId = ContextUtil.getCurrentOrgFullId();
        List<JSONObject> result = ((BizAssetBusinessInfoManager)this.baseService).operationStatistics(fullId);
        return CommonResult.success(result, (String)"");
    }
}

