package com.artfess.base.jdbc;

import com.artfess.base.exception.ApplicationException;
import org.springframework.jdbc.core.JdbcTemplate;

import javax.sql.DataSource;
import java.util.List;
import java.util.regex.Pattern;

public interface JdbcDao {
    Pattern pattern = Pattern.compile("\t|\r|\n");

    JdbcTemplate initJdbcTemplate(String alias);

    void removeCache(String key);

    boolean checkConnection(String dataSourceId, String url, String userName, String pwd, String driver);

    DataSource getDataSource(JdbcTemplate jdbcTemplate);

    void batchUpdate(JdbcTemplate jdbcTemplate,String[] paramArrayOfString) throws ApplicationException;

    int[] batchUpdateData(JdbcTemplate jdbcTemplate,String sql, List<Object[]> dataSet);

    void batchUpdate(JdbcTemplate jdbcTemplate,String paramString, List<Object[]> paramList) throws ApplicationException;



}