

/**
 * 重置表单对象，仅保留 retainData 中指定的字段
 * @param copyForm 需要重置的表单对象（会被原地修改）
 * @param retainData 需要保留的字段名数组
 * @returns 处理后的表单对象
 */
export const resetFormValue = (copyForm: Record<string, any>, retainData: string[] = []) => {
    Object.keys(copyForm).forEach((key) => {
        if (!retainData.includes(key)) {
            delete copyForm[key];
        }
    });
    return copyForm;
};